/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils.managers;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import androidx.annotation.NonNull;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ly.warp.sdk.Warply;
import ly.warp.sdk.db.WarplyDBHelper;
import ly.warp.sdk.io.callbacks.AddressHook;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.callbacks.CardsHook;
import ly.warp.sdk.io.callbacks.ContactHook;
import ly.warp.sdk.io.callbacks.ContentHook;
import ly.warp.sdk.io.callbacks.CouponsHook;
import ly.warp.sdk.io.callbacks.CouponsetsHook;
import ly.warp.sdk.io.callbacks.MerchantCategoriesHook;
import ly.warp.sdk.io.callbacks.MerchantsHook;
import ly.warp.sdk.io.callbacks.NewCampaignsHook;
import ly.warp.sdk.io.callbacks.PacingDetailsHook;
import ly.warp.sdk.io.callbacks.PointsHook;
import ly.warp.sdk.io.callbacks.ProductsHook;
import ly.warp.sdk.io.callbacks.SharingHook;
import ly.warp.sdk.io.callbacks.TagsCategoriesHook;
import ly.warp.sdk.io.callbacks.TagsHook;
import ly.warp.sdk.io.callbacks.TransactionsHook;
import ly.warp.sdk.io.models.AddressList;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.Card;
import ly.warp.sdk.io.models.CardList;
import ly.warp.sdk.io.models.Consumer;
import ly.warp.sdk.io.models.ContentList;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.CouponsetsList;
import ly.warp.sdk.io.models.LoyaltySDKDynatraceEventModel;
import ly.warp.sdk.io.models.Merchant;
import ly.warp.sdk.io.models.MerchantCategoriesList;
import ly.warp.sdk.io.models.MerchantList;
import ly.warp.sdk.io.models.NewCampaign;
import ly.warp.sdk.io.models.PacingDetails;
import ly.warp.sdk.io.models.PointsList;
import ly.warp.sdk.io.models.ProductList;
import ly.warp.sdk.io.models.SharingList;
import ly.warp.sdk.io.models.TagsCategoriesList;
import ly.warp.sdk.io.models.TagsList;
import ly.warp.sdk.io.models.TelematicsHistory;
import ly.warp.sdk.io.models.TransactionsList;
import ly.warp.sdk.io.models.TripMetrics;
import ly.warp.sdk.io.models.UnifiedCampaignModel;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.io.request.CosmoteCouponSharingRequest;
import ly.warp.sdk.io.request.CosmotePostEventRequest;
import ly.warp.sdk.io.request.CosmoteRetrieveSharingRequest;
import ly.warp.sdk.io.request.CosmoteSharingRequest;
import ly.warp.sdk.io.request.CosmoteSubmitOrderRequest;
import ly.warp.sdk.io.request.PacingCalculateRequest;
import ly.warp.sdk.io.request.PacingDetailsRequest;
import ly.warp.sdk.io.request.WarplyAddAddressRequest;
import ly.warp.sdk.io.request.WarplyAddCardRequest;
import ly.warp.sdk.io.request.WarplyAuthorizeRequest;
import ly.warp.sdk.io.request.WarplyChangePasswordRequest;
import ly.warp.sdk.io.request.WarplyConsumerRequest;
import ly.warp.sdk.io.request.WarplyContactRequest;
import ly.warp.sdk.io.request.WarplyContentRequest;
import ly.warp.sdk.io.request.WarplyCosmoteUserRequest;
import ly.warp.sdk.io.request.WarplyDeleteAddressRequest;
import ly.warp.sdk.io.request.WarplyDeleteCardRequest;
import ly.warp.sdk.io.request.WarplyEditAddressRequest;
import ly.warp.sdk.io.request.WarplyEditConsumerRequest;
import ly.warp.sdk.io.request.WarplyForgotPasswordRequest;
import ly.warp.sdk.io.request.WarplyGetAddressRequest;
import ly.warp.sdk.io.request.WarplyGetCampaignsRequest;
import ly.warp.sdk.io.request.WarplyGetCardsRequest;
import ly.warp.sdk.io.request.WarplyGetCouponsetsRequest;
import ly.warp.sdk.io.request.WarplyIntegrationRequest;
import ly.warp.sdk.io.request.WarplyLoginRequest;
import ly.warp.sdk.io.request.WarplyMerchantCategoriesRequest;
import ly.warp.sdk.io.request.WarplyMerchantsRequest;
import ly.warp.sdk.io.request.WarplyPointHistoryRequest;
import ly.warp.sdk.io.request.WarplyProductsRequest;
import ly.warp.sdk.io.request.WarplyRedeemCouponRequest;
import ly.warp.sdk.io.request.WarplyRedeemProductRequest;
import ly.warp.sdk.io.request.WarplyRefreshTokenRequest;
import ly.warp.sdk.io.request.WarplyRegisterRequest;
import ly.warp.sdk.io.request.WarplyRequestOTPRequest;
import ly.warp.sdk.io.request.WarplyResetPasswordRequest;
import ly.warp.sdk.io.request.WarplySharingHistoryRequest;
import ly.warp.sdk.io.request.WarplyTagsCategoriesRequest;
import ly.warp.sdk.io.request.WarplyTagsRequest;
import ly.warp.sdk.io.request.WarplyTokenAuthorizeRequest;
import ly.warp.sdk.io.request.WarplyTransactionHistoryRequest;
import ly.warp.sdk.io.request.WarplyUploadConsumerPhotoRequest;
import ly.warp.sdk.io.request.WarplyUserCouponsRequest;
import ly.warp.sdk.io.request.WarplyValidateCouponRequest;
import ly.warp.sdk.io.request.WarplyVerifyOTPRequest;
import ly.warp.sdk.io.request.WarplyVerifyTicketRequest;
import ly.warp.sdk.io.volley.ApiClient;
import ly.warp.sdk.io.volley.ApiService;
import ly.warp.sdk.services.EventCampaignService;
import ly.warp.sdk.services.EventRewardsCouponsService;
import ly.warp.sdk.services.EventUnifiedCouponsService;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyDeviceInfoCollector;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class WarplyManager {
    private static final int MAX_RETRIES = 3;

    public static void getProducts(WarplyProductsRequest request, CallbackReceiver<ProductList> receiver) {
        if (request == null) {
            request = new WarplyProductsRequest();
        }
        WarpUtils.log("************* WARPLY Microapp ********************");
        WarpUtils.log("[WARP Trace] Products Microapp is active");
        WarpUtils.log("**************************************************");
        request = request != null ? request : new WarplyProductsRequest();
        Warply.postReceiveMicroappData("products", request.toJson(), new ProductsHook(receiver, request.getSignature()));
    }

    public static void getMerchants(WarplyMerchantsRequest request, CallbackReceiver<MerchantList> receiver) {
        if (request == null) {
            request = new WarplyMerchantsRequest();
        }
        WarpUtils.log("************* WARPLY Microapp ********************");
        WarpUtils.log("[WARP Trace] Shops Microapp is active");
        WarpUtils.log("**************************************************");
        request = request != null ? request : new WarplyMerchantsRequest();
        Warply.postReceiveMicroappData("shops", request.toJson(), new MerchantsHook(receiver, request.getSignature()));
    }

    public static void getContent(WarplyContentRequest request, CallbackReceiver<ContentList> receiver) {
        if (request == null) {
            request = new WarplyContentRequest();
        }
        WarpUtils.log("************* WARPLY Microapp ********************");
        WarpUtils.log("[WARP Trace] Content Microapp is active");
        WarpUtils.log("**************************************************");
        request = request != null ? request : new WarplyContentRequest();
        Warply.postReceiveMicroappData("content", request.toJson(), new ContentHook(receiver, request.getSignature()));
    }

    public static void getMerchantCategories(WarplyMerchantCategoriesRequest request, CallbackReceiver<MerchantCategoriesList> receiver) {
        if (request == null) {
            request = new WarplyMerchantCategoriesRequest();
        }
        WarpUtils.log("************* WARPLY Microapp ********************");
        WarpUtils.log("[WARP Trace] ShopCategories Microapp is active");
        WarpUtils.log("**************************************************");
        request = request != null ? request : new WarplyMerchantCategoriesRequest();
        Warply.postReceiveMicroappData("shops", request.toJson(), new MerchantCategoriesHook(receiver, request.getSignature()));
    }

    public static void getTagsCategories(WarplyTagsCategoriesRequest request, CallbackReceiver<TagsCategoriesList> receiver) {
        if (request == null) {
            request = new WarplyTagsCategoriesRequest();
        }
        WarpUtils.log("************* WARPLY Microapp ********************");
        WarpUtils.log("[WARP Trace] TagsCategories Microapp is active");
        WarpUtils.log("**************************************************");
        request = request != null ? request : new WarplyTagsCategoriesRequest();
        Warply.postReceiveMicroappData("tags", request.toJson(), new TagsCategoriesHook(receiver, request.getSignature()));
    }

    public static void getTags(WarplyTagsRequest request, CallbackReceiver<TagsList> receiver) {
        if (request == null) {
            request = new WarplyTagsRequest();
        }
        WarpUtils.log("************* WARPLY Microapp ********************");
        WarpUtils.log("[WARP Trace] TagsCategories Microapp is active");
        WarpUtils.log("**************************************************");
        request = request != null ? request : new WarplyTagsRequest();
        Warply.postReceiveMicroappData("tags", request.toJson(), new TagsHook(receiver, request.getSignature()));
    }

    public static void sendContact(WarplyContactRequest request, CallbackReceiver<JSONObject> receiver) {
        if (request == null) {
            request = new WarplyContactRequest();
        }
        WarpUtils.log("************* WARPLY Microapp ********************");
        WarpUtils.log("[WARP Trace] Contact Microapp is active");
        WarpUtils.log("**************************************************");
        request = request != null ? request : new WarplyContactRequest();
        Warply.postReceiveMicroappData("contact", request.toJson(), new ContactHook(receiver, request.getSignature()));
    }

    public static void login(final WarplyLoginRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Login Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Login Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(false, "login", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveClientAccess(result.optString("client_id", ""), result.optString("client_secret", ""));
                    WarplyManager.authorize(new WarplyAuthorizeRequest().setInitialData(request.toJson()).setAuthorizeData(result).setIsRegister(false), result, false, receiver);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    private static void authorize(WarplyAuthorizeRequest request, final JSONObject receivedData, final boolean isRegister, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Authorize Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Authorize Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(false, "web_authorize", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                if (result.has("code")) {
                    try {
                        receivedData.putOpt("code", (Object)result.optString("code"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    WarplyManager.tokenAuthorize(new WarplyTokenAuthorizeRequest().setAuthorizeData(receivedData).setIsRegister(isRegister), receiver);
                } else {
                    receiver.onFailure(2);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    private static void tokenAuthorize(WarplyTokenAuthorizeRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Token Authorize Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Token Authorize Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(false, "token", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                if (result.has("token_type")) {
                    WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveAuthAccess(result.optString("access_token", ""), result.optString("refresh_token", ""));
                    JSONObject newResult = new JSONObject();
                    try {
                        newResult.putOpt("status", (Object)1);
                        newResult.putOpt("message", (Object)"Success");
                        receiver.onSuccess(newResult);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        receiver.onFailure(2);
                    }
                } else {
                    receiver.onFailure(2);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    private static void refreshToken(WarplyRefreshTokenRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Refresh Authorize Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Refresh Authorize Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(false, "token", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                if (result.has("token_type")) {
                    WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveAuthAccess(result.optString("access_token", ""), result.optString("refresh_token", ""));
                    JSONObject newResult = new JSONObject();
                    try {
                        newResult.putOpt("status", (Object)1);
                        newResult.putOpt("message", (Object)"Success");
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_refresh_token_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        receiver.onSuccess(newResult);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_refresh_token_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_refresh_token_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(2);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_refresh_token_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                if (errorCode == 401) {
                    WarplyDBHelper.getInstance(Warply.getWarplyContext()).deleteAuth();
                    WarplyDBHelper.getInstance(Warply.getWarplyContext()).deleteClient();
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void register(final WarplyRegisterRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Register Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Register Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(false, "register", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    if (request.getAutologin()) {
                        WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveClientAccess(result.optString("client_id", ""), result.optString("client_secret", ""));
                        WarplyManager.authorize(new WarplyAuthorizeRequest().setInitialData(request.toJson()).setAuthorizeData(result).setIsRegister(true), result, true, receiver);
                    } else {
                        JSONObject newResult = new JSONObject();
                        try {
                            newResult.putOpt("status", (Object)1);
                            newResult.putOpt("message", (Object)"Success");
                            receiver.onSuccess(newResult);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            receiver.onFailure(2);
                        }
                    }
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void getConsumer(final WarplyConsumerRequest request, final CallbackReceiver<Consumer> receiver) {
        WarpUtils.log("************* WARPLY Consumer Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Consumer Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_profile_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    result = result.optJSONObject("result");
                    if (result == null) {
                        receiver.onFailure(2);
                        return;
                    }
                    receiver.onSuccess(new Consumer(result));
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_profile_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getConsumer(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_profile_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void logout(final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Logout ********************");
        WarpUtils.log("[WARP Trace] WARPLY Logout is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("access_token", WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
        jsonParams.put("refresh_token", WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("refresh_token"));
        RequestBody loginRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParams).toString());
        Call<ResponseBody> logoutCall = service.logoutUser(WarplyProperty.getAppUuid(Warply.getWarplyContext()), loginRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp));
        logoutCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 200 && response.body() != null) {
                    WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
                    WarpUtils.setUserTag(Warply.getWarplyContext(), "");
                    WarplyManagerHelper.clearCCMSLoyaltyCampaigns();
                    WarplyDBHelper.getInstance(Warply.getWarplyContext()).deleteAuth();
                    WarplyDBHelper.getInstance(Warply.getWarplyContext()).deleteClient();
                    JSONObject newResult = new JSONObject();
                    try {
                        newResult.putOpt("status", (Object)1);
                        newResult.putOpt("message", (Object)"Success");
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_logout_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        receiver.onSuccess(newResult);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_logout_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_logout_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(response.code());
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_logout_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(2);
            }
        });
    }

    public static void changePassword(final WarplyChangePasswordRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Change Password Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Change Password Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "change_password", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    receiver.onSuccess(result);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.changePassword(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void editConsumer(final WarplyEditConsumerRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Edit Consumer Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Edit Consumer Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    receiver.onSuccess(result);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.editConsumer(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void uploadConsumerPhoto(final WarplyUploadConsumerPhotoRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Upload Consumer Photo Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Upload Consumer Photo Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(false, "handle_image", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    receiver.onSuccess(result);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.uploadConsumerPhoto(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void addCard(final WarplyAddCardRequest request, final CallbackReceiver<Card> receiver) {
        WarpUtils.log("************* WARPLY Add Card Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Add Card Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData("cards", true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    if ((result = result.optJSONObject("result")) == null) {
                        receiver.onFailure(2);
                        return;
                    }
                    receiver.onSuccess(new Card(result));
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.addCard(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void getCards(final WarplyGetCardsRequest request, final CallbackReceiver<CardList> receiver) {
        WarpUtils.log("************* WARPLY Get Cards Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Cards Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData("cards", true, "context", request.toJson(), new CardsHook(new CallbackReceiver<CardList>(){

            @Override
            public void onSuccess(CardList result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getCards(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        }, request.getSignature()));
    }

    public static void deleteCard(final WarplyDeleteCardRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Delete Card Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Delete Card Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData("cards", true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    receiver.onSuccess(result);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.deleteCard(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void getCosmoteUser(String guid, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Cosmote User Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Cosmote User Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("user_identifier", guid);
        RequestBody loginRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParams).toString());
        Call<ResponseBody> loginCall = service.cosmoteUser(WarplyProperty.getAppUuid(Warply.getWarplyContext()), loginRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp), "Basic MVBQNFhCQzhFYTJBaUdCNkJWZGFGUERlTTNLQ3kzMjU6YzViMzAyZDY5N2FiNGY3NzhiNThhMTg0YzBkZWRmNGU=");
        loginCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 200 && response.body() != null) {
                    JSONObject jobjLoginResponse = null;
                    try {
                        jobjLoginResponse = new JSONObject(((ResponseBody)response.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjLoginResponse != null && jobjLoginResponse.has("status") && jobjLoginResponse.optString("status", "2").equals("1")) {
                        JSONObject tokens = jobjLoginResponse.optJSONObject("result");
                        if (tokens != null) {
                            WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveClientAccess(tokens.optString("client_id", ""), tokens.optString("client_secret", ""));
                            WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveAuthAccess(tokens.optString("access_token", ""), tokens.optString("refresh_token", ""));
                            JSONObject newResult = new JSONObject();
                            try {
                                newResult.putOpt("status", (Object)1);
                                newResult.putOpt("message", (Object)"Success");
                                receiver.onSuccess(newResult);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                receiver.onFailure(2);
                            }
                            WarplyManager.getConsumer(new WarplyConsumerRequest(), new CallbackReceiver<Consumer>(){

                                @Override
                                public void onSuccess(Consumer result) {
                                    JSONObject profMetadata;
                                    WarplyManagerHelper.setConsumerInternal(result);
                                    if (result != null) {
                                        profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata());
                                        if (profMetadata != null && profMetadata.has("nonTelco")) {
                                            WarpUtils.setUserNonTelco(Warply.getWarplyContext(), profMetadata.optBoolean("nonTelco"));
                                        } else {
                                            WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
                                        }
                                    }
                                    if (result != null && (profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata())) != null && profMetadata.has("badge")) {
                                        WarpUtils.setUserTag(Warply.getWarplyContext(), profMetadata.optString("badge"));
                                    }
                                }

                                @Override
                                public void onFailure(int errorCode) {
                                }
                            });
                        } else {
                            receiver.onFailure(2);
                        }
                    } else {
                        receiver.onFailure(2);
                    }
                } else {
                    receiver.onFailure(response.code());
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                receiver.onFailure(2);
            }
        });
    }

    public static void verifyTicket(String ticket, String guid, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Verify Ticket Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Verify Ticket Request is active");
        WarpUtils.log("**************************************************");
        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
        WarpUtils.setUserTag(Warply.getWarplyContext(), "");
        WarplyManagerHelper.clearCCMSLoyaltyCampaigns();
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("app_uuid", WarplyProperty.getAppUuid(Warply.getWarplyContext()));
        jsonParams.put("guid", guid);
        jsonParams.put("ticket", ticket);
        RequestBody loginRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParams).toString());
        Call<ResponseBody> loginCall = service.verifyUser(loginRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp));
        loginCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 200 && response.body() != null) {
                    JSONObject jobjLoginResponse = null;
                    try {
                        jobjLoginResponse = new JSONObject(((ResponseBody)response.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjLoginResponse != null && jobjLoginResponse.has("status") && jobjLoginResponse.optString("status", "2").equals("1")) {
                        JSONObject tokens = jobjLoginResponse.optJSONObject("result");
                        if (tokens != null) {
                            WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveClientAccess(tokens.optString("client_id", ""), tokens.optString("client_secret", ""));
                            WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveAuthAccess(tokens.optString("access_token", ""), tokens.optString("refresh_token", ""));
                            JSONObject newResult = new JSONObject();
                            try {
                                newResult.putOpt("status", (Object)1);
                                newResult.putOpt("message", (Object)"Success");
                                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                dynatraceEvent.setEventName("custom_success_login_loyalty");
                                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                                receiver.onSuccess(newResult);
                            }
                            catch (JSONException e) {
                                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                dynatraceEvent.setEventName("custom_error_login_loyalty");
                                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                                e.printStackTrace();
                                receiver.onFailure(2);
                            }
                            WarplyManager.getConsumer(new WarplyConsumerRequest(), new CallbackReceiver<Consumer>(){

                                @Override
                                public void onSuccess(Consumer result) {
                                    JSONObject profMetadata;
                                    WarplyManagerHelper.setConsumerInternal(result);
                                    if (result != null) {
                                        profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata());
                                        if (profMetadata != null && profMetadata.has("nonTelco")) {
                                            WarpUtils.setUserNonTelco(Warply.getWarplyContext(), profMetadata.optBoolean("nonTelco"));
                                        } else {
                                            WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
                                        }
                                    }
                                    if (result != null && (profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata())) != null && profMetadata.has("badge")) {
                                        WarpUtils.setUserTag(Warply.getWarplyContext(), profMetadata.optString("badge"));
                                    }
                                }

                                @Override
                                public void onFailure(int errorCode) {
                                }
                            });
                        } else {
                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                            dynatraceEvent.setEventName("custom_error_login_loyalty");
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                            receiver.onFailure(2);
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_login_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_login_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(response.code());
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_login_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(2);
            }
        });
    }

    public static void verifyTicket(WarplyVerifyTicketRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Verify Ticket Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Verify Ticket Request is active");
        WarpUtils.log("**************************************************");
        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
        WarpUtils.setUserTag(Warply.getWarplyContext(), "");
        WarplyManagerHelper.clearCCMSLoyaltyCampaigns();
        Warply.postReceiveMicroappData(false, "verify", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("result", 2);
                if (status == 1) {
                    JSONObject tokens = result.optJSONObject("tokens");
                    if (tokens != null) {
                        WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveClientAccess(tokens.optString("client_id", ""), tokens.optString("client_secret", ""));
                        WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveAuthAccess(tokens.optString("access_token", ""), tokens.optString("refresh_token", ""));
                        JSONObject newResult = new JSONObject();
                        try {
                            newResult.putOpt("status", (Object)1);
                            newResult.putOpt("message", (Object)"Success");
                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                            dynatraceEvent.setEventName("custom_success_login_loyalty");
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                            receiver.onSuccess(newResult);
                        }
                        catch (JSONException e) {
                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                            dynatraceEvent.setEventName("custom_error_login_loyalty");
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                            e.printStackTrace();
                            receiver.onFailure(2);
                        }
                        WarplyManager.getConsumer(new WarplyConsumerRequest(), new CallbackReceiver<Consumer>(){

                            @Override
                            public void onSuccess(Consumer result) {
                                JSONObject profMetadata;
                                WarplyManagerHelper.setConsumerInternal(result);
                                if (result != null) {
                                    profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata());
                                    if (profMetadata != null && profMetadata.has("nonTelco")) {
                                        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), profMetadata.optBoolean("nonTelco"));
                                    } else {
                                        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
                                    }
                                }
                                if (result != null && (profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata())) != null && profMetadata.has("badge")) {
                                    WarpUtils.setUserTag(Warply.getWarplyContext(), profMetadata.optString("badge"));
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) {
                            }
                        });
                    } else {
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_login_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_login_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void getUserCoupons(final WarplyUserCouponsRequest request, final CallbackReceiver<CouponList> receiver) {
        WarpUtils.log("************* WARPLY User Coupons Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Coupons Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData("coupon", true, "context", request.toJson(), new CouponsHook(new CallbackReceiver<CouponList>(){

            @Override
            public void onSuccess(CouponList result) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_user_coupons_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getUserCoupons(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_user_coupons_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        }, request.getSignature()));
    }

    public static void getTransactionHistory(final WarplyTransactionHistoryRequest request, final CallbackReceiver<TransactionsList> receiver) {
        WarpUtils.log("************* WARPLY Transaction History Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Transaction History Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new TransactionsHook(new CallbackReceiver<TransactionsList>(){

            @Override
            public void onSuccess(TransactionsList result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getTransactionHistory(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        }, request.getSignature()));
    }

    public static void getPointHistory(final WarplyPointHistoryRequest request, final CallbackReceiver<PointsList> receiver) {
        WarpUtils.log("************* WARPLY Point History Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Point History Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new PointsHook(new CallbackReceiver<PointsList>(){

            @Override
            public void onSuccess(PointsList result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getPointHistory(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        }, request.getSignature()));
    }

    public static void addAddress(final WarplyAddAddressRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Add Address Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Add Address Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    receiver.onSuccess(result);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.addAddress(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void getAddressList(final WarplyGetAddressRequest request, final CallbackReceiver<AddressList> receiver) {
        WarpUtils.log("************* WARPLY Get Address Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Address Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new AddressHook(new CallbackReceiver<AddressList>(){

            @Override
            public void onSuccess(AddressList result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getAddressList(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        }, request.getSignature()));
    }

    public static void editAddress(final WarplyEditAddressRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Edit Address Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Edit Address Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    receiver.onSuccess(result);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.editAddress(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void deleteAddress(final WarplyDeleteAddressRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Delete Address Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Delete Address Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    receiver.onSuccess(result);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.deleteAddress(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void redeemProduct(final WarplyRedeemProductRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Redeem Product Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Redeem Product Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData("transactions", true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.redeemProduct(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void forgotPassword(WarplyForgotPasswordRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Forgot Password Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Forgot Password Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(false, "password_reset", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    receiver.onSuccess(result);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void resetPassword(WarplyResetPasswordRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Reset Password Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Reset Password Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(false, "password_reset", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    receiver.onSuccess(result);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void requestOTP(WarplyRequestOTPRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Request OTP Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Request OTP Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(false, "generate", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    receiver.onSuccess(result);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void verifyOTP(WarplyVerifyOTPRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Verify OTP Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Verify OTP Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(false, "validate", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    receiver.onSuccess(result);
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void getMerchantsMultilingual(WarplyMerchantsRequest request, CallbackReceiver<MerchantList> receiver) {
        if (request == null) {
            request = new WarplyMerchantsRequest().setIsMultilingual(true);
        }
        WarpUtils.log("************* WARPLY Microapp ********************");
        WarpUtils.log("[WARP Trace] Shops Microapp is active");
        WarpUtils.log("**************************************************");
        request = request != null ? request : new WarplyMerchantsRequest().setIsMultilingual(true);
        Warply.postReceiveMicroappData("shops", request.toJson(), new MerchantsHook(receiver, request.getSignature()));
    }

    public static void getCouponsets(WarplyGetCouponsetsRequest request, final CallbackReceiver<CouponsetsList> receiver) {
        WarpUtils.log("************* WARPLY Get Couponsets Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Couponsets Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData("coupon", request.toJson(), new CouponsetsHook(new CallbackReceiver<CouponsetsList>(){

            @Override
            public void onSuccess(CouponsetsList result) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_couponsets_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                WarplyManagerHelper.setCouponsets(result);
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_couponsets_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(errorCode);
            }
        }, request.getSignature()));
    }

    public static void redeemCoupon(final WarplyRedeemCouponRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Redeem Coupon Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Redeem Coupon Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData("coupon", true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status");
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_retrieve_coupon_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_retrieve_coupon_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.redeemCoupon(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_retrieve_coupon_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void validateCoupon(final WarplyValidateCouponRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Validate Coupon Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Validate Coupon Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData("coupon", true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.validateCoupon(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    private static ArrayList<Campaign> mergeCampaignResults(ArrayList<Campaign> resultCampaigns, ArrayList<Campaign> resultPersonalizedCampaigns, JSONObject resultCampaignsAvailability) {
        ArrayList<Campaign> newCampaignList = new ArrayList<Campaign>();
        ArrayList<Campaign> campaignLoyaltyList = new ArrayList<Campaign>();
        newCampaignList.clear();
        if (resultCampaigns != null && resultCampaigns.size() > 0) {
            newCampaignList.addAll(resultCampaigns);
        }
        if (resultPersonalizedCampaigns != null && resultPersonalizedCampaigns.size() > 0) {
            newCampaignList.addAll(resultPersonalizedCampaigns);
        }
        if (newCampaignList != null && newCampaignList.size() > 0) {
            Collections.sort(newCampaignList, (obj1, obj2) -> Integer.compare(obj1.getSorting(), obj2.getSorting()));
            campaignLoyaltyList.clear();
            ArrayList<Campaign> campaignCarouselList = new ArrayList<Campaign>();
            campaignCarouselList.clear();
            for (Campaign camp : newCampaignList) {
                JSONObject campMetadata;
                String cpnUuid;
                JSONObject campaignSettings;
                if (resultCampaignsAvailability != null && resultCampaignsAvailability.length() > 0 && (campaignSettings = WarpJSONParser.getJSONFromString(camp.getCampaignTypeSettings())) != null && campaignSettings.has("couponset") && resultCampaignsAvailability.has(cpnUuid = campaignSettings.optString("couponset"))) {
                    camp.setCouponAvailability(resultCampaignsAvailability.optInt(cpnUuid));
                }
                if ((campMetadata = WarpJSONParser.getJSONFromString(camp.getExtraFields())) != null && campMetadata.has("carousel") && (camp.getCouponAvailability() == null || camp.getCouponAvailability() != 0)) {
                    campaignCarouselList.add(camp);
                }
                try {
                    JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                    if (extraFields == null || extraFields.length() != 0 && (extraFields.has("ccms_offer") || extraFields.has("type")) || camp.getCouponAvailability() != null && camp.getCouponAvailability() == 0) continue;
                    campaignLoyaltyList.add(camp);
                }
                catch (Exception exception) {
                    if (camp.getCouponAvailability() != null && camp.getCouponAvailability() == 0) continue;
                    campaignLoyaltyList.add(camp);
                }
            }
            WarplyManagerHelper.setCampaignList(newCampaignList);
            WarplyManagerHelper.setCarouselList(campaignCarouselList);
            LinkedHashSet<Campaign> set = new LinkedHashSet<Campaign>(campaignLoyaltyList);
            campaignLoyaltyList.clear();
            campaignLoyaltyList.addAll(set);
        }
        return campaignLoyaltyList;
    }

    public static void getUserCouponsWithCouponsets(final CallbackReceiver<CouponList> receiver) {
        WarpUtils.log("************* WARPLY User Coupons Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Coupons Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        final ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(3));
        ListenableFuture<MerchantList> futureMerchants = WarplyManager.getMerchantsRetro(service);
        ListenableFuture<CouponsetsList> futureCouponsets = WarplyManager.getCouponsetsRetro(service);
        SettableFuture futureUniversal = SettableFuture.create();
        ListenableFuture<CouponList> futureCoupons = WarplyManager.getCouponsUniversalRetro(service, 0, (SettableFuture<CouponList>)futureUniversal);
        ListenableFuture allResultsFuture = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{futureMerchants, futureCouponsets, futureCoupons});
        ListenableFuture mergedResultFuture = Futures.transformAsync((ListenableFuture)allResultsFuture, results -> {
            CouponList resultCoupons = (CouponList)results.get(2);
            return executorService.submit(() -> resultCoupons);
        }, (Executor)executorService);
        Futures.addCallback((ListenableFuture)mergedResultFuture, (FutureCallback)new FutureCallback<CouponList>(){

            public void onSuccess(CouponList mergedResult) {
                executorService.shutdownNow();
                new Handler(Looper.getMainLooper()).post(() -> receiver.onSuccess(mergedResult));
            }

            public void onFailure(Throwable throwable) {
                executorService.shutdownNow();
                new Handler(Looper.getMainLooper()).post(() -> receiver.onFailure(2));
            }
        }, (Executor)executorService);
    }

    public static void getCampaigns(final CallbackReceiver<ArrayList<Campaign>> receiver) {
        WarpUtils.log("************* WARPLY Get Campaigns Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Campaigns Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        final ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(3));
        ListenableFuture<ArrayList<Campaign>> futureCampaigns = WarplyManager.getCampaignsRetro(service);
        SettableFuture futurePersonalized = SettableFuture.create();
        ListenableFuture<ArrayList<Campaign>> futurePersonalizedCampaigns = WarplyManager.getCampaignsPersonalizedRetro(service, 0, (SettableFuture<ArrayList<Campaign>>)futurePersonalized);
        ListenableFuture<JSONObject> futureCampaignAvailability = WarplyManager.getCampaignAvailability(service);
        ListenableFuture allResultsFuture = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{futureCampaigns, futurePersonalizedCampaigns, futureCampaignAvailability});
        ListenableFuture mergedResultFuture = Futures.transformAsync((ListenableFuture)allResultsFuture, results -> {
            ArrayList resultCampaigns = (ArrayList)results.get(0);
            ArrayList resultPersonalizedCampaigns = (ArrayList)results.get(1);
            JSONObject resultCampaignsAvailability = (JSONObject)results.get(2);
            return executorService.submit(() -> WarplyManager.mergeCampaignResults(resultCampaigns, resultPersonalizedCampaigns, resultCampaignsAvailability));
        }, (Executor)executorService);
        Futures.addCallback((ListenableFuture)mergedResultFuture, (FutureCallback)new FutureCallback<ArrayList<Campaign>>(){

            public void onSuccess(ArrayList<Campaign> mergedResult) {
                executorService.shutdownNow();
                new Handler(Looper.getMainLooper()).post(() -> receiver.onSuccess(mergedResult));
            }

            public void onFailure(Throwable throwable) {
                executorService.shutdownNow();
                new Handler(Looper.getMainLooper()).post(() -> receiver.onFailure(2));
            }
        }, (Executor)executorService);
    }

    private static ListenableFuture<ArrayList<Campaign>> getCampaignsRetro(ApiService service) {
        final SettableFuture future = SettableFuture.create();
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsCampaigns = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "retrieve");
        jsonParams.put("filters", new JSONObject());
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));
        jsonParamsCampaigns.put("campaigns", jsonParams);
        RequestBody campaignsRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsCampaigns).toString());
        Call<ResponseBody> campaignsCall = service.getCampaigns(WarplyProperty.getAppUuid(Warply.getWarplyContext()), campaignsRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp));
        campaignsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 200 && response.body() != null) {
                    JSONObject jobjCampaignsResponse = null;
                    try {
                        jobjCampaignsResponse = new JSONObject(((ResponseBody)response.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjCampaignsResponse != null && jobjCampaignsResponse.has("status") && jobjCampaignsResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_campaigns_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        JSONArray jCampaignsBody = null;
                        try {
                            jCampaignsBody = jobjCampaignsResponse.optJSONObject("context").optJSONObject("MAPP_CAMPAIGNING").optJSONArray("campaigns");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (jCampaignsBody != null) {
                            ArrayList tempCampaigns = new ArrayList();
                            ArrayList mCampaignsList = new ArrayList();
                            ExecutorService executorCampaigns = Executors.newFixedThreadPool(1);
                            JSONArray finalCampaignsJBody = jCampaignsBody;
                            executorCampaigns.submit(() -> {
                                for (int i = 0; i < finalCampaignsJBody.length(); ++i) {
                                    tempCampaigns.add(new NewCampaign(finalCampaignsJBody.optJSONObject(i)));
                                }
                                for (NewCampaign newCamp : tempCampaigns) {
                                    Campaign camp = new Campaign();
                                    camp.setIndexUrl(newCamp.getIndexUrl());
                                    camp.setLogoUrl(newCamp.getLogoUrl());
                                    camp.setMessage(newCamp.getMessage());
                                    camp.setOfferCategory(newCamp.getCommunicationCategory());
                                    camp.setSessionUUID(newCamp.getCommunicationUUID());
                                    camp.setTitle(newCamp.getTitle());
                                    camp.setSubtitle(newCamp.getSubtitle());
                                    camp.setSorting(newCamp.getSorting());
                                    camp.setNew(newCamp.getIsNew());
                                    camp.setType(newCamp.getCampaignType());
                                    camp.setEndDate(newCamp.getEndDate());
                                    camp.setStartDate(newCamp.getStartDate());
                                    camp.setShowExpiration(newCamp.isShowExpiration());
                                    camp.setCouponImg(newCamp.getCouponImg());
                                    camp.setFilter(newCamp.getFilter());
                                    try {
                                        camp.setExtraFields(newCamp.getExtraFields().toString());
                                        if (!TextUtils.isEmpty((CharSequence)newCamp.getExtraFields().toString())) {
                                            JSONObject extraFieldsResp = WarpJSONParser.getJSONFromString(newCamp.getExtraFields().toString());
                                            if (extraFieldsResp != null) {
                                                if (extraFieldsResp.has("Banner_title")) {
                                                    camp.setBannerTitle(extraFieldsResp.optString("Banner_title", ""));
                                                }
                                                if (extraFieldsResp.has("Banner_img")) {
                                                    camp.setBannerImage(extraFieldsResp.optString("Banner_img", ""));
                                                }
                                                if (extraFieldsResp.has("category_id")) {
                                                    camp.setCategoryId(extraFieldsResp.optString("category_id", ""));
                                                }
                                            }
                                        } else {
                                            camp.setBannerImage("");
                                            camp.setBannerTitle("");
                                            camp.setCategoryId("");
                                        }
                                    }
                                    catch (NullPointerException e) {
                                        camp.setExtraFields("");
                                        camp.setBannerImage("");
                                        camp.setBannerTitle("");
                                        camp.setCategoryId("");
                                        e.printStackTrace();
                                    }
                                    try {
                                        camp.setCampaignTypeSettings(newCamp.getSettings().toString());
                                    }
                                    catch (NullPointerException e) {
                                        camp.setCampaignTypeSettings("");
                                        e.printStackTrace();
                                    }
                                    mCampaignsList.add(camp);
                                }
                                executorCampaigns.shutdownNow();
                                future.set((Object)mCampaignsList);
                            });
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_campaigns_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        future.set(new ArrayList());
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_campaigns_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    future.setException(new Throwable());
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_campaigns_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                future.setException(new Throwable());
            }
        });
        return future;
    }

    private static ListenableFuture<ArrayList<Campaign>> getCampaignsPersonalizedRetro(final ApiService service, final int tries, final SettableFuture<ArrayList<Campaign>> future) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsCampaigns = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "retrieve");
        jsonParams.put("filters", new JSONObject());
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));
        jsonParamsCampaigns.put("campaigns", jsonParams);
        RequestBody campaignsPersonalizedRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsCampaigns).toString());
        Call<ResponseBody> campaignsPersonalizedCall = service.getCampaignsPersonalized(WarplyProperty.getAppUuid(Warply.getWarplyContext()), campaignsPersonalizedRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp), "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
        campaignsPersonalizedCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 200 && response.body() != null) {
                    JSONObject jobjCampaignsResponse = null;
                    try {
                        jobjCampaignsResponse = new JSONObject(((ResponseBody)response.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjCampaignsResponse != null && jobjCampaignsResponse.has("status") && jobjCampaignsResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_campaigns_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        JSONArray jCampaignsBody = null;
                        try {
                            jCampaignsBody = jobjCampaignsResponse.optJSONObject("context").optJSONObject("MAPP_CAMPAIGNING").optJSONArray("campaigns");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (jCampaignsBody != null) {
                            ArrayList tempCampaigns = new ArrayList();
                            ArrayList mCampaignsList = new ArrayList();
                            ExecutorService executorPersonalizedCampaigns = Executors.newFixedThreadPool(1);
                            JSONArray finalCampaignsJBody = jCampaignsBody;
                            executorPersonalizedCampaigns.submit(() -> {
                                for (int i = 0; i < finalCampaignsJBody.length(); ++i) {
                                    tempCampaigns.add(new NewCampaign(finalCampaignsJBody.optJSONObject(i)));
                                }
                                for (NewCampaign newCamp : tempCampaigns) {
                                    Campaign camp = new Campaign();
                                    camp.setIndexUrl(newCamp.getIndexUrl());
                                    camp.setLogoUrl(newCamp.getLogoUrl());
                                    camp.setMessage(newCamp.getMessage());
                                    camp.setOfferCategory(newCamp.getCommunicationCategory());
                                    camp.setSessionUUID(newCamp.getCommunicationUUID());
                                    camp.setTitle(newCamp.getTitle());
                                    camp.setSubtitle(newCamp.getSubtitle());
                                    camp.setSorting(newCamp.getSorting());
                                    camp.setNew(newCamp.getIsNew());
                                    camp.setType(newCamp.getCampaignType());
                                    camp.setEndDate(newCamp.getEndDate());
                                    camp.setStartDate(newCamp.getStartDate());
                                    camp.setShowExpiration(newCamp.isShowExpiration());
                                    camp.setCouponImg(newCamp.getCouponImg());
                                    camp.setFilter(newCamp.getFilter());
                                    try {
                                        camp.setExtraFields(newCamp.getExtraFields().toString());
                                        if (!TextUtils.isEmpty((CharSequence)newCamp.getExtraFields().toString())) {
                                            JSONObject extraFieldsResp = WarpJSONParser.getJSONFromString(newCamp.getExtraFields().toString());
                                            if (extraFieldsResp != null) {
                                                if (extraFieldsResp.has("Banner_title")) {
                                                    camp.setBannerTitle(extraFieldsResp.optString("Banner_title", ""));
                                                }
                                                if (extraFieldsResp.has("Banner_img")) {
                                                    camp.setBannerImage(extraFieldsResp.optString("Banner_img", ""));
                                                }
                                                if (extraFieldsResp.has("category_id")) {
                                                    camp.setCategoryId(extraFieldsResp.optString("category_id", ""));
                                                }
                                            }
                                        } else {
                                            camp.setBannerImage("");
                                            camp.setBannerTitle("");
                                            camp.setCategoryId("");
                                        }
                                    }
                                    catch (NullPointerException e) {
                                        camp.setExtraFields("");
                                        camp.setBannerImage("");
                                        camp.setBannerTitle("");
                                        camp.setCategoryId("");
                                        e.printStackTrace();
                                    }
                                    try {
                                        camp.setCampaignTypeSettings(newCamp.getSettings().toString());
                                    }
                                    catch (NullPointerException e) {
                                        camp.setCampaignTypeSettings("");
                                        e.printStackTrace();
                                    }
                                    mCampaignsList.add(camp);
                                }
                                executorPersonalizedCampaigns.shutdownNow();
                                future.set((Object)mCampaignsList);
                            });
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_campaigns_personalized_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        future.set(new ArrayList());
                    }
                } else if (response.code() == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getCampaignsPersonalizedRetro(service, tries, (SettableFuture<ArrayList<Campaign>>)future);
                            } else if (tries < 3) {
                                WarplyManager.getCampaignsPersonalizedRetro(service, tries + 1, (SettableFuture<ArrayList<Campaign>>)future);
                            } else {
                                future.setException(new Throwable());
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            if (tries < 3) {
                                WarplyManager.getCampaignsPersonalizedRetro(service, tries + 1, (SettableFuture<ArrayList<Campaign>>)future);
                            } else {
                                future.setException(new Throwable());
                            }
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_campaigns_personalized_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    future.setException(new Throwable());
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_campaigns_personalized_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                future.setException(new Throwable());
            }
        });
        return future;
    }

    private static ListenableFuture<JSONObject> getCampaignAvailability(ApiService service) {
        final SettableFuture future = SettableFuture.create();
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsCampaignsAvailability = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "availability");
        ArrayMap jsonParamsFilters = new ArrayMap();
        jsonParamsFilters.put("uuids", null);
        jsonParamsFilters.put("availability_enabled", true);
        jsonParams.put("filters", jsonParamsFilters);
        jsonParamsCampaignsAvailability.put("coupon", jsonParams);
        RequestBody campaignsAvailabilityRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsCampaignsAvailability).toString());
        Call<ResponseBody> campaignsAvailabilityCall = service.getCampaignsAvailability(WarplyProperty.getAppUuid(Warply.getWarplyContext()), campaignsAvailabilityRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp));
        campaignsAvailabilityCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 200 && response.body() != null) {
                    JSONObject jobjCampaignsAvailabilityResponse = null;
                    try {
                        jobjCampaignsAvailabilityResponse = new JSONObject(((ResponseBody)response.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjCampaignsAvailabilityResponse != null && jobjCampaignsAvailabilityResponse.has("status") && jobjCampaignsAvailabilityResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_available_coupons");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        ExecutorService executorCampaignsAvailability = Executors.newFixedThreadPool(1);
                        JSONObject finalJobjCampaignsAvailabilityResponse = jobjCampaignsAvailabilityResponse;
                        executorCampaignsAvailability.submit(() -> {
                            JSONObject jCampaignsAvailabilityBody = null;
                            try {
                                jCampaignsAvailabilityBody = finalJobjCampaignsAvailabilityResponse.optJSONObject("context").optJSONObject("MAPP_COUPON").optJSONObject("availability");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (jCampaignsAvailabilityBody != null) {
                                executorCampaignsAvailability.shutdownNow();
                                future.set((Object)jCampaignsAvailabilityBody);
                            }
                        });
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_available_coupons");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        future.set((Object)new JSONObject());
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_available_coupons");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    future.setException(new Throwable());
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_available_coupons");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                future.setException(new Throwable());
            }
        });
        return future;
    }

    public static void getMapData(CallbackReceiver<ArrayList<UnifiedCampaignModel>> receiver) {
        WarpUtils.log("************* WARPLY Get Map Data Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Map Data Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        WarplyManager.getMapDataRetro(service, receiver);
    }

    private static void getMapDataRetro(ApiService service, final CallbackReceiver<ArrayList<UnifiedCampaignModel>> receiver) {
        String serviceEnv = WarplyProperty.getAppUuid(Warply.getWarplyContext()).equals("0086a2088301440792091b9f814c2267") ? "prod" : "dev";
        Call<ResponseBody> call = service.getMapData(serviceEnv, WarplyProperty.getLanguage(Warply.getWarplyContext()));
        call.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                if (response.code() == 200 && response.body() != null) {
                    JSONObject jobjMapDataResponse = null;
                    try {
                        jobjMapDataResponse = new JSONObject(((ResponseBody)response.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjMapDataResponse != null && jobjMapDataResponse.has("status") && jobjMapDataResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_map_data");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        JSONArray jMapDataBody = null;
                        try {
                            jMapDataBody = jobjMapDataResponse.optJSONObject("result").optJSONArray("offers");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (jMapDataBody != null) {
                            ArrayList mMapDataList = new ArrayList();
                            ExecutorService executorMapData = Executors.newFixedThreadPool(1);
                            JSONArray finalMapDataJBody = jMapDataBody;
                            executorMapData.submit(() -> {
                                for (int i = 0; i < finalMapDataJBody.length(); ++i) {
                                    mMapDataList.add(new UnifiedCampaignModel(finalMapDataJBody.optJSONObject(i)));
                                }
                                executorMapData.shutdownNow();
                                new Handler(Looper.getMainLooper()).post(() -> receiver.onSuccess(mMapDataList));
                            });
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_map_data");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_map_data");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(response.code());
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                receiver.onFailure(2);
            }
        });
    }

    public static void getCampaignsPersonalized(final WarplyGetCampaignsRequest request, final CallbackReceiver<ArrayList<Campaign>> receiver) {
        WarpUtils.log("************* WARPLY Get Campaigns Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Campaigns Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData("campaigns", true, "campaignsPersonalized", request.toJson(), new NewCampaignsHook(new CallbackReceiver<ArrayList<Campaign>>(){

            @Override
            public void onSuccess(ArrayList<Campaign> result) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_campaigns_personalized_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getCampaignsPersonalized(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_campaigns_personalized_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        }, request.getSignature()));
    }

    public static void consumerIntegration(final WarplyIntegrationRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Integration Consumer Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Integration Consumer Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_customer_state_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_customer_state_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.consumerIntegration(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_customer_state_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void cosmoteSharing(final CosmoteSharingRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Cosmote Sharing Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Cosmote Sharing Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1 || status == 4 || status == 5 || status == 7) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_sharing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_sharing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.cosmoteSharing(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_sharing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void cosmoteRetrieveSharing(final CosmoteRetrieveSharingRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Cosmote Retrieve Sharing Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Cosmote Retrieve Sharing Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_retrieve_sharing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_retrieve_sharing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.cosmoteRetrieveSharing(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_retrieve_sharing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void getPacingDetails(final PacingDetailsRequest request, final CallbackReceiver<PacingDetails> receiver) {
        WarpUtils.log("************* WARPLY Pacing Details Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Pacing Details Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new PacingDetailsHook(new CallbackReceiver<PacingDetails>(){

            @Override
            public void onSuccess(PacingDetails result) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_pacing_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getPacingDetails(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_pacing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        }, request.getSignature()));
    }

    public static void cosmoteCouponSharing(final CosmoteCouponSharingRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Cosmote Coupon Sharing Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Cosmote Coupon Sharing Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1 || status == 3 || status == 4) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_coupon_sharing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_coupon_sharing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.cosmoteCouponSharing(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_coupon_sharing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void getUnifiedCoupons(final CallbackReceiver<ArrayList<UnifiedCoupon>> receiver) {
        WarpUtils.log("************* WARPLY User Coupons Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Coupons Request is active");
        WarpUtils.log("**************************************************");
        final ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        WarplyManager.getCouponsetsRetro(service, true, new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> responseCouponsets) {
                if (responseCouponsets.code() == 200 && responseCouponsets.body() != null) {
                    JSONObject jobjCouponsetsResponse = null;
                    try {
                        jobjCouponsetsResponse = new JSONObject(((ResponseBody)responseCouponsets.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjCouponsetsResponse != null && jobjCouponsetsResponse.has("status") && jobjCouponsetsResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_couponsets_sm_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        JSONObject finalJobjCouponsetsResponse = jobjCouponsetsResponse;
                        JSONArray jCouponsetsBody = null;
                        try {
                            jCouponsetsBody = finalJobjCouponsetsResponse.optJSONArray("result");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (jCouponsetsBody != null) {
                            CouponsetsList mCouponsetList = new CouponsetsList();
                            for (int i = 0; i < jCouponsetsBody.length(); ++i) {
                                Couponset tempCouponset = new Couponset(jCouponsetsBody.optJSONObject(i));
                                mCouponsetList.add(tempCouponset);
                            }
                            WarplyManagerHelper.setCouponsetsDeals(mCouponsetList);
                            WarplyManager.getUnifiedCouponsRetro(service, (Callback<ResponseBody>)((Callback)new Callback<ResponseBody>(){

                                public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> responseCoupons) {
                                    if (responseCoupons.code() == 200 && responseCoupons.body() != null) {
                                        JSONObject jobjCouponsResponse = null;
                                        try {
                                            jobjCouponsResponse = new JSONObject(((ResponseBody)responseCoupons.body()).string());
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        if (jobjCouponsResponse != null && jobjCouponsResponse.has("status") && jobjCouponsResponse.optInt("status", 2) == 1) {
                                            ArrayList couponList = new ArrayList();
                                            ArrayList allCouponList = new ArrayList();
                                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                            dynatraceEvent.setEventName("custom_success_unified_coupons_loyalty");
                                            EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                                            JSONObject finalJobjCouponsResponse = jobjCouponsResponse;
                                            ExecutorService executor = Executors.newFixedThreadPool(1);
                                            executor.submit(() -> {
                                                JSONObject jCouponsBody = null;
                                                try {
                                                    jCouponsBody = finalJobjCouponsResponse.optJSONObject("result");
                                                    if (jCouponsBody != null && jCouponsBody.length() > 0) {
                                                        JSONArray jCouponsInnerBody = null;
                                                        jCouponsInnerBody = jCouponsBody.optJSONArray("coupons");
                                                        if (jCouponsInnerBody != null && jCouponsInnerBody.length() > 0) {
                                                            for (int i = 0; i < jCouponsInnerBody.length(); ++i) {
                                                                UnifiedCoupon tempUni = new UnifiedCoupon(jCouponsInnerBody.optJSONObject(i));
                                                                allCouponList.add(tempUni);
                                                                if (!tempUni.getStatus().trim().equals("active")) continue;
                                                                couponList.add(tempUni);
                                                            }
                                                            WarplyManagerHelper.setMarketCoupons(allCouponList);
                                                            WarplyManagerHelper.setMarketCouponsList(couponList);
                                                        }
                                                    }
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                                new Handler(Looper.getMainLooper()).post(() -> receiver.onSuccess(couponList));
                                                executor.shutdownNow();
                                            });
                                        } else {
                                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                            dynatraceEvent.setEventName("custom_error_unified_coupons_loyalty");
                                            EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                                            receiver.onFailure(2);
                                        }
                                    } else {
                                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                        dynatraceEvent.setEventName("custom_error_unified_coupons_loyalty");
                                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                                        receiver.onFailure(responseCoupons.code());
                                    }
                                }

                                public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                    dynatraceEvent.setEventName("custom_error_user_coupons_loyalty");
                                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                                    receiver.onFailure(2);
                                }
                            }));
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_couponsets_sm_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_couponsets_sm_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(responseCouponsets.code());
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_couponsets_sm_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(2);
            }
        });
    }

    public static void cancelUnifiedCoupon(String transactionID, final CallbackReceiver<Integer> receiver) {
        WarpUtils.log("************* WARPLY Cancel Unified Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Cancel Unified Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        WarplyManager.cancelUnifiedCoupon(service, transactionID, new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                if (response.code() == 200 && response.body() != null) {
                    JSONObject jobjResponse = null;
                    try {
                        jobjResponse = new JSONObject(((ResponseBody)response.body()).string());
                    }
                    catch (Exception e) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_cancel_unified_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        e.printStackTrace();
                    }
                    if (jobjResponse != null && jobjResponse.has("status") && jobjResponse.optInt("status", 2) == 1) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_cancel_unified_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        Integer status = new Integer(jobjResponse.optInt("status", 2));
                        receiver.onSuccess(status);
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_cancel_unified_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_cancel_unified_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(response.code());
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_cancel_unified_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(2);
            }
        });
    }

    public static void getUnifiedCouponsDeals(final CallbackReceiver<ArrayList<UnifiedCoupon>> receiver) {
        WarpUtils.log("************* WARPLY User Coupons Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Coupons Request is active");
        WarpUtils.log("**************************************************");
        final ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        WarplyManager.getCouponsetsRetro(service, true, new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> responseCouponsets) {
                if (responseCouponsets.code() == 200 && responseCouponsets.body() != null) {
                    JSONObject jobjCouponsetsResponse = null;
                    try {
                        jobjCouponsetsResponse = new JSONObject(((ResponseBody)responseCouponsets.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjCouponsetsResponse != null && jobjCouponsetsResponse.has("status") && jobjCouponsetsResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_couponsets_sm_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        JSONObject finalJobjCouponsetsResponse = jobjCouponsetsResponse;
                        JSONArray jCouponsetsBody = null;
                        try {
                            jCouponsetsBody = finalJobjCouponsetsResponse.optJSONArray("result");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (jCouponsetsBody != null) {
                            CouponsetsList mCouponsetList = new CouponsetsList();
                            for (int i = 0; i < jCouponsetsBody.length(); ++i) {
                                Couponset tempCouponset = new Couponset(jCouponsetsBody.optJSONObject(i));
                                mCouponsetList.add(tempCouponset);
                            }
                            WarplyManagerHelper.setCouponsetsDeals(mCouponsetList);
                            WarplyManager.getUnifiedCouponsRetro(service, (Callback<ResponseBody>)((Callback)new Callback<ResponseBody>(){

                                public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> responseCoupons) {
                                    if (responseCoupons.code() == 200 && responseCoupons.body() != null) {
                                        JSONObject jobjCouponsResponse = null;
                                        try {
                                            jobjCouponsResponse = new JSONObject(((ResponseBody)responseCoupons.body()).string());
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        if (jobjCouponsResponse != null && jobjCouponsResponse.has("status") && jobjCouponsResponse.optInt("status", 2) == 1) {
                                            ArrayList couponList = new ArrayList();
                                            ArrayList allCouponList = new ArrayList();
                                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                            dynatraceEvent.setEventName("custom_success_unified_coupons_loyalty");
                                            EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                                            JSONObject finalJobjCouponsResponse = jobjCouponsResponse;
                                            ExecutorService executor = Executors.newFixedThreadPool(1);
                                            executor.submit(() -> {
                                                JSONObject jCouponsBody = null;
                                                try {
                                                    jCouponsBody = finalJobjCouponsResponse.optJSONObject("result");
                                                    if (jCouponsBody != null && jCouponsBody.length() > 0) {
                                                        JSONArray jCouponsInnerBody = null;
                                                        jCouponsInnerBody = jCouponsBody.optJSONArray("coupons");
                                                        if (jCouponsInnerBody != null && jCouponsInnerBody.length() > 0) {
                                                            for (int i = 0; i < jCouponsInnerBody.length(); ++i) {
                                                                UnifiedCoupon tempUni = new UnifiedCoupon(jCouponsInnerBody.optJSONObject(i));
                                                                allCouponList.add(tempUni);
                                                                if (!tempUni.getStatus().trim().equals("active")) continue;
                                                                couponList.add(tempUni);
                                                            }
                                                        }
                                                        WarplyManagerHelper.setMarketCoupons(allCouponList);
                                                        WarplyManagerHelper.setMarketCouponsList(couponList);
                                                    }
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                                OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventUnifiedCouponsService.class).build();
                                                WorkManager.getInstance((Context)Warply.getWarplyContext()).enqueue((WorkRequest)mywork);
                                                new Handler(Looper.getMainLooper()).post(() -> receiver.onSuccess(couponList));
                                                executor.shutdownNow();
                                            });
                                        } else {
                                            LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                            dynatraceEvent.setEventName("custom_error_unified_coupons_loyalty");
                                            EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                                            receiver.onFailure(2);
                                        }
                                    } else {
                                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                        dynatraceEvent.setEventName("custom_error_unified_coupons_loyalty");
                                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                                        receiver.onFailure(responseCoupons.code());
                                    }
                                }

                                public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                                    dynatraceEvent.setEventName("custom_error_user_coupons_loyalty");
                                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                                    receiver.onFailure(2);
                                }
                            }));
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_couponsets_sm_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_couponsets_sm_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(responseCouponsets.code());
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_couponsets_sm_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(2);
            }
        });
    }

    public static void sendAccelerationDataToServer(JSONArray telematicsData, final CallbackReceiver<Integer> receiver) {
        WarpUtils.log("************* WARPLY User Telematics Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Telematics Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        WarplyManager.sendTelematicsData(service, telematicsData, new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> responseTelematics) {
                if (responseTelematics.code() == 200 && responseTelematics.body() != null) {
                    JSONObject jobjTelematicsResponse = null;
                    try {
                        jobjTelematicsResponse = new JSONObject(((ResponseBody)responseTelematics.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjTelematicsResponse != null && jobjTelematicsResponse.has("status") && jobjTelematicsResponse.optInt("status", 2) == 1) {
                        Integer status = new Integer(jobjTelematicsResponse.optInt("status", 2));
                        receiver.onSuccess(status);
                    } else {
                        receiver.onFailure(2);
                    }
                } else {
                    receiver.onFailure(responseTelematics.code());
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                receiver.onFailure(2);
            }
        });
    }

    public static void getTelematicsHistory(final CallbackReceiver<ArrayList<TelematicsHistory>> receiver) {
        WarpUtils.log("************* WARPLY User Telematics History Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Telematics History Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        WarplyManager.getTelematicsHistory(service, new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> responseTelematics) {
                if (responseTelematics.code() == 200 && responseTelematics.body() != null) {
                    JSONObject jobjTelematicsResponse = null;
                    try {
                        jobjTelematicsResponse = new JSONObject(((ResponseBody)responseTelematics.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjTelematicsResponse != null && jobjTelematicsResponse.has("status") && jobjTelematicsResponse.optInt("status", 2) == 1) {
                        JSONObject finalJobjTelematicsResponse = jobjTelematicsResponse;
                        ArrayList telematicsHistoryList = new ArrayList();
                        ExecutorService executor = Executors.newFixedThreadPool(1);
                        executor.submit(() -> {
                            JSONArray jTelematicsHistoryBody = null;
                            try {
                                jTelematicsHistoryBody = finalJobjTelematicsResponse.optJSONArray("result");
                                if (jTelematicsHistoryBody != null && jTelematicsHistoryBody.length() > 0) {
                                    for (int i = 0; i < jTelematicsHistoryBody.length(); ++i) {
                                        TelematicsHistory tempHis = new TelematicsHistory(jTelematicsHistoryBody.optJSONObject(i));
                                        telematicsHistoryList.add(tempHis);
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            new Handler(Looper.getMainLooper()).post(() -> receiver.onSuccess(telematicsHistoryList));
                            executor.shutdownNow();
                        });
                    } else {
                        receiver.onFailure(2);
                    }
                } else {
                    receiver.onFailure(responseTelematics.code());
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                receiver.onFailure(2);
            }
        });
    }

    public static void getTripMetrics(int tripId, final CallbackReceiver<TripMetrics> receiver) {
        WarpUtils.log("************* WARPLY User Trip Metrics Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Trip Metrics Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        WarplyManager.getTripMetrics(service, tripId, new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> responseTelematics) {
                if (responseTelematics.code() == 200 && responseTelematics.body() != null) {
                    JSONObject jobjTelematicsResponse = null;
                    try {
                        jobjTelematicsResponse = new JSONObject(((ResponseBody)responseTelematics.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjTelematicsResponse != null && jobjTelematicsResponse.has("status") && jobjTelematicsResponse.optInt("status", 2) == 1) {
                        JSONObject finalJobjCouponsResponse = jobjTelematicsResponse;
                        TripMetrics[] tripData = new TripMetrics[]{new TripMetrics()};
                        ExecutorService executor = Executors.newFixedThreadPool(1);
                        executor.submit(() -> {
                            JSONObject jMetricsBody = null;
                            try {
                                String parent;
                                JSONObject jobj;
                                jMetricsBody = finalJobjCouponsResponse.optJSONObject("result");
                                if (jMetricsBody != null && jMetricsBody.keys().hasNext() && (jobj = jMetricsBody.optJSONObject(parent = (String)jMetricsBody.keys().next())) != null) {
                                    tripData[0] = new TripMetrics(jobj);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            new Handler(Looper.getMainLooper()).post(() -> receiver.onSuccess(tripData[0]));
                            executor.shutdownNow();
                        });
                    } else {
                        receiver.onFailure(2);
                    }
                } else {
                    receiver.onFailure(responseTelematics.code());
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                receiver.onFailure(2);
            }
        });
    }

    public static void rateTrip(int tripId, boolean isPositive, final CallbackReceiver<Integer> receiver) {
        WarpUtils.log("************* WARPLY User Rate Trip Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Rate Trip Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        WarplyManager.rateTrip(service, tripId, isPositive, new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> responseTelematics) {
                if (responseTelematics.code() == 200 && responseTelematics.body() != null) {
                    JSONObject jobjTelematicsResponse = null;
                    try {
                        jobjTelematicsResponse = new JSONObject(((ResponseBody)responseTelematics.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjTelematicsResponse != null && jobjTelematicsResponse.has("status") && jobjTelematicsResponse.optInt("status", 2) == 1) {
                        Integer status = new Integer(jobjTelematicsResponse.optInt("status", 2));
                        receiver.onSuccess(status);
                    } else {
                        receiver.onFailure(2);
                    }
                } else {
                    receiver.onFailure(responseTelematics.code());
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                receiver.onFailure(2);
            }
        });
    }

    public static void getUserCouponsWithCouponsets(final WarplyUserCouponsRequest request, final CallbackReceiver<CouponList> receiver) {
        WarpUtils.log("************* WARPLY User Coupons Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY User Coupons Request is active");
        WarpUtils.log("**************************************************");
        WarplyManager.getMerchantsMultilingual(new WarplyMerchantsRequest().setIsMultilingual(true), new CallbackReceiver<MerchantList>(){

            @Override
            public void onSuccess(MerchantList result) {
                WarplyManagerHelper.setMerchantList(result);
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_shops_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                WarplyManager.getCouponsets(new WarplyGetCouponsetsRequest().setLanguage(WarplyProperty.getLanguage(Warply.getWarplyContext())), new CallbackReceiver<CouponsetsList>(){

                    @Override
                    public void onSuccess(final CouponsetsList result) {
                        Warply.postReceiveMicroappData("coupon", true, "context", request.toJson(), new CouponsHook(new CallbackReceiver<CouponList>(){

                            @Override
                            public void onSuccess(CouponList response) {
                                CouponList mCouponList = new CouponList();
                                for (Coupon coupon : response) {
                                    for (Couponset couponset : result) {
                                        if (!coupon.getCouponsetUuid().equals(couponset.getUuid())) continue;
                                        coupon.setDescription(couponset.getShortDescription());
                                        coupon.setImage(couponset.getImgPreview());
                                        coupon.setName(couponset.getName());
                                        coupon.setMerchantUuid(couponset.getMerchantUuid());
                                        coupon.setInnerText(couponset.getInnerText());
                                        coupon.setDiscount_type(couponset.getDiscount_type());
                                        coupon.setFinal_price(couponset.getFinal_price());
                                        mCouponList.add(coupon);
                                    }
                                }
                                WarplyManagerHelper.setCouponList(mCouponList);
                                CouponList mActiveCouponList = new CouponList();
                                for (Coupon coupon : mCouponList) {
                                    if (coupon.getStatus() != 1) continue;
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                                    Date newDate = new Date();
                                    try {
                                        newDate = simpleDateFormat.parse(coupon.getExpiration());
                                    }
                                    catch (ParseException e) {
                                        e.printStackTrace();
                                    }
                                    coupon.setExpirationDate(newDate);
                                    mActiveCouponList.add(coupon);
                                }
                                Collections.sort(mActiveCouponList, (coupon1, coupon2) -> coupon1.getExpirationDate().compareTo(coupon2.getExpirationDate()));
                                receiver.onSuccess(mActiveCouponList);
                            }

                            @Override
                            public void onFailure(int errorCode) {
                                if (errorCode == 401) {
                                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                                        @Override
                                        public void onSuccess(JSONObject result) {
                                            int status = result.optInt("status", 2);
                                            if (status == 1) {
                                                WarplyManager.getUserCoupons(request, receiver);
                                            } else {
                                                receiver.onFailure(status);
                                            }
                                        }

                                        @Override
                                        public void onFailure(int errorCode) {
                                            receiver.onFailure(errorCode);
                                        }
                                    });
                                } else {
                                    receiver.onFailure(errorCode);
                                }
                            }
                        }, request.getSignature()));
                    }

                    @Override
                    public void onFailure(int errorCode) {
                        receiver.onFailure(errorCode);
                    }
                });
            }

            @Override
            public void onFailure(int errorCode) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_shops_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void getMerchantsMultilingual(ArrayList<String> catuuids, final CallbackReceiver<MerchantList> receiver) {
        WarpUtils.log("************* WARPLY Merchants Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Merchants Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        WarplyManager.getMerchantsRetro(service, catuuids, new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> responseMerchants) {
                if (responseMerchants.code() == 200 && responseMerchants.body() != null) {
                    JSONObject jobjMerchantsResponse = null;
                    try {
                        jobjMerchantsResponse = new JSONObject(((ResponseBody)responseMerchants.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjMerchantsResponse != null && jobjMerchantsResponse.has("status") && jobjMerchantsResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_shops_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        JSONArray jMerchantsBody = null;
                        try {
                            jMerchantsBody = jobjMerchantsResponse.optJSONObject("context").optJSONObject("MAPP_SHOPS").optJSONArray("result");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (jMerchantsBody != null) {
                            MerchantList mMerchantList = new MerchantList();
                            ExecutorService executorShops = Executors.newFixedThreadPool(1);
                            JSONArray finalMerchantsJBody = jMerchantsBody;
                            executorShops.submit(() -> {
                                for (int i = 0; i < finalMerchantsJBody.length(); ++i) {
                                    mMerchantList.add(new Merchant(finalMerchantsJBody.optJSONObject(i)));
                                }
                                new Handler(Looper.getMainLooper()).post(() -> receiver.onSuccess(mMerchantList));
                                executorShops.shutdownNow();
                            });
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_shops_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_shops_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(responseMerchants.code());
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_shops_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(2);
            }
        });
    }

    public static void getMerchantsMultilingual(boolean isParent, ArrayList<String> parentuuids, final CallbackReceiver<MerchantList> receiver) {
        WarpUtils.log("************* WARPLY Merchants Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Merchants Request is active");
        WarpUtils.log("**************************************************");
        ApiService service = (ApiService)ApiClient.getRetrofitInstance().create(ApiService.class);
        WarplyManager.getMerchantsRetro(service, true, parentuuids, new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> responseMerchants) {
                if (responseMerchants.code() == 200 && responseMerchants.body() != null) {
                    JSONObject jobjMerchantsResponse = null;
                    try {
                        jobjMerchantsResponse = new JSONObject(((ResponseBody)responseMerchants.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjMerchantsResponse != null && jobjMerchantsResponse.has("status") && jobjMerchantsResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_shops_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        JSONArray jMerchantsBody = null;
                        try {
                            jMerchantsBody = jobjMerchantsResponse.optJSONObject("context").optJSONObject("MAPP_SHOPS").optJSONArray("result");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (jMerchantsBody != null) {
                            MerchantList mMerchantList = new MerchantList();
                            ExecutorService executorShops = Executors.newFixedThreadPool(1);
                            JSONArray finalMerchantsJBody = jMerchantsBody;
                            executorShops.submit(() -> {
                                for (int i = 0; i < finalMerchantsJBody.length(); ++i) {
                                    mMerchantList.add(new Merchant(finalMerchantsJBody.optJSONObject(i)));
                                }
                                new Handler(Looper.getMainLooper()).post(() -> receiver.onSuccess(mMerchantList));
                                executorShops.shutdownNow();
                            });
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_shops_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        receiver.onFailure(2);
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_shops_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(responseMerchants.code());
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_shops_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onFailure(2);
            }
        });
    }

    private static ListenableFuture<CouponsetsList> getCouponsetsRetro(ApiService service) {
        final SettableFuture future = SettableFuture.create();
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsCouponsets = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "retrieve_multilingual");
        jsonParams.put("active", true);
        jsonParams.put("visible", true);
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));
        JSONObject excludesKey = new JSONObject();
        try {
            excludesKey.putOpt("field", (Object)"couponset_type");
            excludesKey.putOpt("value", (Object)new JSONArray().put((Object)"supermarket"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        jsonParams.put("exclude", new JSONArray().put((Object)excludesKey));
        jsonParamsCouponsets.put("coupon", jsonParams);
        RequestBody couponsetsRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsCouponsets).toString());
        Call<ResponseBody> couponsetsCall = service.getCouponsets(WarplyProperty.getAppUuid(Warply.getWarplyContext()), couponsetsRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp));
        couponsetsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 200 && response.body() != null) {
                    JSONObject jobjCouponsetsResponse = null;
                    try {
                        jobjCouponsetsResponse = new JSONObject(((ResponseBody)response.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjCouponsetsResponse != null && jobjCouponsetsResponse.has("status") && jobjCouponsetsResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_couponsets_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        JSONArray jCouponsetsBody = null;
                        try {
                            jCouponsetsBody = jobjCouponsetsResponse.optJSONObject("context").optJSONArray("MAPP_COUPON");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (jCouponsetsBody != null) {
                            CouponsetsList mCouponsetList = new CouponsetsList();
                            ExecutorService executorCouponsets = Executors.newFixedThreadPool(1);
                            JSONArray finalJCouponsetsBody = jCouponsetsBody;
                            executorCouponsets.submit(() -> {
                                for (int i = 0; i < finalJCouponsetsBody.length(); ++i) {
                                    Couponset tempCouponset = new Couponset(finalJCouponsetsBody.optJSONObject(i));
                                    mCouponsetList.add(tempCouponset);
                                }
                                WarplyManagerHelper.setCouponsets(mCouponsetList);
                                executorCouponsets.shutdownNow();
                                future.set((Object)mCouponsetList);
                            });
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_couponsets_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        future.set((Object)new CouponsetsList());
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_couponsets_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    future.setException(new Throwable());
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_couponsets_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                future.setException(new Throwable());
            }
        });
        return future;
    }

    private static void getCouponsetsRetro(final ApiService service, final boolean isFiltered, final Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsCouponsets = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "retrieve_multilingual");
        jsonParams.put("active", true);
        jsonParams.put("visible", true);
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));
        jsonParams.put("couponset_types", new JSONArray().put((Object)"supermarket"));
        jsonParamsCouponsets.put("coupon", jsonParams);
        RequestBody couponsetsRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsCouponsets).toString());
        Call<ResponseBody> couponsetsCall = service.getCouponsets(WarplyProperty.getAppUuid(Warply.getWarplyContext()), couponsetsRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp), "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
        couponsetsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(final @NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getCouponsetsRetro(service, isFiltered, (Callback<ResponseBody>)callback);
                            } else {
                                callback.onFailure(call, new Throwable());
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            callback.onFailure(call, new Throwable());
                        }
                    });
                } else {
                    callback.onResponse(call, response);
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static void sendTelematicsData(final ApiService service, final JSONArray accelerationTimestamps, final Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        if (accelerationTimestamps == null || accelerationTimestamps != null && accelerationTimestamps.length() == 0) {
            return;
        }
        String startTime = "";
        String stopTime = "";
        int samples = 0;
        if (accelerationTimestamps.optJSONObject(0).keys().hasNext()) {
            String parent = (String)accelerationTimestamps.optJSONObject(0).keys().next();
            JSONObject jobj = accelerationTimestamps.optJSONObject(0).optJSONObject(parent);
            if (jobj != null) {
                startTime = jobj.optString("start_time");
                stopTime = jobj.optString("stop_time");
                samples = jobj.optInt("samples");
            }
        }
        ArrayMap jsonParamsTelematics = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "submit_telematics");
        JSONObject rawDataObj = new JSONObject();
        try {
            rawDataObj.putOpt("total_km", (Object)Float.valueOf(0.0f));
            rawDataObj.putOpt("average_speed", (Object)Float.valueOf(0.0f));
            rawDataObj.putOpt("smoothness", (Object)Float.valueOf(0.0f));
            rawDataObj.putOpt("focus", (Object)Float.valueOf(0.0f));
            rawDataObj.putOpt("trip_start", (Object)DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (long)Long.valueOf(startTime)).toString());
            rawDataObj.putOpt("trip_stop", (Object)DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (long)Long.valueOf(stopTime)).toString());
            rawDataObj.putOpt("samples", (Object)samples);
            rawDataObj.putOpt("sample_rate", (Object)(samples / 1000));
            rawDataObj.putOpt("metadata", (Object)accelerationTimestamps);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        jsonParams.put("raw_data", rawDataObj);
        jsonParamsTelematics.put("telematics", jsonParams);
        RequestBody telematicsDataRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsTelematics).toString());
        Call<ResponseBody> telematicsCall = service.sendTelematicsData(WarplyProperty.getAppUuid(Warply.getWarplyContext()), telematicsDataRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp), "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
        telematicsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(final @NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.sendTelematicsData(service, accelerationTimestamps, (Callback<ResponseBody>)callback);
                            } else {
                                callback.onFailure(call, new Throwable());
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            callback.onFailure(call, new Throwable());
                        }
                    });
                } else {
                    callback.onResponse(call, response);
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static void cancelUnifiedCoupon(final ApiService service, final String transactionID, final Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsUnified = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "cancel_unified_coupon");
        jsonParams.put("transaction_id", transactionID);
        jsonParamsUnified.put("coupon", jsonParams);
        RequestBody cancelUnifiedDataRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsUnified).toString());
        Call<ResponseBody> telematicsCall = service.cancelUnifiedCoupon(WarplyProperty.getAppUuid(Warply.getWarplyContext()), cancelUnifiedDataRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp), "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
        telematicsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(final @NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.cancelUnifiedCoupon(service, transactionID, (Callback<ResponseBody>)callback);
                            } else {
                                callback.onFailure(call, new Throwable());
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            callback.onFailure(call, new Throwable());
                        }
                    });
                } else {
                    callback.onResponse(call, response);
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static void getTelematicsHistory(final ApiService service, final Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsTelematics = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "get_all_trip_ids");
        jsonParamsTelematics.put("telematics", jsonParams);
        RequestBody telematicsHistoryRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsTelematics).toString());
        Call<ResponseBody> telematicsCall = service.getTelematicsHistoy(WarplyProperty.getAppUuid(Warply.getWarplyContext()), telematicsHistoryRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp), "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
        telematicsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(final @NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getTelematicsHistory(service, (Callback<ResponseBody>)callback);
                            } else {
                                callback.onFailure(call, new Throwable());
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            callback.onFailure(call, new Throwable());
                        }
                    });
                } else {
                    callback.onResponse(call, response);
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static void getTripMetrics(final ApiService service, final int tripId, final Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsTelematics = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "get_scoring");
        jsonParams.put("trip_id", tripId);
        jsonParamsTelematics.put("telematics", jsonParams);
        RequestBody telematicsHistoryRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsTelematics).toString());
        Call<ResponseBody> telematicsCall = service.getTripMetrics(WarplyProperty.getAppUuid(Warply.getWarplyContext()), telematicsHistoryRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp), "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
        telematicsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(final @NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getTripMetrics(service, tripId, (Callback<ResponseBody>)callback);
                            } else {
                                callback.onFailure(call, new Throwable());
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            callback.onFailure(call, new Throwable());
                        }
                    });
                } else {
                    callback.onResponse(call, response);
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static void rateTrip(final ApiService service, final int tripId, final boolean isPositive, final Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsTelematics = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "update_rating");
        jsonParams.put("trip_id", tripId);
        jsonParams.put("rating", isPositive ? 1 : 0);
        jsonParamsTelematics.put("telematics", jsonParams);
        RequestBody telematicsHistoryRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsTelematics).toString());
        Call<ResponseBody> telematicsCall = service.rateTrip(WarplyProperty.getAppUuid(Warply.getWarplyContext()), telematicsHistoryRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp), "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
        telematicsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(final @NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.rateTrip(service, tripId, isPositive, (Callback<ResponseBody>)callback);
                            } else {
                                callback.onFailure(call, new Throwable());
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            callback.onFailure(call, new Throwable());
                        }
                    });
                } else {
                    callback.onResponse(call, response);
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static void getUnifiedCouponsRetro(final ApiService service, final Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsCouponsets = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "retrieve_unified_coupons");
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));
        jsonParamsCouponsets.put("coupon", jsonParams);
        RequestBody unifiedCouponsRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsCouponsets).toString());
        Call<ResponseBody> unifiedCouponsCall = service.getUnifiedCoupons(WarplyProperty.getAppUuid(Warply.getWarplyContext()), unifiedCouponsRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp), "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
        unifiedCouponsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(final @NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getUnifiedCouponsRetro(service, (Callback<ResponseBody>)callback);
                            } else {
                                callback.onFailure(call, new Throwable());
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            callback.onFailure(call, new Throwable());
                        }
                    });
                } else {
                    callback.onResponse(call, response);
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static ListenableFuture<MerchantList> getMerchantsRetro(ApiService service) {
        final SettableFuture future = SettableFuture.create();
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsShops = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "retrieve_multilingual");
        jsonParams.put("categories", new JSONArray());
        jsonParams.put("active", true);
        jsonParams.put("location", null);
        jsonParams.put("parent_uuids", null);
        jsonParams.put("tags", null);
        jsonParams.put("default_shown", null);
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));
        jsonParamsShops.put("shops", jsonParams);
        RequestBody merchantsRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsShops).toString());
        Call<ResponseBody> merchantsCall = service.getMerchants(WarplyProperty.getAppUuid(Warply.getWarplyContext()), merchantsRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp));
        merchantsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 200 && response.body() != null) {
                    JSONObject jobjMerchantsResponse = null;
                    try {
                        jobjMerchantsResponse = new JSONObject(((ResponseBody)response.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjMerchantsResponse != null && jobjMerchantsResponse.has("status") && jobjMerchantsResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_shops_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        JSONArray jMerchantsBody = null;
                        try {
                            jMerchantsBody = jobjMerchantsResponse.optJSONObject("context").optJSONObject("MAPP_SHOPS").optJSONArray("result");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (jMerchantsBody != null) {
                            MerchantList mMerchantList = new MerchantList();
                            ExecutorService executorShops = Executors.newFixedThreadPool(1);
                            JSONArray finalMerchantsJBody = jMerchantsBody;
                            executorShops.submit(() -> {
                                for (int i = 0; i < finalMerchantsJBody.length(); ++i) {
                                    mMerchantList.add(new Merchant(finalMerchantsJBody.optJSONObject(i)));
                                }
                                WarplyManagerHelper.setMerchantList(mMerchantList);
                                executorShops.shutdownNow();
                                future.set((Object)mMerchantList);
                            });
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_shops_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        future.set((Object)new MerchantList());
                    }
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_shops_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    future.setException(new Throwable());
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_shops_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                future.setException(new Throwable());
            }
        });
        return future;
    }

    private static void getMerchantsRetro(ApiService service, ArrayList<String> catuuids, final Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsShops = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "retrieve_multilingual");
        jsonParams.put("categories", new JSONArray(catuuids));
        jsonParams.put("active", true);
        jsonParams.put("location", null);
        jsonParams.put("parent_uuids", null);
        jsonParams.put("tags", null);
        jsonParams.put("default_shown", null);
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));
        jsonParamsShops.put("shops", jsonParams);
        RequestBody merchantsRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsShops).toString());
        Call<ResponseBody> merchantsCall = service.getMerchants(WarplyProperty.getAppUuid(Warply.getWarplyContext()), merchantsRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp));
        merchantsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                callback.onResponse(call, response);
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static void getMerchantsRetro(ApiService service, boolean isParent, ArrayList<String> parentuuids, final Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsShops = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "retrieve_multilingual");
        jsonParams.put("categories", new JSONArray());
        jsonParams.put("active", true);
        jsonParams.put("location", null);
        jsonParams.put("parent_uuids", new JSONArray(parentuuids));
        jsonParams.put("tags", null);
        jsonParams.put("default_shown", null);
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));
        jsonParamsShops.put("shops", jsonParams);
        RequestBody merchantsRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsShops).toString());
        Call<ResponseBody> merchantsCall = service.getMerchants(WarplyProperty.getAppUuid(Warply.getWarplyContext()), merchantsRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp));
        merchantsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                callback.onResponse(call, response);
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static void getUserCouponsRetro(final ApiService service, final Callback<ResponseBody> callback) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsCoupons = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "get_user_coupons");
        JSONArray jArr = new JSONArray();
        jArr.put((Object)"transaction");
        jArr.put((Object)"communication");
        jsonParams.put("fetch_data", jArr);
        jsonParamsCoupons.put("coupon", jsonParams);
        RequestBody couponsRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsCoupons).toString());
        Call<ResponseBody> couponsCall = service.getUserCoupons(WarplyProperty.getAppUuid(Warply.getWarplyContext()), couponsRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp), "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
        couponsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(final @NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getUserCouponsRetro(service, (Callback<ResponseBody>)callback);
                            } else {
                                callback.onFailure(call, new Throwable());
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            callback.onFailure(call, new Throwable());
                        }
                    });
                } else {
                    callback.onResponse(call, response);
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                callback.onFailure(call, t);
            }
        });
    }

    private static ListenableFuture<CouponList> getCouponsUniversalRetro(final ApiService service, final int tries, final SettableFuture<CouponList> future) {
        String timeStamp = DateFormat.format((CharSequence)"yyyy-MM-dd hh:mm:ss", (long)System.currentTimeMillis()).toString();
        String apiKey = WarpUtils.getApiKey(Warply.getWarplyContext());
        String webId = WarpUtils.getWebId(Warply.getWarplyContext());
        ArrayMap jsonParamsCoupons = new ArrayMap();
        ArrayMap jsonParams = new ArrayMap();
        jsonParams.put("action", "user_coupons");
        JSONArray jArr = new JSONArray();
        jArr.put((Object)"merchant");
        jsonParams.put("details", jArr);
        jsonParams.put("language", WarplyProperty.getLanguage(Warply.getWarplyContext()));
        jsonParamsCoupons.put("coupon", jsonParams);
        RequestBody couponsRequest = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)new JSONObject((Map)jsonParamsCoupons).toString());
        Call<ResponseBody> couponsCall = service.getUserCoupons(WarplyProperty.getAppUuid(Warply.getWarplyContext()), couponsRequest, timeStamp, "android:" + Warply.getWarplyContext().getPackageName(), new WarplyDeviceInfoCollector(Warply.getWarplyContext()).getUniqueDeviceId(), "mobile", webId, WarpUtils.produceSignature(apiKey + timeStamp), "Bearer " + WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
        couponsCall.enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
                if (response.code() == 200 && response.body() != null) {
                    JSONObject jobjCouponsResponse = null;
                    try {
                        jobjCouponsResponse = new JSONObject(((ResponseBody)response.body()).string());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jobjCouponsResponse != null && jobjCouponsResponse.has("status") && jobjCouponsResponse.optString("status", "2").equals("1")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_user_coupons_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        JSONArray jCouponsBody = null;
                        try {
                            jCouponsBody = jobjCouponsResponse.optJSONArray("result");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (jCouponsBody != null) {
                            CouponList mCouponsList = new CouponList();
                            CouponList mCouponRedeemedList = new CouponList();
                            CouponList mActiveCouponList = new CouponList();
                            ExecutorService executorCoupons = Executors.newFixedThreadPool(1);
                            JSONArray finalJCouponsBody = jCouponsBody;
                            executorCoupons.submit(() -> {
                                for (int i = 0; i < finalJCouponsBody.length(); ++i) {
                                    Coupon tempCoupon = new Coupon(finalJCouponsBody.optJSONObject(i), true);
                                    if (TextUtils.isEmpty((CharSequence)tempCoupon.getCouponsetDetails().getCouponsetType()) || !tempCoupon.getCouponsetDetails().getCouponsetType().equals("supermarket")) {
                                        mCouponsList.add(tempCoupon);
                                    }
                                    if (tempCoupon.getStatus() == 0) {
                                        mCouponRedeemedList.add(tempCoupon);
                                        continue;
                                    }
                                    if (tempCoupon.getStatus() != 1 || !TextUtils.isEmpty((CharSequence)tempCoupon.getCouponsetDetails().getCouponsetType()) && tempCoupon.getCouponsetDetails().getCouponsetType().equals("supermarket")) continue;
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                                    Date newDate = new Date();
                                    try {
                                        newDate = simpleDateFormat.parse(tempCoupon.getExpiration());
                                    }
                                    catch (ParseException e) {
                                        e.printStackTrace();
                                    }
                                    tempCoupon.setExpirationDate(newDate);
                                    mActiveCouponList.add(tempCoupon);
                                }
                                WarplyManagerHelper.setCouponList(mCouponsList);
                                WarplyManagerHelper.setCouponRedeemedList(mCouponRedeemedList);
                                OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventRewardsCouponsService.class).build();
                                WorkManager.getInstance((Context)Warply.getWarplyContext()).enqueue((WorkRequest)mywork);
                                Collections.sort(mActiveCouponList, (coupon1, coupon2) -> coupon1.getExpirationDate().compareTo(coupon2.getExpirationDate()));
                                executorCoupons.shutdownNow();
                                future.set((Object)mActiveCouponList);
                            });
                        }
                    } else {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_user_coupons_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        future.set((Object)new CouponList());
                    }
                } else if (response.code() == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getCouponsUniversalRetro(service, tries, (SettableFuture<CouponList>)future);
                            } else if (tries < 3) {
                                WarplyManager.getCouponsUniversalRetro(service, tries + 1, (SettableFuture<CouponList>)future);
                            } else {
                                future.setException(new Throwable());
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            if (tries < 3) {
                                WarplyManager.getCouponsUniversalRetro(service, tries + 1, (SettableFuture<CouponList>)future);
                            } else {
                                future.setException(new Throwable());
                            }
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_user_coupons_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    future.setException(new Throwable());
                }
            }

            public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_error_user_coupons_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                future.setException(new Throwable());
            }
        });
        return future;
    }

    public static void getCosmoteUser(WarplyCosmoteUserRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Cosmote User Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Cosmote User Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(false, "cosuser", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    JSONObject tokens = result.optJSONObject("result");
                    if (tokens != null) {
                        WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveClientAccess(tokens.optString("client_id", ""), tokens.optString("client_secret", ""));
                        WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveAuthAccess(tokens.optString("access_token", ""), tokens.optString("refresh_token", ""));
                        JSONObject newResult = new JSONObject();
                        try {
                            newResult.putOpt("status", (Object)1);
                            newResult.putOpt("message", (Object)"Success");
                            receiver.onSuccess(newResult);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            receiver.onFailure(2);
                        }
                        WarplyManager.getConsumer(new WarplyConsumerRequest(), new CallbackReceiver<Consumer>(){

                            @Override
                            public void onSuccess(Consumer result) {
                                JSONObject profMetadata;
                                WarplyManagerHelper.setConsumerInternal(result);
                                if (result != null) {
                                    profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata());
                                    if (profMetadata != null && profMetadata.has("nonTelco")) {
                                        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), profMetadata.optBoolean("nonTelco"));
                                    } else {
                                        WarpUtils.setUserNonTelco(Warply.getWarplyContext(), false);
                                    }
                                }
                                if (result != null && (profMetadata = WarpJSONParser.getJSONFromString(result.getProfileMetadata())) != null && profMetadata.has("badge")) {
                                    WarpUtils.setUserTag(Warply.getWarplyContext(), profMetadata.optString("badge"));
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) {
                            }
                        });
                    } else {
                        receiver.onFailure(2);
                    }
                } else {
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }

    public static void submitOrder(final CosmoteSubmitOrderRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Submit Order Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Submit Order Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_submit_order_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_submit_order_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.submitOrder(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_submit_order_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void getSharingHistory(final WarplySharingHistoryRequest request, final CallbackReceiver<SharingList> receiver) {
        WarpUtils.log("************* WARPLY Sharing History Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Sharing History Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData("coupon", true, "context", request.toJson(), new SharingHook(new CallbackReceiver<SharingList>(){

            @Override
            public void onSuccess(SharingList response) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_sharing_history_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                receiver.onSuccess(response);
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.getSharingHistory(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_sharing_history_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        }, request.getSignature()));
    }

    public static void postEvent(final CosmotePostEventRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Post Event Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Post Event Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_post_event_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_post_event_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.postEvent(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_post_event_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void setPacingDetails(final PacingCalculateRequest request, final CallbackReceiver<JSONObject> receiver) {
        WarpUtils.log("************* WARPLY Post Event Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Post Event Request is active");
        WarpUtils.log("**************************************************");
        Warply.postReceiveMicroappData(true, "context", request.toJson(), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                int status = result.optInt("status", 2);
                if (status == 1) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_save_pacing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onSuccess(result);
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_save_pacing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(status);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 401) {
                    WarplyManager.refreshToken(new WarplyRefreshTokenRequest(), new CallbackReceiver<JSONObject>(){

                        @Override
                        public void onSuccess(JSONObject result) {
                            int status = result.optInt("status", 2);
                            if (status == 1) {
                                WarplyManager.setPacingDetails(request, receiver);
                            } else {
                                receiver.onFailure(status);
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            receiver.onFailure(errorCode);
                        }
                    });
                } else {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_error_save_pacing_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    receiver.onFailure(errorCode);
                }
            }
        });
    }

    public static void getSingleCampaign(String sessionUuid) {
        WarpUtils.log("************* WARPLY Get Event Request ********************");
        WarpUtils.log("[WARP Trace] WARPLY Get Event Request is active");
        WarpUtils.log("**************************************************");
        String url = WarplyProperty.getBaseUrl(Warply.getWarplyContext()) + "/api/session/" + sessionUuid;
        Warply.INSTANCE.getSingleCampaign(null, url, new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                dynatraceEvent.setEventName("custom_success_read_campaign_loyalty");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                WarplyManager.getCampaigns(new CallbackReceiver<ArrayList<Campaign>>(){

                    @Override
                    public void onSuccess(ArrayList<Campaign> result) {
                        OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
                        WorkManager.getInstance((Context)Warply.getWarplyContext()).enqueue((WorkRequest)mywork);
                    }

                    @Override
                    public void onFailure(int errorCode) {
                    }
                });
            }

            @Override
            public void onFailure(int errorCode) {
                if (errorCode == 301 || errorCode == 302 || errorCode == 307 || errorCode == 308) {
                    LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                    dynatraceEvent.setEventName("custom_success_read_campaign_loyalty");
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    WarplyManager.getCampaigns(new CallbackReceiver<ArrayList<Campaign>>(){

                        @Override
                        public void onSuccess(ArrayList<Campaign> result) {
                            OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
                            WorkManager.getInstance((Context)Warply.getWarplyContext()).enqueue((WorkRequest)mywork);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                        }
                    });
                }
            }
        }, null);
    }

    private static boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)Warply.getWarplyContext().getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }
}

