/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils.managers;

import android.content.Context;
import java.util.HashMap;
import java.util.Map;
import ly.warp.sdk.Warply;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyPreferences;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONObject;

public class WarplyServerPreferencesManager {
    private static Map<WarpConstants.MicroApp, Boolean> MICRO_APP_STATUSES_MAP;

    public static void initiateMicroAppStatusesMap() {
        HashMap<WarpConstants.MicroApp, Boolean> map = new HashMap<WarpConstants.MicroApp, Boolean>();
        WarplyPreferences wPref = new WarplyPreferences(Warply.getWarplyContext());
        map.put(WarpConstants.MicroApp.CONSUMER, wPref.getConsumerAppStatus());
        map.put(WarpConstants.MicroApp.APPLICATION_DATA, wPref.getAppDataStatus());
        map.put(WarpConstants.MicroApp.OFFERS, wPref.getOffersStatus());
        map.put(WarpConstants.MicroApp.LIFECYCLE_ANALYTICS, wPref.getLifeCycleAnalyticsStatus());
        map.put(WarpConstants.MicroApp.CUSTOM_ANALYTICS, wPref.getCustomAnalyticsStatus());
        map.put(WarpConstants.MicroApp.USER_TAGGING, wPref.getUserTaggingStatus());
        map.put(WarpConstants.MicroApp.DEVICE_INFO, wPref.getDeviceInfoStatus());
        map.put(WarpConstants.MicroApp.USER_SESSION, wPref.getUserSessionStatus());
        map.put(WarpConstants.MicroApp.BEACONS, wPref.getBeaconsStatus());
        map.put(WarpConstants.MicroApp.RADIO_SILENT, wPref.getRadioSilentStatus());
        MICRO_APP_STATUSES_MAP = map;
    }

    public static void initiateMicroAppStatusesMap(Context context) {
        HashMap<WarpConstants.MicroApp, Boolean> map = new HashMap<WarpConstants.MicroApp, Boolean>();
        WarplyPreferences wPref = new WarplyPreferences(context);
        map.put(WarpConstants.MicroApp.CONSUMER, wPref.getConsumerAppStatus());
        map.put(WarpConstants.MicroApp.APPLICATION_DATA, wPref.getAppDataStatus());
        map.put(WarpConstants.MicroApp.OFFERS, wPref.getOffersStatus());
        map.put(WarpConstants.MicroApp.LIFECYCLE_ANALYTICS, wPref.getLifeCycleAnalyticsStatus());
        map.put(WarpConstants.MicroApp.CUSTOM_ANALYTICS, wPref.getCustomAnalyticsStatus());
        map.put(WarpConstants.MicroApp.USER_TAGGING, wPref.getUserTaggingStatus());
        map.put(WarpConstants.MicroApp.DEVICE_INFO, wPref.getDeviceInfoStatus());
        map.put(WarpConstants.MicroApp.USER_SESSION, wPref.getUserSessionStatus());
        map.put(WarpConstants.MicroApp.BEACONS, wPref.getBeaconsStatus());
        map.put(WarpConstants.MicroApp.RADIO_SILENT, wPref.getRadioSilentStatus());
        MICRO_APP_STATUSES_MAP = map;
    }

    public static boolean isMicroAppActive(WarpConstants.MicroApp app) {
        if (MICRO_APP_STATUSES_MAP == null) {
            WarplyServerPreferencesManager.initiateMicroAppStatusesMap();
        }
        return MICRO_APP_STATUSES_MAP.get((Object)app);
    }

    public static boolean isMicroAppActive(Context context, WarpConstants.MicroApp app) {
        if (MICRO_APP_STATUSES_MAP == null) {
            WarplyServerPreferencesManager.initiateMicroAppStatusesMap(context);
        }
        return MICRO_APP_STATUSES_MAP.get((Object)app);
    }

    public static void checkServerPreferences(final ServerPreferencesReceivedListener receiveListener) {
        Warply.getMicroappData(null, new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                JSONObject json;
                if (result != null && (json = result.optJSONObject("context")) != null) {
                    JSONObject deviceStatusJson;
                    WarplyServerPreferencesManager.saveMicroAppStatusesAtPreferences(WarplyServerPreferencesManager.getMicroAppStatuses(result));
                    JSONObject appDataJson = json.optJSONObject("application_data");
                    if (appDataJson != null) {
                        Warply.LOCATION_SETTINGS_MAP = new HashMap<WarpConstants.LocationSetting, Integer>();
                        Warply.LOCATION_SETTINGS_MAP.put(WarpConstants.LocationSetting.LOCATION_FOREGROUND_MODE, WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.LOCATION_FOREGROUND_MODE.getJsonKey(), 0));
                        Warply.LOCATION_SETTINGS_MAP.put(WarpConstants.LocationSetting.FOREGROUND_MIN_TIME, WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.FOREGROUND_MIN_TIME.getJsonKey(), 60000));
                        Warply.LOCATION_SETTINGS_MAP.put(WarpConstants.LocationSetting.FOREGROUND_MIN_DISTANCE, WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.FOREGROUND_MIN_DISTANCE.getJsonKey(), 100));
                        Warply.LOCATION_SETTINGS_MAP.put(WarpConstants.LocationSetting.LOCATION_BACKGROUND_MODE, WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.LOCATION_BACKGROUND_MODE.getJsonKey(), 0));
                        Warply.LOCATION_SETTINGS_MAP.put(WarpConstants.LocationSetting.BACKGROUND_MIN_TIME, WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.BACKGROUND_MIN_TIME.getJsonKey(), 60000));
                        Warply.LOCATION_SETTINGS_MAP.put(WarpConstants.LocationSetting.BACKGROUND_MIN_DISTANCE, WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.BACKGROUND_MIN_DISTANCE.getJsonKey(), 100));
                        Warply.LOCATION_SETTINGS_MAP.put(WarpConstants.LocationSetting.FEATURES_CHECK_INTERVAL, WarpJSONParser.getIntFromJSONObject(appDataJson, WarpConstants.LocationSetting.FEATURES_CHECK_INTERVAL.getJsonKey(), 86400));
                        WarplyPreferences pref = new WarplyPreferences(Warply.getWarplyContext());
                        pref.saveInt("BEACON_MAX_DISTANCE", WarpJSONParser.getIntFromJSONObject(appDataJson, "BEACON_MAX_DISTANCE", 20));
                        long scanPeriod = WarpJSONParser.getLongFromJSONObject(appDataJson, "BEACON_TIME_INTERVAL", 5000L);
                        pref.saveLong("BEACON_TIME_INTERVAL", scanPeriod == 5000L ? scanPeriod : scanPeriod * 1000L);
                        long timeInterval = WarpJSONParser.getLongFromJSONObject(appDataJson, "BEACON_TIME_INTERVAL_TO_RESEND", 30000L);
                        pref.saveLong("BEACON_TIME_INTERVAL_TO_RESEND", timeInterval == 30000L ? timeInterval : timeInterval * 1000L);
                        String[] layouts = null;
                        JSONArray layoutsJson = appDataJson.optJSONArray("BEACON_LAYOUTS");
                        if (layoutsJson != null && layoutsJson.length() > 0) {
                            layouts = new String[layoutsJson.length()];
                            for (int i = 0; i < layoutsJson.length(); ++i) {
                                layouts[i] = layoutsJson.optString(i);
                            }
                        }
                        pref.saveStringArray("BEACON_LAYOUTS", layouts);
                        int newVersionCode = WarpJSONParser.getIntFromJSONObject(appDataJson, "ANDROID_NEW_VERSION", 0);
                        pref.saveInt("ANDROID_NEW_VERSION", newVersionCode);
                        boolean hasUpdate = WarpJSONParser.getBooleanFromJSONObject(appDataJson, "ANDROID_HAS_UPDATE", false);
                        pref.saveBoolean("ANDROID_HAS_UPDATE", hasUpdate);
                        boolean forceUpdate = WarpJSONParser.getBooleanFromJSONObject(appDataJson, "ANDROID_FORCE_UPDATE", false);
                        pref.saveBoolean("ANDROID_FORCE_UPDATE", forceUpdate);
                    }
                    if ((deviceStatusJson = json.optJSONObject("device_status")) != null) {
                        if (!deviceStatusJson.optBoolean("has_application_info")) {
                            Warply.resetApplicationInfo();
                        }
                        if (deviceStatusJson.optBoolean("has_device_info")) {
                            Warply.resetDeviceInfo();
                        }
                        if (!deviceStatusJson.optBoolean("is_warped")) {
                            Warply.resetIsWarped();
                        }
                    }
                }
                receiveListener.onServerPreferencesReceived();
            }

            @Override
            public void onFailure(int errorCode) {
                WarpUtils.log("Error with code " + errorCode + " while checking app statuses");
            }
        });
    }

    private static Map<WarpConstants.MicroApp, Boolean> getMicroAppStatuses(JSONObject result) {
        HashMap<WarpConstants.MicroApp, Boolean> statuses;
        block5: {
            statuses = new HashMap<WarpConstants.MicroApp, Boolean>(WarpConstants.MicroApp.values().length);
            for (int i = 0; i < WarpConstants.MicroApp.values().length; ++i) {
                statuses.put(WarpConstants.MicroApp.values()[i], true);
            }
            JSONObject json = result.optJSONObject("context");
            if (json == null || (json = json.optJSONObject("application_data")) == null || !json.has("WARPLY_ENABLED")) break block5;
            if (json.optBoolean("WARPLY_ENABLED")) {
                for (int i = 0; i < WarpConstants.MicroApp.values().length; ++i) {
                    statuses.put(WarpConstants.MicroApp.values()[i], WarpJSONParser.getBooleanFromJSONObject(json, WarpConstants.MicroApp.values()[i].getJsonKey(), true));
                }
            } else {
                for (int i = 0; i < WarpConstants.MicroApp.values().length; ++i) {
                    statuses.put(WarpConstants.MicroApp.values()[i], false);
                }
            }
        }
        return statuses;
    }

    private static void saveMicroAppStatusesAtPreferences(Map<WarpConstants.MicroApp, Boolean> map) {
        MICRO_APP_STATUSES_MAP = map;
        WarplyPreferences wPref = new WarplyPreferences(Warply.getWarplyContext());
        wPref.saveConsumerAppStatus(map.get((Object)WarpConstants.MicroApp.CONSUMER));
        wPref.saveAppDataStatus(map.get((Object)WarpConstants.MicroApp.APPLICATION_DATA));
        wPref.saveOffersStatus(map.get((Object)WarpConstants.MicroApp.OFFERS));
        wPref.saveLifeCycleAnalyticsStatus(map.get((Object)WarpConstants.MicroApp.LIFECYCLE_ANALYTICS));
        wPref.saveCustomAnalyticsStatus(map.get((Object)WarpConstants.MicroApp.CUSTOM_ANALYTICS));
        wPref.saveUserTaggingStatus(map.get((Object)WarpConstants.MicroApp.USER_TAGGING));
        wPref.saveDeviceInfoStatus(map.get((Object)WarpConstants.MicroApp.DEVICE_INFO));
        wPref.saveUserSessionStatus(map.get((Object)WarpConstants.MicroApp.USER_SESSION));
        wPref.saveBeaconsStatus(map.get((Object)WarpConstants.MicroApp.BEACONS));
        wPref.saveRadioSilentStatus(map.get((Object)WarpConstants.MicroApp.RADIO_SILENT));
    }

    public static interface ServerPreferencesReceivedListener {
        public void onServerPreferencesReceived();
    }
}

