/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils.managers;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarpUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplySessionManager {
    public static void onCreateActivity(Activity activity) {
        Warply.getInitializer((Context)activity).init();
        WarplySessionManager.onApplicationStart();
    }

    public static void onStartActivity(Activity activity) {
        Warply.getInitializer((Context)activity).init();
        WarplySessionManager.onApplicationEnterForeground();
    }

    public static void onStopActivity(Activity activity) {
        Warply.getInitializer((Context)activity).init();
        WarplySessionManager.onApplicationEnterBackground();
    }

    private static void onApplicationStart() {
        Warply.onApplicationStarted();
    }

    private static void onApplicationEnterForeground() {
        Warply.onApplicationEnterForeground();
    }

    private static void onApplicationEnterBackground() {
        Warply.onApplicationEnterBackground();
    }

    private static class ConnectivityReceiver
    extends BroadcastReceiver {
        private static final int TYPE_NOTHING = 0;
        private static final int TYPE_MOBILE = 1;
        private static final int TYPE_WIFI = 2;
        private int mType = 0;
        private long mStart = -1L;
        private long mWifi = 0L;
        private long mWWan = 0L;

        private ConnectivityReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            ConnectivityReceiver connectivityReceiver = this;
            synchronized (connectivityReceiver) {
                this.saveState();
                ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo info = manager.getActiveNetworkInfo();
                if (info == null) {
                    return;
                }
                boolean isConneted = info.isConnectedOrConnecting();
                if (!isConneted) {
                    return;
                }
                int type = info.getType();
                switch (type) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        this.onMobileConnectionChange();
                        break;
                    }
                    case 1: 
                    case 6: 
                    case 9: {
                        this.onWifiConnectionChange();
                        break;
                    }
                    default: {
                        this.mType = 0;
                    }
                }
            }
        }

        private void saveState() {
            switch (this.mType) {
                case 1: {
                    this.mWWan += System.currentTimeMillis() - this.mStart;
                    break;
                }
                case 2: {
                    this.mWifi += System.currentTimeMillis() - this.mStart;
                }
            }
            this.mType = 0;
        }

        private void onMobileConnectionChange() {
            this.mStart = System.currentTimeMillis();
            this.mType = 1;
        }

        private void onWifiConnectionChange() {
            this.mStart = System.currentTimeMillis();
            this.mType = 2;
        }

        private void startTracking() {
            this.mStart = 0L;
            this.mWifi = 0L;
            this.mWWan = 0L;
            this.mType = 0;
            Context context = Warply.getWarplyContext();
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver((BroadcastReceiver)this, filter);
            this.onReceive(context, null);
        }

        private void stopTracking() {
            Context context = Warply.getWarplyContext();
            context.unregisterReceiver((BroadcastReceiver)this);
            this.saveState();
            long total = this.mWifi + this.mWWan;
            if (total <= 0L) {
                return;
            }
            double wifiPerc = (double)this.mWifi / (double)total;
            double wWanPerc = (double)this.mWWan / (double)total;
            try {
                JSONObject json = new JSONObject();
                JSONObject usage = new JSONObject();
                JSONObject time = new JSONObject();
                usage.putOpt("wifi", (Object)wifiPerc);
                usage.putOpt("wwan", (Object)wWanPerc);
                time.putOpt("wifi", (Object)(this.mWifi / 1000L));
                time.putOpt("wwan", (Object)(this.mWWan / 1000L));
                json.putOpt("usage", (Object)usage);
                json.putOpt("time", (Object)time);
                if (Warply.isInitialized()) {
                    Warply.postMicroappData("device_info", json);
                }
            }
            catch (JSONException e) {
                WarpUtils.warn("Unexpected JSON Exception", (Exception)((Object)e));
            }
        }
    }
}

