/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.utils.managers;

import ly.warp.sdk.Warply;
import ly.warp.sdk.db.WarplyDBHelper;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.callbacks.SimpleCallbackReceiver;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;
import ly.warp.sdk.utils.managers.WarplyServerPreferencesManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarplyUserManager {
    private static final String ACTION = "action";
    private static final String ACTION_ADD_TAGS = "add_tags";
    private static final String ACTION_REMOVE_TAGS = "remove_tags";
    private static final String ACTION_REMOVE_ALL_TAGS = "remove_all_tags";
    private static final String ACTION_REWRITE_TAGS = "rewrite_tags";
    private static final String TAGS = "tags";

    public static void sendName(String userName) {
        boolean isConsumerDataMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.CONSUMER);
        if (isConsumerDataMicroAppActive) {
            WarplyUserManager.sendLoginData("user_name", userName);
        } else {
            WarpUtils.log("consumer data micro-app is not active");
        }
    }

    public static void sendEmail(String email) {
        boolean isConsumerDataMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.CONSUMER);
        if (isConsumerDataMicroAppActive) {
            WarplyUserManager.sendLoginData("user_email", email);
        } else {
            WarpUtils.log("consumer data micro-app is not active");
        }
    }

    public static void sendMsisdn(String msisdn) {
        boolean isConsumerDataMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.CONSUMER);
        if (isConsumerDataMicroAppActive) {
            WarplyUserManager.sendLoginData("msisdn", msisdn);
        } else {
            WarpUtils.log("consumer data micro-app is not active");
        }
    }

    public static void sendCustomData(JSONObject customData) {
        boolean isConsumerDataMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.CONSUMER);
        if (isConsumerDataMicroAppActive) {
            WarplyUserManager.sendConsumerDataWithJSON("custom_data", customData);
        } else {
            WarpUtils.log("consumer data micro-app is not active");
        }
    }

    public static void getCustomData(final CallbackReceiver<JSONObject> receiver) {
        boolean isConsumerDataMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.CONSUMER);
        if (isConsumerDataMicroAppActive) {
            Warply.getMicroappData("consumer_data", new CallbackReceiver<JSONObject>(){

                @Override
                public void onSuccess(JSONObject result) {
                    JSONObject contextData = WarpJSONParser.getJObjectFromJSON(result, "context");
                    JSONObject consumerData = null;
                    if (contextData != null && contextData.has("consumer_data")) {
                        consumerData = WarpJSONParser.getJObjectFromJSON(contextData, "consumer_data");
                    }
                    if (consumerData != null && consumerData.has("custom_data")) {
                        JSONObject customData = WarpJSONParser.getJObjectFromJSON(consumerData, "custom_data");
                        receiver.onSuccess(customData);
                    } else {
                        receiver.onSuccess(null);
                    }
                }

                @Override
                public void onFailure(int errorCode) {
                    receiver.onFailure(errorCode);
                    WarpUtils.log("get data from WarplyUserManager returned error: " + errorCode);
                }
            });
        }
    }

    public static void getName(final CallbackReceiver<String> receiver) {
        WarplyUserManager.getLoginData(new CallbackReceiver<String>(){

            @Override
            public void onSuccess(String result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        }, "user_name");
    }

    public static void getEmail(final CallbackReceiver<String> receiver) {
        WarplyUserManager.getLoginData(new CallbackReceiver<String>(){

            @Override
            public void onSuccess(String result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        }, "user_email");
    }

    private static void getLoginData(final CallbackReceiver<String> receiver, final String key) {
        boolean isConsumerDataMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.CONSUMER);
        if (isConsumerDataMicroAppActive) {
            Warply.getMicroappData("consumer_data", new CallbackReceiver<JSONObject>(){

                @Override
                public void onSuccess(JSONObject result) {
                    JSONObject contextData = WarpJSONParser.getJObjectFromJSON(result, "context");
                    JSONObject consumerData = null;
                    if (contextData != null && contextData.has("consumer_data")) {
                        consumerData = WarpJSONParser.getJObjectFromJSON(contextData, "consumer_data");
                    }
                    String loginValue = null;
                    if (consumerData != null && consumerData.has(key)) {
                        loginValue = WarpJSONParser.getStringFromJSON(consumerData, key, null);
                        receiver.onSuccess(loginValue);
                    } else {
                        receiver.onSuccess(null);
                    }
                }

                @Override
                public void onFailure(int errorCode) {
                    receiver.onFailure(errorCode);
                    WarpUtils.log("get data from WarplyUserManager returned error: " + errorCode);
                }
            });
        }
    }

    public static void getMsisdn(final CallbackReceiver<String> receiver) {
        WarplyUserManager.getLoginData(new CallbackReceiver<String>(){

            @Override
            public void onSuccess(String result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        }, "msisdn");
    }

    private static void sendLoginData(String jsonLabel, String userData) {
        JSONObject jObj = new JSONObject();
        try {
            jObj.putOpt(jsonLabel, (Object)userData);
        }
        catch (JSONException e) {
            WarpUtils.log("JSON Exception thrown while creating the object in sendData at WarplyUserManager", (Exception)((Object)e));
        }
        Warply.postMicroappData("login_data", jObj, true);
    }

    private static void sendConsumerDataWithJSON(String jsonLabel, JSONObject jsonObject) {
        JSONObject jObj = new JSONObject();
        try {
            jObj.putOpt(jsonLabel, (Object)jsonObject);
        }
        catch (JSONException e) {
            WarpUtils.log("JSON Exception thrown while creating the object in sendData at WarplyUserManager", (Exception)((Object)e));
        }
        Warply.postMicroappData("consumer_data", jObj, true);
    }

    public static void addTag(String tag) {
        WarplyUserManager.addTags(new String[]{tag});
    }

    public static void addTags(String[] tags) {
        if (WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.USER_TAGGING)) {
            if (tags != null && tags.length > 0) {
                try {
                    JSONObject jObj = new JSONObject();
                    JSONArray jArray = new JSONArray();
                    jObj.putOpt(ACTION, (Object)ACTION_ADD_TAGS);
                    for (String tag : tags) {
                        jArray.put((Object)tag);
                    }
                    jObj.putOpt(TAGS, (Object)jArray);
                    WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveTags(tags);
                    Warply.postMicroappData(TAGS, jObj, true);
                }
                catch (JSONException e) {
                    WarpUtils.log("JSON Exception thrown while creating the object in addTags at WarplyUserManager", (Exception)((Object)e));
                }
            }
        } else {
            WarpUtils.log("user tagging micro-app is not active");
        }
    }

    public static void removeTag(String tag) {
        WarplyUserManager.removeTags(new String[]{tag});
    }

    public static void removeTags(String[] tags) {
        if (WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.USER_TAGGING)) {
            if (tags != null && tags.length > 0) {
                try {
                    JSONObject jObj = new JSONObject();
                    JSONArray jArray = new JSONArray();
                    jObj.putOpt(ACTION, (Object)ACTION_REMOVE_TAGS);
                    for (String tag : tags) {
                        jArray.put((Object)tag);
                    }
                    jObj.putOpt(TAGS, (Object)jArray);
                    WarplyDBHelper.getInstance(Warply.getWarplyContext()).removeTags(tags);
                    Warply.postMicroappData(TAGS, jObj, true);
                }
                catch (JSONException e) {
                    WarpUtils.log("JSON Exception thrown while creating the object for in removeTags at WarplyUserManager", (Exception)((Object)e));
                }
            }
        } else {
            WarpUtils.log("user tagging micro-app is not active");
        }
    }

    public static void removeAllTags() {
        if (WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.USER_TAGGING)) {
            try {
                WarplyDBHelper.getInstance(Warply.getWarplyContext()).removeAllTags();
                Warply.postMicroappData(TAGS, new JSONObject().putOpt(ACTION, (Object)ACTION_REMOVE_ALL_TAGS), true);
            }
            catch (JSONException e) {
                WarpUtils.log("JSON Exception thrown while creating the object for removeAllTags at WarplyUserManager", (Exception)((Object)e));
            }
        } else {
            WarpUtils.log("user tagging micro-app is not active");
        }
    }

    public static void rewriteTags() {
        if (WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.USER_TAGGING)) {
            String[] localTags = WarplyDBHelper.getInstance(Warply.getWarplyContext()).getTags();
            if (localTags != null && localTags.length > 0) {
                try {
                    JSONObject jObj = new JSONObject();
                    jObj.putOpt(ACTION, (Object)ACTION_REWRITE_TAGS);
                    JSONArray jArray = new JSONArray();
                    for (String tag : localTags) {
                        jArray.put((Object)tag);
                    }
                    jObj.putOpt(TAGS, (Object)jArray);
                    Warply.postMicroappData(TAGS, jObj, true);
                }
                catch (JSONException e) {
                    WarpUtils.log("JSON Exception thrown while creating the object for rewriteTags at WarplyUserManager", (Exception)((Object)e));
                }
            }
        } else {
            WarpUtils.log("user tagging micro-app is not active");
        }
    }

    public static void getTags(final SimpleCallbackReceiver<String[]> callbackReceiver) {
        if (WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.USER_TAGGING)) {
            Warply.getContext(new CallbackReceiver<JSONObject>(){

                @Override
                public void onSuccess(JSONObject result) {
                    JSONArray jArray;
                    String[] tags = null;
                    JSONObject json = WarpJSONParser.getJObjectFromJSON(result, "context");
                    if (json != null && (jArray = WarpJSONParser.getJSONArrayFromJson(json, WarplyUserManager.TAGS)) != null) {
                        tags = new String[jArray.length()];
                        for (int i = 0; i < jArray.length(); ++i) {
                            tags[i] = WarpJSONParser.getStringFromJSONArray(jArray, i, null);
                        }
                    }
                    callbackReceiver.onSuccess(tags);
                }

                @Override
                public void onFailure(int errorCode) {
                    callbackReceiver.onFailure(errorCode);
                }
            });
        } else {
            WarpUtils.log("user tagging micro-app is not active");
            callbackReceiver.onFailure(2);
        }
    }

    public static void getTagsLocal(SimpleCallbackReceiver<String[]> callbackReceiver) {
        if (WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.USER_TAGGING)) {
            callbackReceiver.onSuccess(WarplyDBHelper.getInstance(Warply.getWarplyContext()).getTags());
        } else {
            WarpUtils.log("user tagging micro-app is not active");
            callbackReceiver.onFailure(2);
        }
    }

    public static void sessionLogin(String authToken) {
        boolean isUserSessionMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.USER_SESSION);
        if (isUserSessionMicroAppActive) {
            WarplyUserManager.postUserSessionAction("login", authToken);
        } else {
            WarpUtils.log("user session micro-app is not active");
        }
    }

    public static void sessionLogout(String authToken) {
        boolean isUserSessionMicroAppActive = WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.USER_SESSION);
        if (isUserSessionMicroAppActive) {
            WarplyUserManager.postUserSessionAction("logout", authToken);
        } else {
            WarpUtils.log("user session micro-app is not active");
        }
    }

    private static void postUserSessionAction(final String action, final String authToken) {
        Warply.postReceiveMicroappData("user_session", WarplyUserManager.createUserSessionJSON(action, authToken), new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
            }

            @Override
            public void onFailure(int errorCode) {
                if (action.equals("login")) {
                    WarplyUserManager.postUserSessionAction("register", authToken);
                }
            }
        });
        Warply.postMicroappData("user_session", WarplyUserManager.createUserSessionJSON(action, authToken), false);
    }

    private static JSONObject createUserSessionJSON(String action, String authToken) {
        JSONObject actionObj = new JSONObject();
        JSONObject authTokenObj = new JSONObject();
        try {
            authTokenObj.putOpt("auth_token", (Object)authToken);
            actionObj.putOpt(action, (Object)authTokenObj);
        }
        catch (JSONException e) {
            WarpUtils.log("JSON Exception thrown while creating the object in createUserSessionJSON at WarplyUserManager", (Exception)((Object)e));
        }
        return actionObj;
    }

    public static void setWarplyNotificationsEnabled(final boolean enable, final CallbackReceiver<Boolean> receiver) {
        JSONObject postJSON = new JSONObject();
        try {
            postJSON.put("warp_enabled", (Object)enable);
            Warply.postReceiveMicroappData("application_data", postJSON, new CallbackReceiver<JSONObject>(){

                @Override
                public void onSuccess(JSONObject result) {
                    receiver.onSuccess(enable);
                }

                @Override
                public void onFailure(int errorCode) {
                    receiver.onFailure(errorCode);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void getWarplyNotificationsEnabled(final CallbackReceiver<Boolean> receiver) {
        Warply.getMicroappData("device_status", new CallbackReceiver<JSONObject>(){

            @Override
            public void onSuccess(JSONObject response) {
                try {
                    JSONObject context = response.getJSONObject("context");
                    JSONObject deviceStatus = context.getJSONObject("device_status");
                    boolean isEnabled = deviceStatus.getBoolean("warp_enabled");
                    receiver.onSuccess(isEnabled);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        });
    }
}

