/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyDeviceInfoCollector;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.WarplyUrlHandler;
import ly.warp.sdk.views.CampaignItemViewHolder;
import ly.warp.sdk.views.WarpView;

public class CampaignItemWebHolder
extends CampaignItemViewHolder {
    private WarpView mWarpView;
    private View mProgress;

    public CampaignItemWebHolder(ViewGroup root, int itemWidth, int itemHeight) {
        super(CampaignItemWebHolder.getWebItem(root.getContext(), itemWidth, itemHeight));
        this.itemView.setOnClickListener(null);
        this.mProgress = ((ViewGroup)this.itemView).getChildAt(((ViewGroup)this.itemView).getChildCount() - 2);
        this.mProgress.setVisibility(0);
        this.mWarpView = (WarpView)((ViewGroup)this.itemView).getChildAt(((ViewGroup)this.itemView).getChildCount() - 1);
        this.mWarpView.setVisibility(4);
    }

    private static ViewGroup getWebItem(Context context, int itemWidth, int itemHeight) {
        final RelativeLayout root = new RelativeLayout(context);
        root.setBackgroundColor(-1);
        itemWidth = itemWidth < -2 || itemWidth == 0 ? -1 : itemWidth;
        itemHeight = itemHeight < -2 || itemHeight == 0 ? new WarplyDeviceInfoCollector(root.getContext()).getDisplayHeight() / 5 : itemHeight;
        root.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(itemWidth, itemHeight));
        final ImageView ivLogo = new ImageView(context);
        RelativeLayout.LayoutParams ivLogoParams = new RelativeLayout.LayoutParams(-1, -1);
        ivLogo.setPadding(10, 10, 10, 10);
        ivLogoParams.addRule(13);
        root.addView((View)ivLogo, (ViewGroup.LayoutParams)ivLogoParams);
        ivLogo.setImageDrawable(WarplyProperty.getProgressDrawable(context));
        ivLogo.startAnimation(WarpUtils.getPulseAnimation());
        WarpView warpView = new WarpView(context);
        RelativeLayout.LayoutParams warpViewParams = new RelativeLayout.LayoutParams(-1, -1);
        warpView.setProgressChangeListener(new WarpView.ProgressChangeListener(){

            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (view.getProgress() == 100) {
                    WarpUtils.animateVisibility((View)view, 0);
                    WarpUtils.animateVisibility((View)ivLogo, 4);
                }
            }
        });
        warpView.setWarplyUrlHandler(new WarplyUrlHandler(){

            @Override
            public boolean canHandleUrl(String url) {
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    String requestAuthority = Uri.parse((String)url).getAuthority();
                    return !Uri.parse((String)WarplyProperty.getBaseUrl(root.getContext())).getAuthority().equals(requestAuthority) && !Uri.parse((String)"https://warply.s3-eu-west-1.amazonaws.com").getAuthority().equals(requestAuthority);
                }
                return false;
            }

            @Override
            public void handleUrl(Context context, String url) {
                try {
                    context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
            }
        });
        warpView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return event.getAction() == 2;
            }
        });
        warpView.setVerticalScrollBarEnabled(false);
        warpView.setHorizontalScrollBarEnabled(false);
        warpView.setScrollContainer(false);
        root.addView((View)warpView, (ViewGroup.LayoutParams)warpViewParams);
        return root;
    }

    @Override
    public void bindData(Campaign campaign, int position) {
        if (TextUtils.isEmpty((CharSequence)this.mWarpView.getLastSessionUUID()) || !this.mWarpView.getLastSessionUUID().equals(campaign.getSessionUUID())) {
            this.mWarpView.setVisibility(4);
            this.mProgress.setVisibility(0);
            this.mWarpView.loadWarpSessionUUID(campaign.getSessionUUID());
        }
    }

    @Override
    protected void setData(Campaign campaign, int position) {
    }

    @Override
    public void onClick(View v) {
    }
}

