/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views;

import android.content.Context;
import android.text.TextUtils;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import ly.warp.sdk.Warply;
import ly.warp.sdk.fragments.WarpViewFragment;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.callbacks.SimpleCallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.request.WarplyInboxRequest;

public class CampaignViewLoader
implements CallbackReceiver<CampaignList> {
    private DisplayBuilder mLastDisplayBuilder;
    private SimpleCallbackReceiver<CampaignList> mExternalListener;

    public CampaignViewLoader(Context context) {
        Warply.getInitializer(context).init();
    }

    @Override
    public void onSuccess(CampaignList result) {
        if (result != null && result.size() > 0) {
            this.showWarplyFragment(this.mLastDisplayBuilder, ((Campaign)result.get(0)).getSessionUUID());
        }
        this.notifySuccessExternalListener(result);
    }

    @Override
    public void onFailure(int errorCode) {
        this.notifyFailureExternalListener(errorCode);
    }

    private void requestCampaignsIfNeed(DisplayBuilder builder, WarplyInboxRequest request, String sessionUuid) {
        if (request != null && TextUtils.isEmpty((CharSequence)sessionUuid)) {
            this.mLastDisplayBuilder = builder;
            Warply.getInbox(request, this);
        } else if (!TextUtils.isEmpty((CharSequence)sessionUuid)) {
            this.showWarplyFragment(builder, sessionUuid);
            this.notifySuccessExternalListener(null);
        }
    }

    private void showWarplyFragment(DisplayBuilder builder, String sessionUuid) {
        if (builder != null && builder.fragmentManager != null) {
            WarpViewFragment warpFragment = WarpViewFragment.newInstance(sessionUuid, builder.isUseProgress, builder.isShowCloseBtn);
            FragmentTransaction transaction = builder.fragmentManager.beginTransaction().replace(builder.containerId, (Fragment)warpFragment, WarpViewFragment.class.getSimpleName()).setTransition(4097);
            if (builder.isAddToBackStack) {
                transaction.addToBackStack(null);
            }
            try {
                transaction.commit();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void notifySuccessExternalListener(CampaignList campaigns) {
        if (this.mExternalListener != null) {
            this.mExternalListener.onSuccess(campaigns);
        }
    }

    private void notifyFailureExternalListener(int errorCode) {
        if (this.mExternalListener != null) {
            this.mExternalListener.onFailure(errorCode);
        }
    }

    public void setCampaignsListener(SimpleCallbackReceiver<CampaignList> listener) {
        this.mExternalListener = listener;
    }

    public DisplayBuilder DisplayBuilder() {
        return new DisplayBuilder();
    }

    public class DisplayBuilder {
        private boolean isUseProgress = false;
        private boolean isShowCloseBtn = true;
        private boolean isAddToBackStack = true;
        private FragmentManager fragmentManager;
        private int containerId;

        public void display(FragmentActivity activity, WarplyInboxRequest request) {
            if (activity != null && !activity.isFinishing()) {
                this.display(activity, 0x1020002, request);
            }
        }

        public void display(FragmentActivity activity, int containerId, WarplyInboxRequest request) {
            if (activity != null && !activity.isFinishing()) {
                this.fragmentManager = activity.getSupportFragmentManager();
                this.containerId = containerId;
                CampaignViewLoader.this.requestCampaignsIfNeed(this, request, null);
            }
        }

        public void display(Fragment parentFragment, int containerId, WarplyInboxRequest request) {
            if (parentFragment != null && parentFragment.getActivity() != null && !parentFragment.getActivity().isFinishing()) {
                this.fragmentManager = parentFragment.getChildFragmentManager();
                this.containerId = containerId;
                CampaignViewLoader.this.requestCampaignsIfNeed(this, request, null);
            }
        }

        public void display(FragmentActivity activity, String sessionUuid) {
            if (activity != null && !activity.isFinishing()) {
                this.display(activity, 0x1020002, sessionUuid);
            }
        }

        public void display(FragmentActivity activity, int containerId, String sessionUuid) {
            if (activity != null && !activity.isFinishing()) {
                this.fragmentManager = activity.getSupportFragmentManager();
                this.containerId = containerId;
                CampaignViewLoader.this.requestCampaignsIfNeed(this, null, sessionUuid);
            }
        }

        public void display(Fragment parentFragment, int containerId, String sessionUuid) {
            if (parentFragment != null && parentFragment.getActivity() != null && !parentFragment.getActivity().isFinishing()) {
                this.fragmentManager = parentFragment.getChildFragmentManager();
                this.containerId = containerId;
                CampaignViewLoader.this.requestCampaignsIfNeed(this, null, sessionUuid);
            }
        }

        public DisplayBuilder setUseProgress(boolean use) {
            this.isUseProgress = use;
            return this;
        }

        public DisplayBuilder setShowCloseBtn(boolean show) {
            this.isShowCloseBtn = show;
            return this;
        }

        public DisplayBuilder setAddToBackStack(boolean add) {
            this.isAddToBackStack = add;
            return this;
        }
    }
}

