/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.util.AttributeSet;
import android.view.View;
import ly.warp.sdk.R;

public class DividerView
extends View {
    public static int ORIENTATION_HORIZONTAL = 0;
    public static int ORIENTATION_VERTICAL = 1;
    private Paint mPaint;
    private int orientation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DividerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int color2;
        int dashThickness;
        int dashLength;
        int dashGap;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DividerView, 0, 0);
        try {
            dashGap = a.getDimensionPixelSize(R.styleable.DividerView_dashGap, 5);
            dashLength = a.getDimensionPixelSize(R.styleable.DividerView_dashLength, 5);
            dashThickness = a.getDimensionPixelSize(R.styleable.DividerView_dashThickness, 3);
            color2 = a.getColor(R.styleable.DividerView_color, -16777216);
            this.orientation = a.getInt(R.styleable.DividerView_orientation, ORIENTATION_HORIZONTAL);
        }
        finally {
            a.recycle();
        }
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(color2);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)dashThickness);
        this.mPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{dashLength, dashGap}, 0.0f));
    }

    public DividerView(Context context) {
        this(context, null);
    }

    protected void onDraw(Canvas canvas) {
        if (this.orientation == ORIENTATION_HORIZONTAL) {
            float center = (float)this.getHeight() * 0.5f;
            canvas.drawLine(0.0f, center, (float)this.getWidth(), center, this.mPaint);
        } else {
            float center = (float)this.getWidth() * 0.5f;
            canvas.drawLine(center, 0.0f, center, (float)this.getHeight(), this.mPaint);
        }
    }
}

