/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.location.LocationManager;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.webkit.GeolocationPermissions;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import ly.warp.sdk.R;
import ly.warp.sdk.Warply;
import ly.warp.sdk.activities.ActiveCouponsActivity;
import ly.warp.sdk.activities.ActiveUnifiedCouponsActivity;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.db.WarplyDBHelper;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CouponEventModel;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.LoyaltySDKDynatraceEventModel;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.QuestionnaireEventModel;
import ly.warp.sdk.io.models.RefreshUnifiedCouponsEventModel;
import ly.warp.sdk.io.models.RefreshVouchersEventModel;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.io.models.WarplyCCMSEnabledModel;
import ly.warp.sdk.io.models.WarplyCouponsChangedEventModel;
import ly.warp.sdk.io.models.WarplyPacingCardEventModel;
import ly.warp.sdk.io.models.WarplyUnifiedActivatedEventModel;
import ly.warp.sdk.services.EventCampaignService;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.WarplyUrlHandler;
import ly.warp.sdk.utils.constants.WarpConstants;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarpView
extends WebView
implements DefaultLifecycleObserver {
    private static final String URL_ACTION_TEL = "tel";
    private static final String URL_ACTION_SMS = "sms";
    private static final String URL_ACTION_RSMS = "rsms";
    private static final String URL_ACTION_MAIL = "mailto";
    private static final String URL_ACTION_MARKET = "market";
    private static final String URL_ACTION_INTENT = "intent";
    private static final String URL_ACTION_MARKET_AUTHORITY = "play.google.com";
    private ProgressChangeListener mProgressListener;
    private WarplyUrlHandler mExternalUrlHandler;
    private WarplyUrlHandler mInternalUrlHandler;
    private String sessionUUID;
    private Activity WarpActivity;
    private String geolocationOrigin = "";
    private GeolocationPermissions.Callback geolocationCallback;
    private static boolean mWebviewLoaded = false;
    private final CallbackReceiver<ArrayList<UnifiedCoupon>> mUnifiedCallback = new CallbackReceiver<ArrayList<UnifiedCoupon>>(){

        @Override
        public void onSuccess(ArrayList<UnifiedCoupon> result) {
            Intent intent = new Intent((Context)(WarpView.this.WarpActivity != null && !WarpView.this.WarpActivity.isFinishing() ? WarpView.this.WarpActivity : WarpView.this.getContext()), ActiveUnifiedCouponsActivity.class);
            WarpView.this.getContext().startActivity(intent);
        }

        @Override
        public void onFailure(int errorCode) {
            Intent intent = new Intent((Context)(WarpView.this.WarpActivity != null && !WarpView.this.WarpActivity.isFinishing() ? WarpView.this.WarpActivity : WarpView.this.getContext()), ActiveUnifiedCouponsActivity.class);
            WarpView.this.getContext().startActivity(intent);
        }
    };
    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>(){

        @Override
        public void onSuccess(CouponList result) {
            WarplyCouponsChangedEventModel couponsChanged = new WarplyCouponsChangedEventModel();
            couponsChanged.setChanged(true);
            EventBus.getDefault().post((Object)new WarplyEventBusManager(couponsChanged));
        }

        @Override
        public void onFailure(int errorCode) {
        }
    };
    private CallbackReceiver<ArrayList<Campaign>> mCampaignsCallback = new CallbackReceiver<ArrayList<Campaign>>(){

        @Override
        public void onSuccess(ArrayList<Campaign> result) {
            OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
            WorkManager.getInstance((Context)(WarpView.this.WarpActivity != null && !WarpView.this.WarpActivity.isFinishing() ? WarpView.this.WarpActivity : WarpView.this.getContext())).enqueue((WorkRequest)mywork);
        }

        @Override
        public void onFailure(int errorCode) {
        }
    };

    public WarpView(Context context) {
        this(context, null);
    }

    public WarpView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public WarpView(Context context, Activity activity, boolean isActivity) {
        super(context, null);
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this);
        this.WarpActivity = activity;
        mWebviewLoaded = false;
        this.init();
    }

    public WarpView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void init() {
        this.setOverScrollMode(2);
        this.setFadingEdgeLength(0);
        WebSettings settings = this.getSettings();
        settings.setCacheMode(1);
        settings.setJavaScriptEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationDatabasePath(this.getContext().getCacheDir().getAbsolutePath());
        settings.setGeolocationEnabled(true);
        settings.setBuiltInZoomControls(false);
        settings.setAllowContentAccess(true);
        settings.setLoadWithOverviewMode(true);
        settings.setAllowFileAccess(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setAllowFileAccessFromFileURLs(true);
        settings.setAllowUniversalAccessFromFileURLs(true);
        settings.setSupportMultipleWindows(true);
        this.addJavascriptInterface(new JSInterface(), "Cosmote");
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)17170445));
        this.setWebViewClient(new WarplyWebViewClient());
        this.setWebChromeClient(new WarplyWebChromeClient());
        this.initCustomActionHandler();
    }

    private boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)this.getContext().getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    private void initCustomActionHandler() {
        String actionHandlerName = WarplyProperty.getWebActionListenerClassName(this.getContext());
        if (TextUtils.isEmpty((CharSequence)actionHandlerName)) {
            return;
        }
        if (actionHandlerName.startsWith(".")) {
            actionHandlerName = this.getContext().getPackageName().concat(actionHandlerName);
        }
        try {
            Class<?> cls = Class.forName(actionHandlerName);
            this.mExternalUrlHandler = (WarplyUrlHandler)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            WarpUtils.warn("Warply action handler class was not found", e);
        }
        catch (ClassCastException e) {
            WarpUtils.warn("Warply action handler does not implement the correct interface", e);
        }
        catch (InstantiationException e) {
            WarpUtils.warn("Warply action handler could not be instantiated, maybe missing default constructor", e);
        }
        catch (IllegalAccessException e) {
            WarpUtils.warn("Warply action handler could not be accessed", e);
        }
    }

    private void actionTel(Uri uri) {
        block5: {
            try {
                this.getContext().startActivity(new Intent("android.intent.action.DIAL").setData(uri));
                try {
                    JSONObject metadata = new JSONObject();
                    metadata.putOpt("session_uuid", (Object)this.sessionUUID);
                    JSONArray results = new JSONArray("[\"call_clicked\"]");
                    metadata.putOpt("result", (Object)results);
                    WarplyAnalyticsManager.logUrgentEvent("TEL", "NB_CUSTOM_ACTION", metadata);
                }
                catch (JSONException e) {
                    if (WarpConstants.DEBUG) {
                        e.printStackTrace();
                    }
                }
            }
            catch (ActivityNotFoundException e) {
                if (!WarpConstants.DEBUG) break block5;
                e.printStackTrace();
            }
        }
    }

    private void actionRSMS(Uri uri) {
        WarpUtils.log(uri.toString());
    }

    private void actionSMS(Uri uri) {
        block6: {
            String body;
            String host = uri.getHost();
            if (host == null) {
                host = "";
            }
            if ((body = this.splitQuery(uri).get("body")) == null) {
                body = "";
            }
            try {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)("sms:" + host)));
                i.putExtra("sms_body", body);
                this.getContext().startActivity(i);
                try {
                    JSONObject metadata = new JSONObject();
                    metadata.putOpt("session_uuid", (Object)this.sessionUUID);
                    JSONArray results = new JSONArray("[\"sms_prompt_clicked\"]");
                    metadata.putOpt("result", (Object)results);
                    WarpUtils.log(metadata.toString());
                    WarplyAnalyticsManager.logUrgentEvent("SMS", "NB_CUSTOM_ACTION", metadata);
                }
                catch (JSONException e) {
                    WarpUtils.log(e.toString());
                }
            }
            catch (ActivityNotFoundException e) {
                if (!WarpConstants.DEBUG) break block6;
                e.printStackTrace();
            }
        }
    }

    private void actionMail(Uri uri) {
        block6: {
            String body;
            Map<String, String> params = this.splitQuery(uri);
            String subject = params.get("subject");
            if (subject == null) {
                subject = "";
            }
            if ((body = params.get("body")) == null) {
                body = "";
            }
            try {
                Intent i = new Intent("android.intent.action.SEND");
                i.putExtra("android.intent.extra.SUBJECT", subject);
                i.putExtra("android.intent.extra.TEXT", body);
                i.setData(Uri.parse((String)"mailto:"));
                i.setType("text/plain");
                this.getContext().startActivity(i);
                try {
                    JSONObject metadata = new JSONObject();
                    metadata.putOpt("session_uuid", (Object)this.sessionUUID);
                    JSONArray results = new JSONArray("[\"mailto_prompt_clicked\"]");
                    metadata.putOpt("result", (Object)results);
                    WarpUtils.log(metadata.toString());
                    WarplyAnalyticsManager.logUrgentEvent("MAIL_TO", "NB_CUSTOM_ACTION", metadata);
                }
                catch (JSONException e) {
                    WarpUtils.log(e.toString());
                }
            }
            catch (ActivityNotFoundException e) {
                if (!WarpConstants.DEBUG) break block6;
                e.printStackTrace();
            }
        }
    }

    private void actionMarket(Uri uri) {
        block5: {
            try {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(uri);
                this.getContext().startActivity(i);
                try {
                    JSONObject metadata = new JSONObject();
                    JSONArray results = new JSONArray("[\"PLAYSTORE\"]");
                    metadata.putOpt("result", (Object)results);
                    metadata.putOpt("session_uuid", (Object)this.sessionUUID);
                    metadata.putOpt("url", (Object)uri.toString());
                    WarplyAnalyticsManager.logUrgentEvent("APP_DOWNLOAD", "NB_CUSTOM_ACTION", metadata);
                }
                catch (JSONException e) {
                    if (WarpConstants.DEBUG) {
                        e.printStackTrace();
                    }
                }
            }
            catch (ActivityNotFoundException e) {
                if (!WarpConstants.DEBUG) break block5;
                e.printStackTrace();
            }
        }
    }

    private Map<String, String> splitQuery(Uri uri) {
        String[] pairs;
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        for (String pair : pairs = query.split("&")) {
            int idx;
            if (TextUtils.isEmpty((CharSequence)pair) || (idx = pair.indexOf("=")) == -1) continue;
            try {
                queryPairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                if (!WarpConstants.DEBUG) continue;
                e.printStackTrace();
            }
        }
        return queryPairs;
    }

    public void setProgressChangeListener(ProgressChangeListener listener) {
        this.mProgressListener = listener;
    }

    public void setWarplyUrlHandler(WarplyUrlHandler handler) {
        this.mInternalUrlHandler = handler;
    }

    public void loadWarpSessionUUID(String sessionUUID) {
        if (!TextUtils.isEmpty((CharSequence)sessionUUID)) {
            this.sessionUUID = sessionUUID;
            this.loadWarpUrl(WarplyProperty.getBaseUrl(this.getContext()) + "/api/session/" + sessionUUID);
        }
    }

    public void loadWarpUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            WarpUtils.log("URL Loading: " + url);
            WarpUtils.log("Header: loyalty-web-id:" + WarpUtils.getWebId(this.getContext()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("loyalty-web-id", WarpUtils.getWebId(this.getContext()));
            this.loadUrl(url, headers);
        }
    }

    public String getLastSessionUUID() {
        return this.sessionUUID;
    }

    public void onStart(@NonNull LifecycleOwner owner) {
        super.onStart(owner);
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void onStop(@NonNull LifecycleOwner owner) {
        super.onStop(owner);
    }

    @Subscribe
    public void onMessageEvent(WarplyEventBusManager event) {
        if (event.getWarplyWebviewCallbackEventModel() != null) {
            if (event.getWarplyWebviewCallbackEventModel().getRequestId() == 3001 && event.getWarplyWebviewCallbackEventModel().getResponseCode().equals("allow")) {
                this.enableLocationSettings();
            } else {
                this.geolocationCallback.invoke(this.geolocationOrigin, false, false);
            }
            return;
        }
        if (event.getWarplyWebviewActivityCallbackEventModel() != null) {
            if (event.getWarplyWebviewActivityCallbackEventModel().getRequestId() == 3002 && event.getWarplyWebviewActivityCallbackEventModel().getResponseCode().equals("enabled")) {
                this.geolocationCallback.invoke(this.geolocationOrigin, true, false);
            } else {
                this.geolocationCallback.invoke(this.geolocationOrigin, false, false);
            }
        }
    }

    private void checkForPermissions(String origin, GeolocationPermissions.Callback callback) {
        String perm = "android.permission.ACCESS_FINE_LOCATION";
        if (Build.VERSION.SDK_INT < 23 || this.getContext().checkSelfPermission(perm) == 0) {
            this.geolocationCallback = callback;
            if (this.isGPSEnabled()) {
                callback.invoke(origin, true, false);
            } else {
                this.enableLocationSettings();
            }
        } else if (this.WarpActivity != null && !this.WarpActivity.isFinishing() && !ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.WarpActivity, (String)perm)) {
            ActivityCompat.requestPermissions((Activity)this.WarpActivity, (String[])new String[]{perm}, (int)3001);
            this.geolocationOrigin = origin;
            this.geolocationCallback = callback;
        }
    }

    private void enableLocationSettings() {
        if (this.geolocationCallback == null) {
            return;
        }
        GoogleApiClient googleApiClient = new GoogleApiClient.Builder((Context)this.WarpActivity).addApi(LocationServices.API).build();
        googleApiClient.connect();
        LocationRequest locationRequest = LocationRequest.create();
        locationRequest.setPriority(100);
        locationRequest.setInterval(30000L);
        locationRequest.setFastestInterval(5000L);
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest);
        builder.setAlwaysShow(true);
        PendingResult result = LocationServices.SettingsApi.checkLocationSettings(googleApiClient, builder.build());
        result.setResultCallback(result1 -> {
            Status status = result1.getStatus();
            switch (status.getStatusCode()) {
                case 0: {
                    this.geolocationCallback.invoke(this.geolocationOrigin, true, false);
                    break;
                }
                case 6: {
                    try {
                        status.startResolutionForResult(this.WarpActivity, 3002);
                    }
                    catch (IntentSender.SendIntentException ignored) {
                        this.geolocationCallback.invoke(this.geolocationOrigin, true, false);
                    }
                    break;
                }
                case 8502: {
                    this.geolocationCallback.invoke(this.geolocationOrigin, true, false);
                }
            }
        });
    }

    private boolean isGPSEnabled() {
        LocationManager lm = (LocationManager)this.getContext().getSystemService("location");
        try {
            boolean gpsEnabled = lm.isProviderEnabled("gps");
            return gpsEnabled;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static interface ProgressChangeListener {
        public void onProgressChanged(WebView var1, int var2);
    }

    public class JSInterface {
        @JavascriptInterface
        public void sendMessage(String message) {
            if (message.contains("event")) {
                String[] parts = message.split(":");
                if (parts[1].equals("webviewRefresh")) {
                    WarpViewActivity.setWebviewSupermarket(true);
                } else if (parts[1].equals("closeArtwork")) {
                    WarpViewActivity.setWebviewSupermarket(false);
                    QuestionnaireEventModel questionnaireEvent = new QuestionnaireEventModel();
                    questionnaireEvent.setName(parts[1]);
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(questionnaireEvent));
                } else if (parts[1].equals("userAnswered")) {
                    try {
                        WarpUtils.setUserTag(Warply.getWarplyContext(), parts[2]);
                    }
                    catch (IndexOutOfBoundsException e) {
                        WarpUtils.setUserTag(Warply.getWarplyContext(), "");
                    }
                } else if (parts[1].equals("addUserTag")) {
                    QuestionnaireEventModel questionnaireEvent = new QuestionnaireEventModel();
                    try {
                        questionnaireEvent.setName(parts[1]);
                        questionnaireEvent.setParameter(parts[2]);
                        WarpUtils.setUserTag(Warply.getWarplyContext(), parts[2]);
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(questionnaireEvent));
                    }
                    catch (IndexOutOfBoundsException e) {
                        questionnaireEvent.setName(parts[1]);
                        questionnaireEvent.setParameter("");
                        WarpUtils.setUserTag(Warply.getWarplyContext(), "");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(questionnaireEvent));
                    }
                } else if (parts[1].equals("couponRetrieved")) {
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(new CouponEventModel()));
                } else if (parts[1].equals("loyaltyWallet")) {
                    WarplyManager.getUnifiedCouponsDeals(WarpView.this.mUnifiedCallback);
                    RefreshVouchersEventModel vouchersRefreshed = new RefreshVouchersEventModel();
                    vouchersRefreshed.setRefreshed(true);
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(vouchersRefreshed));
                } else if (parts[1].equals("activeCoupons")) {
                    WarplyManager.getUserCouponsWithCouponsets(WarpView.this.mUserCouponsReceiver);
                    WarplyManager.getCampaigns(WarpView.this.mCampaignsCallback);
                    Handler handlerIntent = new Handler();
                    Runnable runnableIntent = new Runnable(){

                        @Override
                        public void run() {
                            Intent intent = new Intent((Context)(WarpView.this.WarpActivity != null && !WarpView.this.WarpActivity.isFinishing() ? WarpView.this.WarpActivity : WarpView.this.getContext()), ActiveCouponsActivity.class);
                            WarpView.this.getContext().startActivity(intent);
                        }
                    };
                    handlerIntent.postDelayed(runnableIntent, 1500L);
                } else if (parts[1].equals("ccmsRetrieved")) {
                    WarplyCCMSEnabledModel ccmsEnabled = new WarplyCCMSEnabledModel();
                    ccmsEnabled.setActivated(true);
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(ccmsEnabled));
                } else if (parts[1].equals("steps") && parts[2].equals("widgetDisabled")) {
                    WarplyPacingCardEventModel pacingWidgetVisible = new WarplyPacingCardEventModel();
                    pacingWidgetVisible.setVisible(false);
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(pacingWidgetVisible));
                } else if (parts[1].equals("steps") && parts[2].equals("widgetEnabled")) {
                    WarplyPacingCardEventModel pacingWidgetVisible = new WarplyPacingCardEventModel();
                    pacingWidgetVisible.setVisible(true);
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(pacingWidgetVisible));
                } else if (!(parts[1].equals("steps") && parts[2].equals("shortcutEnabled") || parts[1].equals("steps") && parts[2].equals("shortcutDisabled"))) {
                    if (parts[1].equals("request") || parts[1].equals("response")) {
                        WarpUtils.log("**************** WARPLY Webview Log START *****************");
                        WarpUtils.log(message);
                        WarpUtils.log("**************** WARPLY Webview Log END *****************");
                    } else if (parts[1].equals("loyalty_questionnaire_selected")) {
                        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                        analyticsEvent.setEventName(parts[1]);
                        analyticsEvent.setParameter("completed", "true");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                    } else if (parts[1].equals("loyalty_questionnaire_answer_again") || parts[1].equals("loyalty_questionnaire_answers_deleted")) {
                        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                        analyticsEvent.setEventName(parts[1]);
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                    } else if (parts[1].equals("loyalty_questionnaire_later")) {
                        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                        analyticsEvent.setEventName("loyalty_questionnaire_selected");
                        analyticsEvent.setParameter("completed", "false");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                    } else if (parts[1].equals("loyalty_sdk_offer_selected")) {
                        try {
                            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                            analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                            analyticsEvent.setParameter("name", parts[2]);
                            analyticsEvent.setParameter("type", parts[3]);
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (parts[1].equals("loyalty_offer_activated")) {
                        try {
                            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                            analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                            analyticsEvent.setParameter("name", parts[2]);
                            analyticsEvent.setParameter("type", parts[3]);
                            analyticsEvent.setParameter("successful", parts[4]);
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (parts[1].equals("unified_coupon_activated")) {
                        WarplyUnifiedActivatedEventModel unifiedActivated = new WarplyUnifiedActivatedEventModel();
                        unifiedActivated.setActivated(true);
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(unifiedActivated));
                        try {
                            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                            analyticsEvent.setEventName("loyalty_sdk_unified_activated");
                            analyticsEvent.setParameter("name", parts[2]);
                            analyticsEvent.setParameter("type", parts[3]);
                            analyticsEvent.setParameter("successful", parts[4]);
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (parts[1].equals("time_spent_on_loyalty_sdk")) {
                        try {
                            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                            analyticsEvent.setEventName("time_spent_on_loyalty_sdk");
                            analyticsEvent.setParameter("name", parts[2]);
                            analyticsEvent.setParameter("seconds", parts[3]);
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (parts[1].equals("refreshToken")) {
                        try {
                            if (Warply.getWarplyContext() != null) {
                                WarplyDBHelper.getInstance(Warply.getWarplyContext()).saveAuthAccess(parts[2], parts[3]);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (parts[1].equals("cancel_unified_success")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_cancel_unified_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        RefreshUnifiedCouponsEventModel couponsRefreshed = new RefreshUnifiedCouponsEventModel();
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(couponsRefreshed));
                    } else if (parts[1].equals("cancel_unified_failed")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_cancel_unified_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    } else if (parts[1].equals("create_unified_success")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_create_unified_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                        RefreshUnifiedCouponsEventModel couponsRefreshed = new RefreshUnifiedCouponsEventModel();
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(couponsRefreshed));
                    } else if (parts[1].equals("create_unified_failed")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_create_unified_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    } else if (parts[1].equals("get_unified_success")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_success_unified_coupons_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    } else if (parts[1].equals("get_unified_failed")) {
                        LoyaltySDKDynatraceEventModel dynatraceEvent = new LoyaltySDKDynatraceEventModel();
                        dynatraceEvent.setEventName("custom_error_unified_coupons_loyalty");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(dynatraceEvent));
                    }
                }
            }
        }
    }

    private class WarplyWebViewClient
    extends WebViewClient {
        private WarplyWebViewClient() {
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            WarpUtils.log("Error " + errorCode + " loading url " + failingUrl);
            WarpUtils.log("Error description " + description);
            if (Build.VERSION.SDK_INT >= 18) {
                WarpView.this.loadUrl("about:blank");
            } else {
                WarpView.this.clearView();
            }
            Toast.makeText((Context)WarpView.this.getContext(), (CharSequence)description, (int)0).show();
        }

        public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
            if (WarpView.this.WarpActivity != null && !WarpView.this.WarpActivity.isFinishing()) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)WarpView.this.WarpActivity);
                builder.setTitle((CharSequence)"\u0395\u03b9\u03b4\u03bf\u03c0\u03bf\u03af\u03b7\u03c3\u03b7");
                builder.setMessage((CharSequence)"\u0398\u03b1 \u03b1\u03bd\u03b1\u03ba\u03b1\u03c4\u03b5\u03c5\u03b8\u03c5\u03bd\u03b8\u03b5\u03af\u03c2 \u03c3\u03b5 \u03c3\u03b5\u03bb\u03af\u03b4\u03b1 \u03c7\u03c9\u03c1\u03af\u03c2 \u03ad\u03b3\u03ba\u03c5\u03c1\u03bf \u03c0\u03b9\u03c3\u03c4\u03bf\u03c0\u03bf\u03b9\u03b7\u03c4\u03b9\u03ba\u03cc");
                builder.setPositiveButton((CharSequence)"\u03a3\u03c5\u03bc\u03c6\u03c9\u03bd\u03ce", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        handler.proceed();
                    }
                });
                builder.setNegativeButton((CharSequence)"\u0386\u03ba\u03c5\u03c1\u03bf", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        handler.cancel();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        }

        public void onPageFinished(WebView view, String url) {
            mWebviewLoaded = true;
            String scriptSource = "passParams(" + WarpUtils.getWebviewParams(WarpView.this.getContext()) + ");";
            view.evaluateJavascript(scriptSource, s -> {});
            WarpViewActivity.getMetersHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    String tempMeters = String.valueOf(WarplyManagerHelper.mMetersWebview);
                    String scriptSourceMeters = "passMeters(" + tempMeters + ");";
                    WarpView.this.evaluateJavascript(scriptSourceMeters, s -> {});
                    WarplyManagerHelper.mStepsWebview = 0;
                    WarplyManagerHelper.mMetersWebview = 0.0;
                    WarpViewActivity.getMetersHandler().postDelayed((Runnable)this, 300L);
                }
            }, 3000L);
            if (url.contains("about:blank")) {
                WarpView.this.clearHistory();
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String strUrl) {
            if (WarpView.this.mExternalUrlHandler != null && WarpView.this.mExternalUrlHandler.canHandleUrl(strUrl)) {
                WarpView.this.mExternalUrlHandler.handleUrl(WarpView.this.getContext(), strUrl);
                return true;
            }
            if (WarpView.this.mInternalUrlHandler != null && WarpView.this.mInternalUrlHandler.canHandleUrl(strUrl)) {
                WarpView.this.mInternalUrlHandler.handleUrl(WarpView.this.getContext(), strUrl);
                return true;
            }
            Uri uri = Uri.parse((String)strUrl);
            String scheme = uri.getScheme();
            String authority = uri.getAuthority();
            if (scheme == null) {
                return false;
            }
            if (scheme.equalsIgnoreCase(WarpView.URL_ACTION_TEL)) {
                WarpView.this.actionTel(uri);
                return true;
            }
            if (scheme.equalsIgnoreCase(WarpView.URL_ACTION_RSMS)) {
                WarpView.this.actionRSMS(uri);
                return true;
            }
            if (scheme.equalsIgnoreCase(WarpView.URL_ACTION_SMS)) {
                WarpView.this.actionSMS(uri);
                return true;
            }
            if (scheme.equalsIgnoreCase(WarpView.URL_ACTION_MAIL)) {
                WarpView.this.actionMail(uri);
                return true;
            }
            if (scheme.equals(WarpView.URL_ACTION_MARKET)) {
                WarpView.this.actionMarket(uri);
                return true;
            }
            if (authority != null && authority.equalsIgnoreCase(WarpView.URL_ACTION_MARKET_AUTHORITY)) {
                WarpView.this.actionMarket(uri);
                return true;
            }
            if (scheme.equals(WarplyProperty.getDlUrlScheme(Warply.getWarplyContext()))) {
                Uri webpage = Uri.parse((String)strUrl);
                Intent intent = new Intent("android.intent.action.VIEW", webpage);
                WarpView.this.getContext().startActivity(intent);
                return true;
            }
            if (scheme.equalsIgnoreCase(WarpView.URL_ACTION_INTENT)) {
                try {
                    Intent intent = Intent.parseUri((String)strUrl, (int)1);
                    String data = intent.getData().toString();
                    if (!TextUtils.isEmpty((CharSequence)data)) {
                        Uri webpage = Uri.parse((String)data);
                        Intent intentWebpage = new Intent("android.intent.action.VIEW", webpage);
                        WarpView.this.getContext().startActivity(intentWebpage);
                        return true;
                    }
                }
                catch (URISyntaxException e) {
                    return true;
                }
            }
            return false;
        }
    }

    private class WarplyWebChromeClient
    extends WebChromeClient {
        private WarplyWebChromeClient() {
        }

        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            AlertDialog.Builder builder = new AlertDialog.Builder(WarpView.this.getContext());
            builder.setTitle((CharSequence)WarpView.this.getContext().getString(R.string.lbl_cosmote_webview_permission_title));
            builder.setMessage((CharSequence)WarpView.this.getContext().getString(R.string.lbl_cosmote_webview_permission_message)).setCancelable(false).setPositiveButton((CharSequence)WarpView.this.getContext().getString(R.string.lbl_take_photo_accept), (dialog, id2) -> WarpView.this.checkForPermissions(origin, callback)).setNegativeButton((CharSequence)WarpView.this.getContext().getString(R.string.lbl_take_photo_decline), (dialog, id2) -> callback.invoke(origin, false, false));
            AlertDialog alert = builder.create();
            alert.show();
        }

        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            if (WarpView.this.mProgressListener != null) {
                WarpView.this.mProgressListener.onProgressChanged(view, newProgress);
            }
        }
    }
}

