/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Build;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.Merchant;
import ly.warp.sdk.utils.WarplyManagerHelper;

public class ActiveCouponAdapter
extends RecyclerView.Adapter<ActiveCouponViewHolder> {
    private Context mContext;
    private CouponList mCoupons;
    private final PublishSubject<Coupon> onClickSubject = PublishSubject.create();
    private boolean mIsPast = false;
    private boolean mIsCustom = false;

    public ActiveCouponAdapter(Context mContext, CouponList campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.mIsPast = false;
    }

    public ActiveCouponAdapter(Context mContext, CouponList campaignList, boolean past) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.mIsPast = past;
    }

    public ActiveCouponAdapter(Context mContext, CouponList campaignList, boolean past, boolean custom) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.mIsPast = past;
        this.mIsCustom = custom;
    }

    public int getItemCount() {
        if (this.mCoupons == null) {
            return 0;
        }
        return this.mCoupons.size();
    }

    public Coupon getItem(int id2) {
        return (Coupon)this.mCoupons.get(id2);
    }

    public void updateData(CouponList couponList) {
        this.mCoupons.clear();
        this.mCoupons.addAll(couponList);
        this.notifyDataSetChanged();
    }

    public ActiveCouponViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = this.mIsPast ? LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.past_coupon_layout, parent, false) : (this.mIsCustom ? LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.custom_coupon_layout, parent, false) : LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.active_coupon_layout, parent, false));
        return new ActiveCouponViewHolder(itemView);
    }

    public void onBindViewHolder(ActiveCouponViewHolder holder, int position) {
        Coupon couponItem = (Coupon)this.mCoupons.get(position);
        Merchant merchant = new Merchant();
        if (this.mIsPast) {
            holder.ivCouponBackground.setColorFilter(ContextCompat.getColor((Context)this.mContext, (int)R.color.grey_light3), PorterDuff.Mode.MULTIPLY);
        }
        if (couponItem != null) {
            if (this.mIsCustom) {
                if (WarplyManagerHelper.getMerchantList() != null && WarplyManagerHelper.getMerchantList().size() > 0) {
                    for (Merchant mer : WarplyManagerHelper.getMerchantList()) {
                        if (!mer.getUuid().equals(couponItem.getMerchantUuid())) continue;
                        merchant = mer;
                        break;
                    }
                }
                if (couponItem.getStatus() == 1) {
                    holder.ivCouponLogo.setAlpha(1.0f);
                    holder.tvCouponTitle.setAlpha(1.0f);
                    holder.tvCouponValue.setAlpha(1.0f);
                    holder.tvCouponDescription.setAlpha(1.0f);
                    holder.clCustomLayout.setBackgroundResource(R.drawable.ic_coupon_background_new2);
                } else {
                    holder.ivCouponLogo.setAlpha(0.29f);
                    holder.tvCouponTitle.setAlpha(0.29f);
                    holder.tvCouponValue.setAlpha(0.29f);
                    holder.tvCouponDescription.setAlpha(0.29f);
                    holder.clCustomLayout.setBackgroundResource(R.drawable.ic_coupon_background_new2);
                }
                if (merchant != null && !TextUtils.isEmpty((CharSequence)merchant.getImgPreview())) {
                    ((RequestBuilder)Glide.with((Context)this.mContext).load(merchant.getImgPreview()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCouponLogo);
                } else {
                    Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivCouponLogo);
                }
                holder.tvCouponTitle.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)merchant.getAdminName()) ? merchant.getAdminName() : couponItem.getName()));
                if (Build.VERSION.SDK_INT >= 24) {
                    holder.tvCouponDescription.setText((CharSequence)Html.fromHtml((String)(couponItem.getInnerText().equals("null") || TextUtils.isEmpty((CharSequence)couponItem.getInnerText()) ? "" : couponItem.getInnerText()), (int)63));
                } else {
                    holder.tvCouponDescription.setText((CharSequence)Html.fromHtml((String)(couponItem.getInnerText().equals("null") || TextUtils.isEmpty((CharSequence)couponItem.getInnerText()) ? "" : couponItem.getInnerText())));
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                Date newDate = new Date();
                try {
                    newDate = simpleDateFormat.parse(couponItem.getExpiration());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                if (this.mIsPast) {
                    holder.tvCouponDate.setText((CharSequence)String.format(this.mContext.getString(R.string.cos_coupon_expired_date), simpleDateFormat.format(newDate != null ? newDate : "")));
                } else {
                    long days = this.getDaysBetweenDates(simpleDateFormat.format(new Date()), simpleDateFormat.format(newDate != null ? newDate : ""));
                    holder.tvCouponDate.setText((CharSequence)String.format(this.mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
                    if (couponItem.getStatus() == 1) {
                        if (days < 15L) {
                            holder.tvCouponDate.setText((CharSequence)"");
                            holder.tvCouponDate.setVisibility(0);
                            holder.tvCouponDateExpired.setVisibility(8);
                            holder.tvDateLimit.setText((CharSequence)String.format(this.mContext.getString(R.string.cos_coupon_date_limit2), simpleDateFormat.format(newDate != null ? newDate : "")));
                            holder.lLDateLimit.setVisibility(0);
                        } else {
                            holder.tvCouponDate.setVisibility(0);
                            holder.tvCouponDateExpired.setVisibility(8);
                            holder.tvCouponDate.setText((CharSequence)String.format(this.mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
                        }
                    } else {
                        holder.tvCouponDate.setVisibility(8);
                        holder.tvCouponDateExpired.setVisibility(0);
                        holder.tvCouponDateExpired.setText((CharSequence)this.mContext.getString(R.string.cos_market_coupon_expired));
                    }
                }
                if (TextUtils.isEmpty((CharSequence)couponItem.getDiscount_type())) {
                    holder.tvCouponValue.setText((CharSequence)(couponItem.getDiscount().replace(".", ",") + this.mContext.getResources().getString(R.string.euro)));
                } else if (couponItem.getDiscount_type().equals("value")) {
                    holder.tvCouponValue.setText((CharSequence)(couponItem.getDiscount().replace(".", ",") + this.mContext.getResources().getString(R.string.euro)));
                } else if (couponItem.getDiscount_type().equals("percentage")) {
                    holder.tvCouponValue.setText((CharSequence)(couponItem.getDiscount() + this.mContext.getResources().getString(R.string.percentage)));
                } else if (couponItem.getDiscount_type().equals("plus_one")) {
                    holder.tvCouponValue.setText((CharSequence)(couponItem.getDiscount() + this.mContext.getResources().getString(R.string.plus_one)));
                } else {
                    holder.tvCouponValue.setText((CharSequence)(couponItem.getDiscount().replace(".", ",") + this.mContext.getResources().getString(R.string.euro)));
                }
                holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)couponItem));
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)couponItem.getMerchantDetails().getImgPreview())) {
                ((RequestBuilder)Glide.with((Context)this.mContext).load(couponItem.getMerchantDetails().getImgPreview()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCouponLogo);
            } else if (!TextUtils.isEmpty((CharSequence)couponItem.getCouponsetDetails().getImgPreview())) {
                ((RequestBuilder)Glide.with((Context)this.mContext).load(couponItem.getCouponsetDetails().getImgPreview()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCouponLogo);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivCouponLogo);
            }
            if (!TextUtils.isEmpty((CharSequence)couponItem.getMerchantDetails().getAdminName())) {
                holder.tvCouponTitle.setText((CharSequence)couponItem.getMerchantDetails().getAdminName());
            } else {
                holder.tvCouponTitle.setText((CharSequence)couponItem.getCouponsetDetails().getName());
            }
            if (!this.mIsPast) {
                if (Build.VERSION.SDK_INT >= 24) {
                    holder.tvCouponDescription.setText((CharSequence)Html.fromHtml((String)couponItem.getCouponsetDetails().getInnerText(), (int)63));
                } else {
                    holder.tvCouponDescription.setText((CharSequence)Html.fromHtml((String)couponItem.getCouponsetDetails().getInnerText()));
                }
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date newDate = new Date();
            try {
                newDate = simpleDateFormat.parse(couponItem.getExpiration());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            if (this.mIsPast) {
                holder.tvCouponDate.setText((CharSequence)String.format(this.mContext.getString(R.string.cos_coupon_expired_date), simpleDateFormat.format(newDate != null ? newDate : "")));
            } else {
                holder.tvCouponDate.setText((CharSequence)String.format(this.mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
            }
            if (TextUtils.isEmpty((CharSequence)couponItem.getCouponsetDetails().getDiscount_type())) {
                holder.tvCouponValue.setText((CharSequence)(couponItem.getCouponsetDetails().getDiscount() + this.mContext.getResources().getString(R.string.euro)));
            } else if (couponItem.getCouponsetDetails().getDiscount_type().equals("value")) {
                holder.tvCouponValue.setText((CharSequence)(couponItem.getCouponsetDetails().getDiscount() + this.mContext.getResources().getString(R.string.euro)));
            } else if (couponItem.getCouponsetDetails().getDiscount_type().equals("percentage")) {
                holder.tvCouponValue.setText((CharSequence)(couponItem.getCouponsetDetails().getDiscount() + this.mContext.getResources().getString(R.string.percentage)));
            } else if (couponItem.getCouponsetDetails().getDiscount_type().equals("plus_one")) {
                holder.tvCouponValue.setText((CharSequence)(couponItem.getCouponsetDetails().getDiscount() + this.mContext.getResources().getString(R.string.plus_one)));
            } else {
                holder.tvCouponValue.setText((CharSequence)(couponItem.getCouponsetDetails().getDiscount() + this.mContext.getResources().getString(R.string.euro)));
            }
            holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)couponItem));
        }
    }

    private long getDaysBetweenDates(String start, String end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        long numberOfDays = 0L;
        try {
            Date startDate = dateFormat.parse(start);
            Date endDate = dateFormat.parse(end);
            numberOfDays = this.getUnitBetweenDates(startDate, endDate, TimeUnit.DAYS);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return numberOfDays;
    }

    private long getUnitBetweenDates(Date startDate, Date endDate, TimeUnit unit) {
        long timeDiff = endDate.getTime() - startDate.getTime();
        return unit.convert(timeDiff, TimeUnit.MILLISECONDS);
    }

    public Observable<Coupon> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    public class ActiveCouponViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivCouponLogo;
        private ImageView ivCouponBackground;
        private TextView tvCouponTitle;
        private TextView tvCouponValue;
        private TextView tvCouponDate;
        private TextView tvDateLimit;
        private TextView tvCouponDescription;
        private TextView tvCouponDateExpired;
        private ConstraintLayout clCustomLayout;
        private LinearLayout lLDateLimit;

        public ActiveCouponViewHolder(View view) {
            super(view);
            this.ivCouponBackground = (ImageView)view.findViewById(R.id.iv_past_coupon_background);
            this.ivCouponLogo = (ImageView)view.findViewById(R.id.iv_active_coupon);
            this.tvCouponTitle = (TextView)view.findViewById(R.id.tv_active_coupons_title);
            this.tvCouponValue = (TextView)view.findViewById(R.id.tv_active_coupons_value);
            this.tvCouponDate = (TextView)view.findViewById(R.id.tv_active_coupons_date);
            this.tvCouponDescription = (TextView)view.findViewById(R.id.tv_active_coupons_description);
            this.clCustomLayout = (ConstraintLayout)view.findViewById(R.id.cl_custom_layout);
            this.tvCouponDateExpired = (TextView)view.findViewById(R.id.tv_active_coupons_date_expired);
            this.tvDateLimit = (TextView)view.findViewById(R.id.tv_active_coupons_date_limit);
            this.lLDateLimit = (LinearLayout)view.findViewById(R.id.ll_date_limit);
        }
    }
}

