/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;

public class ActiveRewardAdapter
extends RecyclerView.Adapter<ActiveRewardViewHolder> {
    private Context mContext;
    private CouponList mRewards;
    private final PublishSubject<Coupon> onClickSubject = PublishSubject.create();

    public ActiveRewardAdapter(Context mContext, CouponList campaignList) {
        this.mContext = mContext;
        this.mRewards = campaignList;
    }

    public int getItemCount() {
        if (this.mRewards == null) {
            return 0;
        }
        return this.mRewards.size();
    }

    public Coupon getItem(int id2) {
        return (Coupon)this.mRewards.get(id2);
    }

    public void updateData(CouponList couponList) {
        this.mRewards.clear();
        this.mRewards.addAll(couponList);
        this.notifyDataSetChanged();
    }

    public ActiveRewardViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.active_rewards_layout, parent, false);
        return new ActiveRewardViewHolder(itemView);
    }

    public void onBindViewHolder(ActiveRewardViewHolder holder, int position) {
        Coupon couponItem = (Coupon)this.mRewards.get(position);
        if (couponItem != null) {
            if (!TextUtils.isEmpty((CharSequence)couponItem.getImage())) {
                ((RequestBuilder)Glide.with((Context)this.mContext).load(couponItem.getImage()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivRewardLogo);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivRewardLogo);
            }
            holder.tvRewardTitle.setText((CharSequence)couponItem.getName());
            holder.tvRewardDescription.setText((CharSequence)couponItem.getDescription());
            holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)couponItem));
        }
    }

    public Observable<Coupon> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    public class ActiveRewardViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivRewardLogo;
        private TextView tvRewardTitle;
        private TextView tvRewardDescription;

        public ActiveRewardViewHolder(View view) {
            super(view);
            this.ivRewardLogo = (ImageView)view.findViewById(R.id.iv_active_reward);
            this.tvRewardTitle = (TextView)view.findViewById(R.id.tv_active_reward_title);
            this.tvRewardDescription = (TextView)view.findViewById(R.id.tv_active_reward_description);
        }
    }
}

