/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import ly.warp.sdk.Warply;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.callbacks.SimpleCallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.request.WarplyInboxRequest;
import ly.warp.sdk.views.CampaignItemViewHolder;
import ly.warp.sdk.views.CampaignItemWebHolder;

public class CampaignsArrayAdapter<VH extends CampaignItemViewHolder>
extends BaseAdapter
implements CallbackReceiver<CampaignList> {
    private Class<VH> mViewHolderClass;
    private CampaignList mCampaigns;
    private WarplyInboxRequest mCampaignsRequest;
    private AtomicBoolean isRequestComplete = new AtomicBoolean(true);
    private static Handler mHandler = new Handler();
    private SimpleCallbackReceiver<CampaignList> mExternalListener;
    private int mWebItemWidth = 0;
    private int mWebItemHeight = 0;
    private Runnable mUpdateItemsRunnable = new Runnable(){

        @Override
        public void run() {
            CampaignsArrayAdapter.this.notifyDataSetChanged();
            CampaignsArrayAdapter.this.isRequestComplete.set(true);
        }
    };

    public CampaignsArrayAdapter(Context context, WarplyInboxRequest campaignsRequest) {
        this(context, campaignsRequest, CampaignItemWebHolder.class);
    }

    public CampaignsArrayAdapter(Context context, WarplyInboxRequest campaignsRequest, int webItemWidth, int webItemHeight) {
        this(context, campaignsRequest);
        this.mWebItemWidth = webItemWidth;
        this.mWebItemHeight = webItemHeight;
    }

    public CampaignsArrayAdapter(Context context, WarplyInboxRequest campaignsRequest, Class<VH> viewHolderClass) {
        Warply.getInitializer(context).init();
        this.mCampaignsRequest = campaignsRequest;
        this.mViewHolderClass = viewHolderClass;
    }

    public int getCount() {
        if (this.mCampaigns == null) {
            return 0;
        }
        return this.mCampaigns.size();
    }

    public Campaign getItem(int position) {
        if (this.mCampaigns == null || position < 0 || position >= this.mCampaigns.size()) {
            return null;
        }
        return (Campaign)this.mCampaigns.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getViewTypeCount() {
        this.requestCampaigns();
        return super.getViewTypeCount();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Campaign item;
        CampaignItemViewHolder viewHolder = null;
        View itemView = convertView;
        if (itemView == null) {
            try {
                viewHolder = this.mViewHolderClass == CampaignItemWebHolder.class ? (CampaignItemViewHolder)((Object)this.mViewHolderClass.getDeclaredConstructor(ViewGroup.class, Integer.TYPE, Integer.TYPE).newInstance(parent, this.mWebItemWidth, this.mWebItemHeight)) : (CampaignItemViewHolder)((Object)this.mViewHolderClass.getDeclaredConstructor(ViewGroup.class).newInstance(parent));
                itemView = viewHolder.itemView;
                itemView.setTag((Object)viewHolder);
            }
            catch (Exception exception) {}
        } else {
            viewHolder = (CampaignItemViewHolder)((Object)itemView.getTag());
        }
        if ((item = this.getItem(position)) != null && viewHolder != null) {
            viewHolder.bindData(item, position);
            itemView = viewHolder.itemView;
        }
        return itemView;
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.getView(position, convertView, parent);
    }

    @Override
    public void onSuccess(CampaignList result) {
        this.mCampaigns = result;
        this.updateAdapter();
        this.notifySuccessExternalListener(result);
    }

    @Override
    public void onFailure(int errorCode) {
        this.clear();
        this.updateAdapter();
        this.notifyFailureExternalListener(errorCode);
    }

    private void requestCampaigns() {
        if (this.isRequestComplete.get() && this.isEmpty()) {
            this.isRequestComplete.set(false);
            Warply.getInbox(this.mCampaignsRequest, this);
        }
    }

    private void updateAdapter() {
        mHandler.removeCallbacks(this.mUpdateItemsRunnable);
        mHandler.post(this.mUpdateItemsRunnable);
    }

    public void clear() {
        if (this.mCampaigns != null) {
            this.mCampaigns.clear();
        }
    }

    private void notifySuccessExternalListener(CampaignList campaigns) {
        if (this.mExternalListener != null) {
            this.mExternalListener.onSuccess(campaigns);
        }
    }

    private void notifyFailureExternalListener(int errorCode) {
        if (this.mExternalListener != null) {
            this.mExternalListener.onFailure(errorCode);
        }
    }

    public CampaignList getItems() {
        return this.mCampaigns;
    }

    public int getCurrentUnreadMessages() {
        return this.getCount() > 0 ? this.mCampaigns.getUnreadCampaignsCount() : 0;
    }

    public void sort(Comparator<Campaign> comparator) {
        if (this.mCampaigns != null && this.mCampaigns.size() > 0) {
            Collections.sort(this.mCampaigns, comparator);
            this.notifyDataSetChanged();
        }
    }

    public void updateCampaigns(WarplyInboxRequest request) {
        this.mCampaignsRequest = request;
        this.clear();
        this.isRequestComplete.set(true);
        this.requestCampaigns();
    }

    public void updateCampaigns(CampaignList result) {
        this.mCampaigns = result;
        this.clear();
        this.updateAdapter();
        this.notifySuccessExternalListener(result);
    }

    public void setCampaignsListener(SimpleCallbackReceiver<CampaignList> listener) {
        this.mExternalListener = listener;
    }
}

