/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.text.HtmlCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.CouponsetsList;

public class CouponsetsAdapter
extends RecyclerView.Adapter<CouponsetViewHolder> {
    private Context mContext;
    private CouponsetsList mCouponsets;
    private final PublishSubject<Couponset> onClickSubject = PublishSubject.create();

    public CouponsetsAdapter(Context mContext, CouponsetsList couponsets) {
        this.mContext = mContext;
        this.mCouponsets = couponsets;
    }

    public int getItemCount() {
        if (this.mCouponsets == null) {
            return 0;
        }
        return this.mCouponsets.size();
    }

    public Couponset getItem(int id2) {
        return (Couponset)this.mCouponsets.get(id2);
    }

    public void updateData(CouponsetsList couponsets) {
        this.mCouponsets.clear();
        this.mCouponsets.addAll(couponsets);
        this.notifyDataSetChanged();
    }

    public CouponsetViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.active_coupon_layout, parent, false);
        return new CouponsetViewHolder(itemView);
    }

    public void onBindViewHolder(CouponsetViewHolder holder, int position) {
        Couponset couponsetItem = (Couponset)this.mCouponsets.get(position);
        if (couponsetItem != null) {
            if (!TextUtils.isEmpty((CharSequence)couponsetItem.getImgPreview())) {
                ((RequestBuilder)Glide.with((Context)this.mContext).load(couponsetItem.getImgPreview()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCouponLogo);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivCouponLogo);
            }
            holder.tvCouponTitle.setText((CharSequence)couponsetItem.getName());
            holder.tvCouponDescription.setText((CharSequence)HtmlCompat.fromHtml((String)couponsetItem.getDescription(), (int)63));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date newDate = new Date();
            try {
                newDate = simpleDateFormat.parse(couponsetItem.getExpiration());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            holder.tvCouponDate.setText((CharSequence)String.format(this.mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
            holder.tvCouponValue.setText((CharSequence)couponsetItem.getDiscount());
            holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)couponsetItem));
        }
    }

    public Observable<Couponset> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    public class CouponsetViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivCouponLogo;
        private TextView tvCouponTitle;
        private TextView tvCouponValue;
        private TextView tvCouponDate;
        private TextView tvCouponDescription;

        public CouponsetViewHolder(View view) {
            super(view);
            this.ivCouponLogo = (ImageView)view.findViewById(R.id.iv_active_coupon);
            this.tvCouponTitle = (TextView)view.findViewById(R.id.tv_active_coupons_title);
            this.tvCouponValue = (TextView)view.findViewById(R.id.tv_active_coupons_value);
            this.tvCouponDate = (TextView)view.findViewById(R.id.tv_active_coupons_date);
            this.tvCouponDescription = (TextView)view.findViewById(R.id.tv_active_coupons_description);
        }
    }
}

