/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;

public class ExpiredCouponAdapter
extends RecyclerView.Adapter<ExpiredCouponViewHolder> {
    private Context mContext;
    private ArrayList<Coupon> mCoupons;
    private final PublishSubject<Coupon> onClickSubject = PublishSubject.create();
    private boolean mIsCustom = false;

    public ExpiredCouponAdapter(Context mContext, CouponList campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
    }

    public ExpiredCouponAdapter(Context mContext, ArrayList<Coupon> campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
    }

    public ExpiredCouponAdapter(Context mContext, ArrayList<Coupon> campaignList, boolean custom) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.mIsCustom = custom;
    }

    public int getItemCount() {
        if (this.mCoupons == null) {
            return 0;
        }
        return this.mCoupons.size();
    }

    public Coupon getItem(int id2) {
        return this.mCoupons.get(id2);
    }

    public void updateData(CouponList couponList) {
        this.mCoupons.clear();
        this.mCoupons.addAll(couponList);
        this.notifyDataSetChanged();
    }

    public ExpiredCouponViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.expired_coupon_layout, parent, false);
        return new ExpiredCouponViewHolder(itemView);
    }

    public void onBindViewHolder(ExpiredCouponViewHolder holder, int position) {
        Coupon couponItem = this.mCoupons.get(position);
        if (couponItem != null) {
            if (this.mIsCustom) {
                holder.tvCouponTitle.setText((CharSequence)couponItem.getMerchantDetails().getAdminName());
                if (!TextUtils.isEmpty((CharSequence)couponItem.getMerchantDetails().getImgPreview())) {
                    ((RequestBuilder)Glide.with((Context)this.mContext).load(couponItem.getMerchantDetails().getImgPreview()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCouponLogo);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                Date newDate = new Date();
                try {
                    newDate = simpleDateFormat.parse(couponItem.getChangesDates().optString("redeemed"));
                    simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                    holder.tvCouponDate.setText((CharSequence)simpleDateFormat.format(newDate != null ? newDate : ""));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    holder.tvCouponDate.setVisibility(8);
                }
                String itemValue = String.format("%.02f", Float.valueOf(couponItem.getDiscount()));
                holder.tvCouponValue.setText((CharSequence)(itemValue + this.mContext.getResources().getString(R.string.euro)));
                holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)couponItem));
                return;
            }
            holder.tvCouponTitle.setText((CharSequence)couponItem.getMerchantDetails().getAdminName());
            if (!TextUtils.isEmpty((CharSequence)couponItem.getMerchantDetails().getImgPreview())) {
                ((RequestBuilder)Glide.with((Context)this.mContext).load(couponItem.getMerchantDetails().getImgPreview()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCouponLogo);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date newDate = new Date();
            try {
                newDate = simpleDateFormat.parse(couponItem.getChangesDates().optString("redeemed"));
                simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                holder.tvCouponDate.setText((CharSequence)simpleDateFormat.format(newDate != null ? newDate : ""));
            }
            catch (ParseException e) {
                e.printStackTrace();
                holder.tvCouponDate.setVisibility(8);
            }
            String itemValue = String.format("%.02f", couponItem.getCouponsetDetails().getFinal_price());
            holder.tvCouponValue.setText((CharSequence)(itemValue + this.mContext.getResources().getString(R.string.euro)));
            holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)couponItem));
        }
    }

    public Observable<Coupon> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    public class ExpiredCouponViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvCouponTitle;
        private TextView tvCouponValue;
        private TextView tvCouponDate;
        private ImageView ivCouponLogo;

        public ExpiredCouponViewHolder(View view) {
            super(view);
            this.tvCouponTitle = (TextView)view.findViewById(R.id.tv_expired_coupons_title);
            this.tvCouponValue = (TextView)view.findViewById(R.id.tv_expired_coupons_value);
            this.tvCouponDate = (TextView)view.findViewById(R.id.tv_expired_coupons_date);
            this.ivCouponLogo = (ImageView)view.findViewById(R.id.iv_expired_logo);
        }
    }
}

