/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;

public class HomeCampaignAdapter
extends RecyclerView.Adapter<HomeCampaignViewHolder> {
    private Context mContext;
    private CampaignList mCampaigns;
    private final PublishSubject<Campaign> onClickSubject = PublishSubject.create();

    public HomeCampaignAdapter(Context mContext, CampaignList campaignList) {
        this.mContext = mContext;
        this.mCampaigns = campaignList;
    }

    public int getItemCount() {
        if (this.mCampaigns == null) {
            return 0;
        }
        return this.mCampaigns.size();
    }

    public Campaign getItem(int id2) {
        return (Campaign)this.mCampaigns.get(id2);
    }

    public void updateData(CampaignList campaignList) {
        this.mCampaigns.clear();
        this.mCampaigns.addAll(campaignList);
        this.notifyDataSetChanged();
    }

    public HomeCampaignViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.carousel_item, parent, false);
        return new HomeCampaignViewHolder(itemView);
    }

    public void onBindViewHolder(HomeCampaignViewHolder holder, int position) {
        Campaign campaignItem = (Campaign)this.mCampaigns.get(position);
        if (campaignItem != null) {
            if (!TextUtils.isEmpty((CharSequence)campaignItem.getLogoUrl())) {
                ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(campaignItem.getLogoUrl()).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(10)})).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCampaignTitle);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivCampaignTitle);
            }
            holder.tvCampaignTitle.setText((CharSequence)campaignItem.getTitle());
            holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)campaignItem));
        }
    }

    public Observable<Campaign> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    public class HomeCampaignViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivCampaignTitle;
        private TextView tvCampaignTitle;

        public HomeCampaignViewHolder(View view) {
            super(view);
            this.ivCampaignTitle = (ImageView)view.findViewById(R.id.imageView);
            this.tvCampaignTitle = (TextView)view.findViewById(R.id.textView);
        }
    }
}

