/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.graphics.PorterDuff;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;

public class HomeCouponAdapter
extends RecyclerView.Adapter<HomeCouponViewHolder> {
    private Context mContext;
    private CouponList mCoupons;
    private final PublishSubject<Coupon> onClickSubject = PublishSubject.create();
    private boolean isBurnt = false;

    public HomeCouponAdapter(Context mContext, CouponList campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.isBurnt = false;
    }

    public HomeCouponAdapter(Context mContext, CouponList campaignList, boolean isBurnt) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.isBurnt = isBurnt;
    }

    public int getItemCount() {
        if (this.mCoupons == null) {
            return 0;
        }
        return this.mCoupons.size();
    }

    public Coupon getItem(int id2) {
        return (Coupon)this.mCoupons.get(id2);
    }

    public void updateData(CouponList couponList) {
        this.mCoupons.clear();
        this.mCoupons.addAll(couponList);
        this.notifyDataSetChanged();
    }

    public HomeCouponViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = this.isBurnt ? LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.burnt_coupon_layout, parent, false) : LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.coupon_layout, parent, false);
        return new HomeCouponViewHolder(itemView);
    }

    public void onBindViewHolder(HomeCouponViewHolder holder, int position) {
        Coupon couponItem = (Coupon)this.mCoupons.get(position);
        if (couponItem != null) {
            holder.tvCouponTitle.setText((CharSequence)couponItem.getName());
            if (this.isBurnt) {
                holder.ivCouponBackground.setColorFilter(ContextCompat.getColor((Context)this.mContext, (int)R.color.grey_light2), PorterDuff.Mode.MULTIPLY);
            }
            holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)couponItem));
        }
    }

    public Observable<Coupon> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    public class HomeCouponViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivCouponBackground;
        private TextView tvCouponTitle;

        public HomeCouponViewHolder(View view) {
            super(view);
            this.ivCouponBackground = (ImageView)view.findViewById(R.id.imageView2);
            this.tvCouponTitle = (TextView)view.findViewById(R.id.tv_coupon_subtitle);
        }
    }
}

