/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.UnifiedCoupon;

public class MarketCouponAdapter
extends RecyclerView.Adapter<ActiveCouponViewHolder> {
    private Context mContext;
    private ArrayList<UnifiedCoupon> mCoupons;
    private final PublishSubject<UnifiedCoupon> onClickSubject = PublishSubject.create();
    private boolean mIsPast = false;

    public MarketCouponAdapter(Context mContext, ArrayList<UnifiedCoupon> campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.mIsPast = false;
    }

    public MarketCouponAdapter(Context mContext, ArrayList<UnifiedCoupon> campaignList, boolean past) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
        this.mIsPast = past;
    }

    public int getItemCount() {
        if (this.mCoupons == null) {
            return 0;
        }
        return this.mCoupons.size();
    }

    public UnifiedCoupon getItem(int id2) {
        return this.mCoupons.get(id2);
    }

    public void updateData(ArrayList<UnifiedCoupon> couponList) {
        this.mCoupons.clear();
        this.mCoupons.addAll(couponList);
        this.notifyDataSetChanged();
    }

    public ActiveCouponViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = this.mIsPast ? LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.past_coupon_layout, parent, false) : LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.market_coupon_layout, parent, false);
        return new ActiveCouponViewHolder(itemView);
    }

    public void onBindViewHolder(ActiveCouponViewHolder holder, int position) {
        UnifiedCoupon couponItem = this.mCoupons.get(position);
        if (couponItem != null) {
            int count = 0;
            float activeValue = 0.0f;
            if (couponItem.getCoupons() != null && couponItem.getCoupons().size() > 0) {
                ArrayList<Coupon> couponList = new ArrayList<Coupon>();
                for (Coupon item : couponItem.getCoupons()) {
                    if (item.getStatus() != 1) continue;
                    ++count;
                    activeValue += Float.parseFloat(item.getDiscount());
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    Date newDate = new Date();
                    try {
                        newDate = simpleDateFormat.parse(item.getExpiration());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    item.setExpirationDate(newDate);
                    couponList.add(item);
                }
                Collections.sort(couponList, (coupon1, coupon2) -> coupon2.getExpirationDate().compareTo(coupon1.getExpirationDate()));
                if (couponList != null && couponList.size() > 0) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    Date newDate = new Date();
                    try {
                        newDate = simpleDateFormat.parse(((Coupon)couponList.get(0)).getExpiration());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                    holder.tvCouponDate.setText((CharSequence)String.format(this.mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
                }
            }
            if (count > 1) {
                holder.tvCouponCount.setText((CharSequence)String.format(this.mContext.getString(R.string.cos_market_active_coupons2), String.valueOf(count)));
            } else if (count == 1) {
                holder.tvCouponCount.setText((CharSequence)String.format(this.mContext.getString(R.string.cos_market_active_coupons_single2), String.valueOf(count)));
            }
            holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)couponItem));
        }
    }

    public Observable<UnifiedCoupon> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    public class ActiveCouponViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivCouponBackground;
        private TextView tvCouponTitle;
        private TextView tvCouponDate;
        private TextView tvCouponCount;

        public ActiveCouponViewHolder(View view) {
            super(view);
            this.ivCouponBackground = (ImageView)view.findViewById(R.id.iv_past_coupon_background);
            this.tvCouponTitle = (TextView)view.findViewById(R.id.tv_market_coupons_title);
            this.tvCouponDate = (TextView)view.findViewById(R.id.tv_market_coupons_date);
            this.tvCouponCount = (TextView)view.findViewById(R.id.tv_market_coupons_count);
        }
    }
}

