/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.MergedActiveGifts;

public class MergedActiveGiftsAdapter
extends RecyclerView.Adapter<MergedActiveGiftsViewHolder> {
    private Context mContext;
    private ArrayList<MergedActiveGifts> mMergedActiveGifts;
    private final PublishSubject<MergedActiveGifts> onClickSubject = PublishSubject.create();

    public MergedActiveGiftsAdapter(Context mContext, ArrayList<MergedActiveGifts> mergedactivegifts) {
        this.mContext = mContext;
        this.mMergedActiveGifts = mergedactivegifts;
    }

    public int getItemCount() {
        if (this.mMergedActiveGifts == null) {
            return 0;
        }
        return this.mMergedActiveGifts.size();
    }

    public MergedActiveGifts getItem(int id2) {
        return this.mMergedActiveGifts.get(id2);
    }

    public void updateData(ArrayList<MergedActiveGifts> mergedactivegifts) {
        this.mMergedActiveGifts.clear();
        this.mMergedActiveGifts.addAll(mergedactivegifts);
        this.notifyDataSetChanged();
    }

    public MergedActiveGiftsViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.active_coupon_layout, parent, false);
        return new MergedActiveGiftsViewHolder(itemView);
    }

    public void onBindViewHolder(MergedActiveGiftsViewHolder holder, int position) {
        MergedActiveGifts mergedgiftsItem = this.mMergedActiveGifts.get(position);
        if (mergedgiftsItem != null && mergedgiftsItem.getDataType() == 1) {
            if (!TextUtils.isEmpty((CharSequence)mergedgiftsItem.getCampaign().getLogoUrl())) {
                ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(mergedgiftsItem.getCampaign().getLogoUrl()).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(4)})).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivMergedActiveGiftsLogo);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivMergedActiveGiftsLogo);
            }
            holder.tvMergedActiveGiftsTitle.setText((CharSequence)mergedgiftsItem.getCampaign().getTitle());
        } else if (mergedgiftsItem != null && mergedgiftsItem.getDataType() == 2) {
            if (!TextUtils.isEmpty((CharSequence)mergedgiftsItem.getCoupon().getImage())) {
                ((RequestBuilder)Glide.with((Context)this.mContext).load(mergedgiftsItem.getCoupon().getImage()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivMergedActiveGiftsLogo);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivMergedActiveGiftsLogo);
            }
            holder.tvMergedActiveGiftsTitle.setText((CharSequence)mergedgiftsItem.getCoupon().getName());
            holder.tvMergedActiveGiftsDescription.setText((CharSequence)mergedgiftsItem.getCoupon().getDescription());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date newDate = new Date();
            try {
                newDate = simpleDateFormat.parse(mergedgiftsItem.getCoupon().getExpiration());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            holder.tvMergedActiveGiftsDate.setText((CharSequence)String.format(this.mContext.getString(R.string.cos_coupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
            holder.tvMergedActiveGiftsValue.setText((CharSequence)(mergedgiftsItem.getCoupon().getDiscount() + this.mContext.getResources().getString(R.string.euro)));
        }
        holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)mergedgiftsItem));
    }

    public Observable<MergedActiveGifts> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    public class MergedActiveGiftsViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivMergedActiveGiftsLogo;
        private TextView tvMergedActiveGiftsTitle;
        private TextView tvMergedActiveGiftsValue;
        private TextView tvMergedActiveGiftsDate;
        private TextView tvMergedActiveGiftsDescription;

        public MergedActiveGiftsViewHolder(View view) {
            super(view);
            this.ivMergedActiveGiftsLogo = (ImageView)view.findViewById(R.id.iv_active_coupon);
            this.tvMergedActiveGiftsTitle = (TextView)view.findViewById(R.id.tv_active_coupons_title);
            this.tvMergedActiveGiftsValue = (TextView)view.findViewById(R.id.tv_active_coupons_value);
            this.tvMergedActiveGiftsDate = (TextView)view.findViewById(R.id.tv_active_coupons_date);
            this.tvMergedActiveGiftsDescription = (TextView)view.findViewById(R.id.tv_active_coupons_description);
        }
    }
}

