/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.MergedGifts;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarplyManagerHelper;
import org.json.JSONObject;

public class MergedGiftsAdapter
extends RecyclerView.Adapter<MergedGiftsViewHolder> {
    private Context mContext;
    private ArrayList<MergedGifts> mMergedGifts = new ArrayList();
    private final PublishSubject<MergedGifts> onClickSubject = PublishSubject.create();

    public MergedGiftsAdapter(Context mContext, ArrayList<MergedGifts> mergedgifts) {
        this.mContext = mContext;
        this.mMergedGifts.clear();
        this.mMergedGifts.addAll(mergedgifts);
    }

    public int getItemCount() {
        if (this.mMergedGifts == null) {
            return 0;
        }
        return this.mMergedGifts.size();
    }

    public long getItemId(int position) {
        return super.getItemId(position);
    }

    public MergedGifts getItem(int id2) {
        return this.mMergedGifts.get(id2);
    }

    public void updateData(ArrayList<MergedGifts> mergedgifts) {
        this.mMergedGifts.clear();
        this.mMergedGifts.addAll(mergedgifts);
        this.notifyDataSetChanged();
    }

    public MergedGiftsViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_merged_gifts_recycler, parent, false);
        return new MergedGiftsViewHolder(itemView);
    }

    public void onBindViewHolder(MergedGiftsViewHolder holder, int position) {
        MergedGifts mergedgiftsItem = this.mMergedGifts.get(position);
        if (mergedgiftsItem != null && mergedgiftsItem.getDataType() == 1) {
            JSONObject extraFields = WarpJSONParser.getJSONFromString(mergedgiftsItem.getCampaign().getExtraFields());
            if (extraFields != null) {
                if (extraFields.has("type") && extraFields.optString("type").equals("telco")) {
                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                        if (!ccms.getLoyaltyCampaignId().equals(mergedgiftsItem.getCampaign().getSessionUUID())) continue;
                        if (!TextUtils.isEmpty((CharSequence)ccms.getImageUrl())) {
                            ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(ccms.getImageUrl()).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(4)})).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivMergedGiftsLogo);
                        } else {
                            Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivMergedGiftsLogo);
                        }
                        holder.tvMergedGiftsTitle.setText((CharSequence)ccms.getTitle());
                        if (mergedgiftsItem.getCampaign().getIsNew()) {
                            holder.ivIsNew.setVisibility(0);
                        } else {
                            holder.ivIsNew.setVisibility(8);
                        }
                        holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)mergedgiftsItem));
                        return;
                    }
                    return;
                }
                if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                        if (!ccms.getLoyaltyCampaignId().equals(mergedgiftsItem.getCampaign().getSessionUUID()) || !ccms.getZone().equals("COSMOTE_APP_GIFTS4U")) continue;
                        if (!TextUtils.isEmpty((CharSequence)ccms.getImageUrl())) {
                            ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(ccms.getImageUrl()).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(4)})).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivMergedGiftsLogo);
                        } else {
                            Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivMergedGiftsLogo);
                        }
                        holder.tvMergedGiftsTitle.setText((CharSequence)ccms.getTitle());
                        if (mergedgiftsItem.getCampaign().getIsNew()) {
                            holder.ivIsNew.setVisibility(0);
                        } else {
                            holder.ivIsNew.setVisibility(8);
                        }
                        holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)mergedgiftsItem));
                        return;
                    }
                    return;
                }
            }
            if (!TextUtils.isEmpty((CharSequence)mergedgiftsItem.getCampaign().getLogoUrl())) {
                ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(mergedgiftsItem.getCampaign().getLogoUrl()).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(4)})).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivMergedGiftsLogo);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivMergedGiftsLogo);
            }
            holder.tvMergedGiftsTitle.setText((CharSequence)mergedgiftsItem.getCampaign().getTitle());
            if (mergedgiftsItem.getCampaign().getIsNew()) {
                holder.ivIsNew.setVisibility(0);
            } else {
                holder.ivIsNew.setVisibility(8);
            }
        } else if (mergedgiftsItem != null && mergedgiftsItem.getDataType() == 2) {
            if (!TextUtils.isEmpty((CharSequence)mergedgiftsItem.getSeasonalList().getImageUrl())) {
                ((RequestBuilder)Glide.with((Context)this.mContext).load(mergedgiftsItem.getSeasonalList().getImageUrl()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivMergedGiftsLogo);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivMergedGiftsLogo);
            }
            holder.tvMergedGiftsTitle.setText((CharSequence)mergedgiftsItem.getSeasonalList().getTitle());
        } else if (mergedgiftsItem != null && mergedgiftsItem.getDataType() == 3) {
            if (!TextUtils.isEmpty((CharSequence)mergedgiftsItem.getCCMS().getImageUrl())) {
                ((RequestBuilder)Glide.with((Context)this.mContext).load(mergedgiftsItem.getCCMS().getImageUrl()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivMergedGiftsLogo);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivMergedGiftsLogo);
            }
            holder.tvMergedGiftsTitle.setText((CharSequence)mergedgiftsItem.getCCMS().getTitle());
        }
        holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)mergedgiftsItem));
    }

    public Observable<MergedGifts> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    public class MergedGiftsViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivMergedGiftsLogo;
        private ImageView ivIsNew;
        private TextView tvMergedGiftsTitle;

        public MergedGiftsViewHolder(View view) {
            super(view);
            this.ivMergedGiftsLogo = (ImageView)view.findViewById(R.id.iv_campaign_logo);
            this.tvMergedGiftsTitle = (TextView)view.findViewById(R.id.tv_campaign_title);
            this.ivIsNew = (ImageView)view.findViewById(R.id.iv_campaign_new);
        }
    }
}

