/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.MergedMore;

public class MergedMoreAdapter
extends RecyclerView.Adapter<MergedMoreViewHolder> {
    private Context mContext;
    private ArrayList<MergedMore> mMergedMore;
    private final PublishSubject<MergedMore> onClickSubject = PublishSubject.create();

    public MergedMoreAdapter(Context mContext, ArrayList<MergedMore> mergedmore) {
        this.mContext = mContext;
        this.mMergedMore = mergedmore;
    }

    public int getItemCount() {
        if (this.mMergedMore == null) {
            return 0;
        }
        return this.mMergedMore.size();
    }

    public MergedMore getItem(int id2) {
        return this.mMergedMore.get(id2);
    }

    public void updateData(ArrayList<MergedMore> mergedmore) {
        this.mMergedMore.clear();
        this.mMergedMore.addAll(mergedmore);
        this.notifyDataSetChanged();
    }

    public MergedMoreViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_profile_recycler_vertical, parent, false);
        return new MergedMoreViewHolder(itemView);
    }

    public void onBindViewHolder(MergedMoreViewHolder holder, int position) {
        MergedMore mergedmoreItem = this.mMergedMore.get(position);
        if (mergedmoreItem != null && mergedmoreItem.getDataType() == 1) {
            if (!TextUtils.isEmpty((CharSequence)mergedmoreItem.getCampaign().getLogoUrl())) {
                ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(mergedmoreItem.getCampaign().getLogoUrl()).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(4)})).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCampaignTitle);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivCampaignTitle);
            }
            holder.tvCampaignTitle.setText((CharSequence)mergedmoreItem.getCampaign().getTitle());
            holder.tvCampaignSubtitle.setText((CharSequence)mergedmoreItem.getCampaign().getSubtitle());
            holder.tvCampaignMessage.setText((CharSequence)mergedmoreItem.getCampaign().getMessage());
            if (mergedmoreItem.getCampaign().getIsNew()) {
                holder.ivIsNew.setVisibility(0);
            } else {
                holder.ivIsNew.setVisibility(8);
            }
        } else if (mergedmoreItem != null && mergedmoreItem.getDataType() == 2) {
            if (!TextUtils.isEmpty((CharSequence)mergedmoreItem.getCCMS().getImageUrl())) {
                ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(mergedmoreItem.getCCMS().getImageUrl()).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(4)})).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCampaignTitle);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivCampaignTitle);
            }
            holder.tvCampaignTitle.setText((CharSequence)mergedmoreItem.getCCMS().getTitle());
            holder.tvCampaignSubtitle.setText((CharSequence)mergedmoreItem.getCCMS().getSubtitle());
            holder.tvCampaignMessage.setText((CharSequence)mergedmoreItem.getCCMS().getMessage());
            holder.ivIsNew.setVisibility(8);
        }
        holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)mergedmoreItem));
    }

    public Observable<MergedMore> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    public class MergedMoreViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivCampaignTitle;
        private ImageView ivIsNew;
        private TextView tvCampaignTitle;
        private TextView tvCampaignSubtitle;
        private TextView tvCampaignMessage;

        public MergedMoreViewHolder(View view) {
            super(view);
            this.ivCampaignTitle = (ImageView)view.findViewById(R.id.iv_campaign_logo);
            this.tvCampaignTitle = (TextView)view.findViewById(R.id.tv_campaign_title);
            this.ivIsNew = (ImageView)view.findViewById(R.id.iv_campaign_new);
            this.tvCampaignSubtitle = (TextView)view.findViewById(R.id.tv_campaign_subtitle);
            this.tvCampaignMessage = (TextView)view.findViewById(R.id.tv_campaign_message);
        }
    }
}

