/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;

public class MoreContextualAdapter
extends RecyclerView.Adapter<MoreContextualViewHolder> {
    private Context mContext;
    private ArrayList<LoyaltyContextualOfferModel> mCampaigns = new ArrayList();
    private final PublishSubject<LoyaltyContextualOfferModel> onClickSubject = PublishSubject.create();

    public MoreContextualAdapter(Context mContext, ArrayList<LoyaltyContextualOfferModel> campaignList) {
        this.mContext = mContext;
        this.mCampaigns.clear();
        this.mCampaigns.addAll(campaignList);
    }

    public int getItemCount() {
        if (this.mCampaigns == null) {
            return 0;
        }
        return this.mCampaigns.size();
    }

    public long getItemId(int position) {
        return super.getItemId(position);
    }

    public LoyaltyContextualOfferModel getItem(int id2) {
        return this.mCampaigns.get(id2);
    }

    public void updateData(ArrayList<LoyaltyContextualOfferModel> campaignList) {
        this.mCampaigns.clear();
        this.mCampaigns.addAll(campaignList);
        this.notifyDataSetChanged();
    }

    public MoreContextualViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_profile_recycler_vertical, parent, false);
        return new MoreContextualViewHolder(itemView);
    }

    public void onBindViewHolder(MoreContextualViewHolder holder, int position) {
        LoyaltyContextualOfferModel campaignItem = this.mCampaigns.get(position);
        if (campaignItem != null) {
            if (!TextUtils.isEmpty((CharSequence)campaignItem.getImageUrl())) {
                ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(campaignItem.getImageUrl()).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(4)})).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCampaignTitle);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivCampaignTitle);
            }
            holder.tvCampaignTitle.setText((CharSequence)campaignItem.getTitle());
            holder.tvCampaignSubtitle.setText((CharSequence)campaignItem.getSubtitle());
            holder.tvCampaignMessage.setText((CharSequence)campaignItem.getMessage());
            holder.ivIsNew.setVisibility(8);
            holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)campaignItem));
        }
    }

    public Observable<LoyaltyContextualOfferModel> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    public class MoreContextualViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivCampaignTitle;
        private ImageView ivIsNew;
        private TextView tvCampaignTitle;
        private TextView tvCampaignSubtitle;
        private TextView tvCampaignMessage;

        public MoreContextualViewHolder(View view) {
            super(view);
            this.ivCampaignTitle = (ImageView)view.findViewById(R.id.iv_campaign_logo);
            this.tvCampaignTitle = (TextView)view.findViewById(R.id.tv_campaign_title);
            this.ivIsNew = (ImageView)view.findViewById(R.id.iv_campaign_new);
            this.tvCampaignSubtitle = (TextView)view.findViewById(R.id.tv_campaign_subtitle);
            this.tvCampaignMessage = (TextView)view.findViewById(R.id.tv_campaign_message);
        }
    }
}

