/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;

public class ProfileCampaignAdapter
extends RecyclerView.Adapter<ProfileCampaignViewHolder> {
    private Context mContext;
    private CampaignList mCampaigns;
    private final PublishSubject<Campaign> onClickSubject = PublishSubject.create();
    private boolean mIsVertical = false;

    public ProfileCampaignAdapter(Context mContext, CampaignList campaignList) {
        this.mContext = mContext;
        this.mCampaigns = campaignList;
        this.mIsVertical = false;
    }

    public ProfileCampaignAdapter(Context mContext, CampaignList campaignList, boolean vertical) {
        this.mContext = mContext;
        this.mCampaigns = campaignList;
        this.mIsVertical = vertical;
    }

    public int getItemCount() {
        if (this.mCampaigns == null) {
            return 0;
        }
        return this.mCampaigns.size();
    }

    public Campaign getItem(int id2) {
        return (Campaign)this.mCampaigns.get(id2);
    }

    public void updateData(CampaignList campaignList) {
        this.mCampaigns.clear();
        this.mCampaigns.addAll(campaignList);
        this.notifyDataSetChanged();
    }

    public ProfileCampaignViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (!this.mIsVertical) {
            View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_profile_recycler, parent, false);
            return new ProfileCampaignViewHolder(itemView);
        }
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_profile_recycler_vertical, parent, false);
        return new ProfileCampaignViewHolder(itemView, true);
    }

    public void onBindViewHolder(ProfileCampaignViewHolder holder, int position) {
        Campaign campaignItem = (Campaign)this.mCampaigns.get(position);
        if (campaignItem != null) {
            if (!TextUtils.isEmpty((CharSequence)campaignItem.getLogoUrl())) {
                ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(campaignItem.getLogoUrl()).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(4)})).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCampaignTitle);
            } else {
                Glide.with((Context)this.mContext).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(holder.ivCampaignTitle);
            }
            holder.tvCampaignTitle.setText((CharSequence)campaignItem.getTitle());
            if (this.mIsVertical) {
                holder.tvCampaignSubtitle.setText((CharSequence)campaignItem.getSubtitle());
                holder.tvCampaignMessage.setText((CharSequence)campaignItem.getMessage());
                if (campaignItem.getIsNew()) {
                    holder.ivIsNew.setVisibility(0);
                } else {
                    holder.ivIsNew.setVisibility(8);
                }
            }
            holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)campaignItem));
        }
    }

    public Observable<Campaign> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    public class ProfileCampaignViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivCampaignTitle;
        private ImageView ivIsNew;
        private TextView tvCampaignTitle;
        private TextView tvCampaignSubtitle;
        private TextView tvCampaignMessage;

        public ProfileCampaignViewHolder(View view) {
            super(view);
            this.ivCampaignTitle = (ImageView)view.findViewById(R.id.iv_campaign_logo);
            this.tvCampaignTitle = (TextView)view.findViewById(R.id.tv_campaign_title);
        }

        public ProfileCampaignViewHolder(View view, boolean vertical) {
            super(view);
            this.ivCampaignTitle = (ImageView)view.findViewById(R.id.iv_campaign_logo);
            this.tvCampaignTitle = (TextView)view.findViewById(R.id.tv_campaign_title);
            this.ivIsNew = (ImageView)view.findViewById(R.id.iv_campaign_new);
            if (vertical) {
                this.tvCampaignSubtitle = (TextView)view.findViewById(R.id.tv_campaign_subtitle);
                this.tvCampaignMessage = (TextView)view.findViewById(R.id.tv_campaign_message);
            }
        }
    }
}

