/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Merchant;
import ly.warp.sdk.io.models.SharingCoupon;
import ly.warp.sdk.io.models.SharingList;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarplyManagerHelper;
import org.json.JSONObject;

public class SharedCouponAdapter
extends RecyclerView.Adapter<SharedCouponViewHolder> {
    private Context mContext;
    private ArrayList<SharingCoupon> mCoupons;
    private final PublishSubject<SharingCoupon> onClickSubject = PublishSubject.create();

    public SharedCouponAdapter(Context mContext, SharingList campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
    }

    public SharedCouponAdapter(Context mContext, ArrayList<SharingCoupon> campaignList) {
        this.mContext = mContext;
        this.mCoupons = campaignList;
    }

    public int getItemCount() {
        if (this.mCoupons == null) {
            return 0;
        }
        return this.mCoupons.size();
    }

    public SharingCoupon getItem(int id2) {
        return this.mCoupons.get(id2);
    }

    public void updateData(SharingList couponList) {
        this.mCoupons.clear();
        this.mCoupons.addAll(couponList);
        this.notifyDataSetChanged();
    }

    public SharedCouponViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.shared_coupon_layout, parent, false);
        return new SharedCouponViewHolder(itemView);
    }

    public void onBindViewHolder(SharedCouponViewHolder holder, int position) {
        SharingCoupon couponItem = this.mCoupons.get(position);
        Merchant merchant = new Merchant();
        if (couponItem != null) {
            if (WarplyManagerHelper.getMerchantList() != null && WarplyManagerHelper.getMerchantList().size() > 0) {
                for (Merchant mer : WarplyManagerHelper.getMerchantList()) {
                    if (!mer.getUuid().equals(couponItem.getMerchantUuid())) continue;
                    merchant = mer;
                    break;
                }
            }
            if (merchant == null) {
                holder.tvCouponTitle.setText((CharSequence)couponItem.getName());
            } else {
                holder.tvCouponTitle.setText((CharSequence)merchant.getAdminName());
                if (!TextUtils.isEmpty((CharSequence)merchant.getImgPreview())) {
                    ((RequestBuilder)Glide.with((Context)this.mContext).load(merchant.getImgPreview()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(holder.ivCouponLogo);
                }
            }
            JSONObject extraFields = WarpJSONParser.getJSONFromString(couponItem.getTransactionMetadata());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss", Locale.US);
            Date newDate = new Date();
            try {
                newDate = simpleDateFormat.parse(couponItem.getDate());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            holder.tvCouponDate.setText((CharSequence)simpleDateFormat.format(newDate != null ? newDate : ""));
            if (couponItem.getSharingType().equals("sent")) {
                holder.tvCouponLabel.setText(R.string.cos_shared_coupon_receiver);
                if (extraFields != null && extraFields.has("receiver_msisdn")) {
                    holder.tvCouponPhone.setText((CharSequence)extraFields.optString("receiver_msisdn"));
                }
            } else if (couponItem.getSharingType().equals("received")) {
                holder.tvCouponLabel.setText(R.string.cos_shared_coupon_sender);
                if (extraFields != null && extraFields.has("sender_msisdn")) {
                    holder.tvCouponPhone.setText((CharSequence)extraFields.optString("sender_msisdn"));
                }
            }
            String itemValue = String.format("%.02f", couponItem.getFinal_price());
            holder.tvCouponValue.setText((CharSequence)(itemValue + this.mContext.getResources().getString(R.string.euro)));
            holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)couponItem));
        }
    }

    public Observable<SharingCoupon> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    private long getDifferenceDays(Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        return TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    public class SharedCouponViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvCouponTitle;
        private TextView tvCouponValue;
        private TextView tvCouponDate;
        private TextView tvCouponLabel;
        private TextView tvCouponPhone;
        private ImageView ivCouponLogo;

        public SharedCouponViewHolder(View view) {
            super(view);
            this.tvCouponTitle = (TextView)view.findViewById(R.id.tv_shared_coupons_title);
            this.tvCouponValue = (TextView)view.findViewById(R.id.tv_shared_coupons_value);
            this.tvCouponDate = (TextView)view.findViewById(R.id.tv_shared_coupons_date);
            this.tvCouponLabel = (TextView)view.findViewById(R.id.tv_shared_coupons_label);
            this.tvCouponPhone = (TextView)view.findViewById(R.id.tv_shared_coupons_phone);
            this.ivCouponLogo = (ImageView)view.findViewById(R.id.iv_shared_logo);
        }
    }
}

