/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.TelematicsHistory;

public class TelematicsHistoryAdapter
extends RecyclerView.Adapter<TelematicsViewHolder> {
    private Context mContext;
    private ArrayList<TelematicsHistory> mHistory;
    private final PublishSubject<TelematicsHistory> onClickSubject = PublishSubject.create();

    public TelematicsHistoryAdapter(Context mContext, ArrayList<TelematicsHistory> history) {
        this.mContext = mContext;
        this.mHistory = history;
    }

    public int getItemCount() {
        if (this.mHistory == null) {
            return 0;
        }
        return this.mHistory.size();
    }

    public TelematicsHistory getItem(int id2) {
        return this.mHistory.get(id2);
    }

    public void updateData(ArrayList<TelematicsHistory> history) {
        this.mHistory.clear();
        this.mHistory.addAll(history);
        this.notifyDataSetChanged();
    }

    public TelematicsViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.telematics_history_layout, parent, false);
        return new TelematicsViewHolder(itemView);
    }

    public void onBindViewHolder(TelematicsViewHolder holder, int position) {
        TelematicsHistory historyItem = this.mHistory.get(position);
        if (historyItem != null) {
            holder.tvHistoryId.setText((CharSequence)String.valueOf(historyItem.getTripId()));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss", Locale.US);
            Date newDate = new Date();
            try {
                newDate = simpleDateFormat.parse(historyItem.getCreated());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            holder.tvHistoryDate.setText((CharSequence)String.valueOf(simpleDateFormat.format(newDate != null ? newDate : "")));
            holder.itemView.setOnClickListener(v -> this.onClickSubject.onNext((Object)historyItem));
        }
    }

    public Observable<TelematicsHistory> getPositionClicks() {
        return this.onClickSubject.cache();
    }

    public class TelematicsViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvHistoryId;
        private TextView tvHistoryDate;

        public TelematicsViewHolder(View view) {
            super(view);
            this.tvHistoryId = (TextView)view.findViewById(R.id.tv_telematics_history_value);
            this.tvHistoryDate = (TextView)view.findViewById(R.id.tv_telematics_history_date_value);
        }
    }
}

