/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters.mix;

import android.content.Context;
import android.os.Handler;
import android.view.View;
import java.util.LinkedList;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import ly.warp.sdk.Warply;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.callbacks.SimpleCallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.request.WarplyInboxRequest;
import ly.warp.sdk.views.CampaignItemViewHolder;
import ly.warp.sdk.views.CampaignItemWebHolder;
import ly.warp.sdk.views.adapters.mix.CampaignsMixTracker;

public class CampaignsMixController
implements CallbackReceiver<CampaignList> {
    public static final int CAMPAIGN_START_POSITION = 1;
    public static final int CAMPAIGN_FREQUENCY = 5;
    private CampaignList mCampaigns;
    private WarplyInboxRequest mCampaignsRequest;
    private TreeMap<Integer, Campaign> mPositionsToCampaigns;
    private Queue<Campaign> mCampaignsPool;
    private AtomicBoolean isRequestComplete = new AtomicBoolean(true);
    private int mCampaignsStartPosition;
    private int mCampaignsFrequency;
    private boolean isRepeatableSet;
    private static Handler mHandler = new Handler();
    private MixControllerListener mControllerListener;
    private SimpleCallbackReceiver<CampaignList> mExternalListener;
    private CampaignsMixTracker mAnalyticsTracker;
    private Runnable mUpdateItemsRunnable = new Runnable(){

        @Override
        public void run() {
            CampaignsMixController.this.mControllerListener.onMixControllerUpdate();
            CampaignsMixController.this.isRequestComplete.set(true);
        }
    };

    public CampaignsMixController(Context context, WarplyInboxRequest campaignsRequest, MixControllerListener listener) {
        Warply.getInitializer(context).init();
        this.mPositionsToCampaigns = new TreeMap();
        this.mCampaignsPool = new LinkedList<Campaign>();
        this.mCampaignsStartPosition = 1;
        this.mCampaignsFrequency = 5;
        this.mCampaignsRequest = campaignsRequest;
        this.mControllerListener = listener;
        this.mAnalyticsTracker = new CampaignsMixTracker(this);
    }

    @Override
    public void onSuccess(CampaignList result) {
        this.mCampaigns = result;
        this.mCampaignsPool = new LinkedList<Campaign>(this.mCampaigns);
        this.updateAdapter();
        this.notifySuccessExternalListener(result);
    }

    @Override
    public void onFailure(int errorCode) {
        this.clear();
        this.updateAdapter();
        this.notifyFailureExternalListener(errorCode);
    }

    private boolean isCampaignForPositionAdded(int position) {
        return this.mPositionsToCampaigns.containsKey(position);
    }

    private boolean checkIfPositionForCampaignAndAdd(int position) {
        boolean isCampaignPosition = (position - this.mCampaignsStartPosition) % (this.mCampaignsFrequency + 1) == 0;
        int maxCampaignsToLoad = (this.mControllerListener.getUserAdapterCount() - this.mCampaignsStartPosition) / this.mCampaignsFrequency + 1;
        if (position == this.mControllerListener.getUserAdapterCount() + maxCampaignsToLoad) {
            isCampaignPosition = false;
        }
        if (isCampaignPosition && !this.isCampaignForPositionAdded(position)) {
            this.getNextCampaignToShow(position);
        }
        return isCampaignPosition && this.isCampaignForPositionAdded(position);
    }

    private void getNextCampaignToShow(int position) {
        if (!this.mCampaignsPool.isEmpty()) {
            Campaign campaign = this.mCampaignsPool.poll();
            this.mPositionsToCampaigns.put(position, campaign);
            this.updateAdapter();
        }
        if (this.mCampaignsPool.size() <= 0) {
            this.requestCampaigns();
        }
    }

    private void requestCampaigns() {
        if (this.isRequestComplete.get()) {
            if (this.mCampaigns == null) {
                this.isRequestComplete.set(false);
                Warply.getInbox(this.mCampaignsRequest, this);
            } else if (this.isRepeatableSet) {
                this.isRequestComplete.set(false);
                this.onSuccess(this.mCampaigns);
            }
        }
    }

    private void updateAdapter() {
        mHandler.removeCallbacks(this.mUpdateItemsRunnable);
        mHandler.postDelayed(this.mUpdateItemsRunnable, 250L);
    }

    private void clear() {
        if (this.mCampaigns != null) {
            this.mCampaigns.clear();
        }
        if (this.mCampaignsPool != null) {
            this.mCampaignsPool.clear();
        }
        if (this.mPositionsToCampaigns != null) {
            this.mPositionsToCampaigns.clear();
        }
    }

    private void notifySuccessExternalListener(CampaignList campaigns) {
        if (this.mExternalListener != null) {
            this.mExternalListener.onSuccess(campaigns);
        }
    }

    private void notifyFailureExternalListener(int errorCode) {
        if (this.mExternalListener != null) {
            this.mExternalListener.onFailure(errorCode);
        }
    }

    public int getCount() {
        return this.mControllerListener.getUserAdapterCount() + this.mPositionsToCampaigns.size();
    }

    public long getItemId(int position) {
        return this.isCampaignForPositionAdded(position) ? (long)position : this.mControllerListener.getUserAdapterItemId(this.getUserAdapterPosition(position));
    }

    public int getViewTypeCount() {
        return this.mControllerListener.getUserAdapterViewTypeCount() + 1;
    }

    public int getItemViewType(int position) {
        return this.checkIfPositionForCampaignAndAdd(position) ? this.getCampaignItemViewType() : this.mControllerListener.getUserAdapterItemViewType(this.getUserAdapterPosition(position));
    }

    public Campaign getCampaignItem(int position) {
        return this.mPositionsToCampaigns.get(position);
    }

    public int getCampaignItemViewType() {
        return this.getViewTypeCount() - 1;
    }

    public int getUserAdapterPosition(int globalPosition) {
        return this.mPositionsToCampaigns.size() != 0 && globalPosition >= this.mCampaignsStartPosition ? globalPosition - this.mPositionsToCampaigns.subMap(0, globalPosition).size() : globalPosition;
    }

    public int getGlobalPosition(int userAdapterPosition) {
        int campaignsCountBeforePosition = (userAdapterPosition - this.mCampaignsStartPosition) / this.mCampaignsFrequency + 1;
        int globalPosition = userAdapterPosition + campaignsCountBeforePosition;
        if (this.mPositionsToCampaigns.size() != 0 && campaignsCountBeforePosition > 0) {
            globalPosition += this.mPositionsToCampaigns.subMap(0, globalPosition).size() - campaignsCountBeforePosition;
            return globalPosition;
        }
        return userAdapterPosition;
    }

    public void resetCampaignsPositions() {
        try {
            this.mPositionsToCampaigns = new TreeMap<Integer, Campaign>(this.mPositionsToCampaigns.subMap(0, this.mControllerListener.getUserAdapterCount() + 1));
        }
        catch (Exception var2) {
            this.mPositionsToCampaigns.clear();
        }
    }

    public CampaignList getCampaigns() {
        return this.mCampaigns;
    }

    public int getCurrentUnreadMessages() {
        return this.mCampaigns != null && this.mCampaigns.size() > 0 ? this.mCampaigns.getUnreadCampaignsCount() : 0;
    }

    public void setCampaignsListener(SimpleCallbackReceiver<CampaignList> listener) {
        this.mExternalListener = listener;
    }

    public void updateCampaigns(WarplyInboxRequest campaignsRequest) {
        this.mCampaignsRequest = campaignsRequest;
        this.clear();
        this.updateAdapter();
    }

    public void setMixBounds(int startPosition, int frequency) {
        if (this.mCampaigns == null || this.mCampaigns.size() == 0) {
            if (startPosition >= 0) {
                this.mCampaignsStartPosition = startPosition;
            }
            if (frequency > 0) {
                this.mCampaignsFrequency = frequency;
            }
        }
    }

    public void setRepeatableSet(boolean isRepeatable) {
        this.isRepeatableSet = isRepeatable;
    }

    public void trackCampaignsView(int firstVisiblePosition, int lastVisiblePosition) {
        this.mAnalyticsTracker.trackCampaignsView(firstVisiblePosition, lastVisiblePosition);
    }

    public CampaignTrackClickListener getTrackCampaignClickListener(CampaignItemViewHolder campaignViewHolder) {
        return new CampaignTrackClickListener(campaignViewHolder, this.mAnalyticsTracker);
    }

    public static interface MixControllerListener {
        public void onMixControllerUpdate();

        public int getUserAdapterCount();

        public long getUserAdapterItemId(int var1);

        public int getUserAdapterViewTypeCount();

        public int getUserAdapterItemViewType(int var1);
    }

    private class CampaignTrackClickListener
    implements View.OnClickListener {
        private CampaignItemViewHolder mmCampaignViewHolder;
        private CampaignsMixTracker mmAnalyticsTracker;

        public CampaignTrackClickListener(CampaignItemViewHolder campaignViewHolder, CampaignsMixTracker tracker) {
            this.mmCampaignViewHolder = campaignViewHolder;
            this.mmAnalyticsTracker = tracker;
        }

        public void onClick(View v) {
            if (this.mmCampaignViewHolder != null) {
                if (this.mmCampaignViewHolder.getCampaign() != null && !(this.mmCampaignViewHolder instanceof CampaignItemWebHolder) && this.mmAnalyticsTracker != null) {
                    this.mmAnalyticsTracker.trackCampaignClick(this.mmCampaignViewHolder.getCampaign());
                }
                this.mmCampaignViewHolder.onClick(v);
            }
        }
    }
}

