/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters.mix;

import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.NonNull;
import ly.warp.sdk.io.callbacks.SimpleCallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.request.WarplyInboxRequest;
import ly.warp.sdk.views.CampaignItemViewHolder;
import ly.warp.sdk.views.CampaignItemWebHolder;
import ly.warp.sdk.views.adapters.mix.CampaignsMixController;

public class CampaignsMixListAdapter<VH extends CampaignItemViewHolder>
extends BaseAdapter
implements CampaignsMixController.MixControllerListener {
    private ListView mListView;
    private Class<VH> mViewHolderClass;
    private BaseAdapter mUserAdapter;
    protected CampaignsMixController mMixController;
    private int mWebItemWidth = 0;
    private int mWebItemHeight = 0;

    protected CampaignsMixListAdapter(Builder<VH> builder) {
        this.mListView = ((Builder)builder).listView;
        this.mMixController = new CampaignsMixController(this.mListView.getContext(), ((Builder)builder).campaignsRequest, this);
        this.mMixController.setRepeatableSet(((Builder)builder).isRepeatableSet);
        this.mMixController.setMixBounds(((Builder)builder).startPosition, ((Builder)builder).frequency);
        this.mWebItemHeight = ((Builder)builder).webItemHeight;
        this.mWebItemWidth = ((Builder)builder).webItemWidth;
        this.mViewHolderClass = ((Builder)builder).viewHolderClass;
        this.mUserAdapter = ((Builder)builder).userAdapter;
        this.mUserAdapter.registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                super.onChanged();
                CampaignsMixListAdapter.this.mMixController.resetCampaignsPositions();
                CampaignsMixListAdapter.this.notifyDataSetChanged();
            }

            public void onInvalidated() {
                super.onInvalidated();
                CampaignsMixListAdapter.this.notifyDataSetInvalidated();
            }
        });
        this.mListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (visibleItemCount > 0) {
                    CampaignsMixListAdapter.this.mMixController.trackCampaignsView(firstVisibleItem, firstVisibleItem + visibleItemCount - 1);
                }
            }
        });
        this.start();
    }

    public int getCount() {
        return this.mMixController.getCount();
    }

    public Object getItem(int position) {
        return this.mUserAdapter.getItem(this.mMixController.getUserAdapterPosition(position));
    }

    public long getItemId(int position) {
        return this.mMixController.getItemId(position);
    }

    public int getViewTypeCount() {
        return this.mMixController.getViewTypeCount();
    }

    public int getItemViewType(int position) {
        return this.mMixController.getItemViewType(position);
    }

    @Override
    public void onMixControllerUpdate() {
        this.notifyDataSetChanged();
    }

    @Override
    public int getUserAdapterCount() {
        return this.mUserAdapter.getCount();
    }

    @Override
    public long getUserAdapterItemId(int position) {
        return this.mUserAdapter.getItemId(position);
    }

    @Override
    public int getUserAdapterViewTypeCount() {
        return this.mUserAdapter.getViewTypeCount();
    }

    @Override
    public int getUserAdapterItemViewType(int position) {
        return this.mUserAdapter.getItemViewType(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (this.getItemViewType(position) == this.mMixController.getCampaignItemViewType()) {
            return this.getCampaignView(position, convertView, parent);
        }
        return this.getUserAdapterView(this.mMixController.getUserAdapterPosition(position), convertView, parent);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.getView(position, convertView, parent);
    }

    protected void start() {
        this.mListView.setAdapter((ListAdapter)this);
    }

    private View getCampaignView(int position, View convertView, ViewGroup parent) {
        Campaign item;
        CampaignItemViewHolder viewHolder = null;
        View itemView = convertView;
        if (itemView == null || !(convertView.getTag() instanceof CampaignItemViewHolder)) {
            try {
                viewHolder = this.mViewHolderClass == CampaignItemWebHolder.class ? (CampaignItemViewHolder)((Object)this.mViewHolderClass.getDeclaredConstructor(ViewGroup.class, Integer.TYPE, Integer.TYPE).newInstance(parent, this.mWebItemWidth, this.mWebItemHeight)) : (CampaignItemViewHolder)((Object)this.mViewHolderClass.getDeclaredConstructor(ViewGroup.class).newInstance(parent));
                itemView = viewHolder.itemView;
                itemView.setTag((Object)viewHolder);
            }
            catch (Exception exception) {}
        } else {
            viewHolder = (CampaignItemViewHolder)((Object)itemView.getTag());
        }
        if ((item = this.mMixController.getCampaignItem(position)) != null && viewHolder != null) {
            viewHolder.bindData(item, position);
            viewHolder.itemView.setOnClickListener((View.OnClickListener)this.mMixController.getTrackCampaignClickListener(viewHolder));
            itemView = viewHolder.itemView;
        }
        return itemView;
    }

    private View getUserAdapterView(int position, View convertView, ViewGroup parent) {
        if (convertView != null && convertView.getTag() instanceof CampaignItemViewHolder) {
            convertView = null;
        }
        return this.mUserAdapter.getView(position, convertView, parent);
    }

    public CampaignList getCampaigns() {
        return this.mMixController.getCampaigns();
    }

    public int getCurrentUnreadMessages() {
        return this.mMixController.getCurrentUnreadMessages();
    }

    public void setCampaignsListener(SimpleCallbackReceiver<CampaignList> listener) {
        this.mMixController.setCampaignsListener(listener);
    }

    public void updateCampaigns(WarplyInboxRequest campaignsRequest) {
        this.mMixController.updateCampaigns(campaignsRequest);
    }

    public static class Builder<VH extends CampaignItemViewHolder> {
        private ListView listView;
        private WarplyInboxRequest campaignsRequest;
        private Class<VH> viewHolderClass;
        private BaseAdapter userAdapter;
        private int webItemWidth = 0;
        private int webItemHeight = 0;
        private boolean isRepeatableSet = false;
        private int startPosition = 1;
        private int frequency = 5;

        public CampaignsMixListAdapter adapt() {
            return new CampaignsMixListAdapter(this);
        }

        public Builder(@NonNull ListView listView, WarplyInboxRequest campaignsRequest, BaseAdapter userAdapter) {
            this(listView, campaignsRequest, CampaignItemWebHolder.class, userAdapter);
        }

        public Builder(@NonNull ListView listView, WarplyInboxRequest campaignsRequest, BaseAdapter userAdapter, int webItemWidth, int webItemHeight) {
            this(listView, campaignsRequest, userAdapter);
            this.webItemWidth = webItemWidth;
            this.webItemHeight = webItemHeight;
        }

        public Builder(@NonNull ListView listView, WarplyInboxRequest campaignsRequest, Class<VH> viewHolderClass, @NonNull BaseAdapter userAdapter) {
            this.listView = listView;
            this.campaignsRequest = campaignsRequest;
            this.viewHolderClass = viewHolderClass;
            this.userAdapter = userAdapter;
        }

        public Builder setMixBounds(int startPosition, int frequency) {
            this.startPosition = startPosition;
            this.frequency = frequency;
            return this;
        }

        public Builder setRepeatableSet(boolean isRepeatable) {
            this.isRepeatableSet = isRepeatable;
            return this;
        }
    }
}

