/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters.mix;

import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import ly.warp.sdk.io.callbacks.SimpleCallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.request.WarplyInboxRequest;
import ly.warp.sdk.utils.constants.WarpConstants;
import ly.warp.sdk.views.CampaignItemViewHolder;
import ly.warp.sdk.views.CampaignItemWebHolder;
import ly.warp.sdk.views.adapters.mix.CampaignsMixController;

public class CampaignsMixRecyclerAdapter<VH extends CampaignItemViewHolder>
extends RecyclerView.Adapter
implements CampaignsMixController.MixControllerListener {
    private RecyclerView mRecycler;
    private Class<VH> mViewHolderClass;
    private RecyclerView.Adapter mUserAdapter;
    private CampaignsMixController mMixController;
    private int mWebItemWidth = 0;
    private int mWebItemHeight = 0;

    protected CampaignsMixRecyclerAdapter(Builder<VH> builder) {
        this.mRecycler = ((Builder)builder).recycler;
        this.mMixController = new CampaignsMixController(this.mRecycler.getContext(), ((Builder)builder).campaignsRequest, this);
        this.mMixController.setRepeatableSet(((Builder)builder).isRepeatableSet);
        this.mMixController.setMixBounds(((Builder)builder).startPosition, ((Builder)builder).frequency);
        this.mWebItemHeight = ((Builder)builder).webItemHeight;
        this.mWebItemWidth = ((Builder)builder).webItemWidth;
        this.mViewHolderClass = ((Builder)builder).viewHolderClass;
        this.mUserAdapter = ((Builder)builder).userAdapter;
        this.mUserAdapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                super.onChanged();
                CampaignsMixRecyclerAdapter.this.mMixController.resetCampaignsPositions();
                CampaignsMixRecyclerAdapter.this.notifyDataSetChanged();
            }
        });
        this.mRecycler.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                RecyclerView.LayoutManager lm = recyclerView.getLayoutManager();
                if (lm instanceof LinearLayoutManager) {
                    int firstPosition = ((LinearLayoutManager)lm).findFirstVisibleItemPosition();
                    int lastPosition = ((LinearLayoutManager)lm).findLastVisibleItemPosition();
                    CampaignsMixRecyclerAdapter.this.mMixController.trackCampaignsView(firstPosition, lastPosition);
                }
            }
        });
        this.start();
    }

    public int getItemCount() {
        return this.mMixController.getCount();
    }

    public int getItemViewType(int position) {
        return this.mMixController.getItemViewType(position);
    }

    @Override
    public void onMixControllerUpdate() {
        this.notifyDataSetChanged();
    }

    @Override
    public int getUserAdapterCount() {
        return this.mUserAdapter.getItemCount();
    }

    @Override
    public long getUserAdapterItemId(int position) {
        return this.mUserAdapter.getItemId(position);
    }

    @Override
    public int getUserAdapterViewTypeCount() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getUserAdapterItemViewType(int position) {
        return this.mUserAdapter.getItemViewType(position);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int type) {
        if (type == this.mMixController.getCampaignItemViewType()) {
            return this.createCampaignViewHolder(viewGroup);
        }
        return this.mUserAdapter.onCreateViewHolder(viewGroup, type);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        if (viewHolder instanceof CampaignItemViewHolder) {
            this.bindCampaignViewHolder((CampaignItemViewHolder)viewHolder, position);
        } else {
            this.mUserAdapter.onBindViewHolder(viewHolder, this.mMixController.getUserAdapterPosition(position));
        }
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
    }

    protected void start() {
        this.mRecycler.setAdapter((RecyclerView.Adapter)this);
    }

    private VH createCampaignViewHolder(ViewGroup viewGroup) {
        try {
            if (this.mViewHolderClass == CampaignItemWebHolder.class) {
                return (VH)((Object)((CampaignItemViewHolder)((Object)this.mViewHolderClass.getDeclaredConstructor(ViewGroup.class, Integer.TYPE, Integer.TYPE).newInstance(viewGroup, this.mWebItemWidth, this.mWebItemHeight))));
            }
            return (VH)((Object)((CampaignItemViewHolder)((Object)this.mViewHolderClass.getDeclaredConstructor(ViewGroup.class).newInstance(viewGroup))));
        }
        catch (Exception e) {
            if (WarpConstants.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private void bindCampaignViewHolder(CampaignItemViewHolder viewHolder, int position) {
        Campaign item = this.mMixController.getCampaignItem(position);
        if (viewHolder != null && item != null) {
            viewHolder.bindData(item, position);
            viewHolder.itemView.setOnClickListener((View.OnClickListener)this.mMixController.getTrackCampaignClickListener(viewHolder));
        }
    }

    public CampaignList getCampaigns() {
        return this.mMixController.getCampaigns();
    }

    public int getCurrentUnreadMessages() {
        return this.mMixController.getCurrentUnreadMessages();
    }

    public void setCampaignsListener(SimpleCallbackReceiver<CampaignList> listener) {
        this.mMixController.setCampaignsListener(listener);
    }

    public void updateCampaigns(WarplyInboxRequest campaignsRequest) {
        this.mMixController.updateCampaigns(campaignsRequest);
    }

    public static class Builder<VH extends CampaignItemViewHolder> {
        private RecyclerView recycler;
        private WarplyInboxRequest campaignsRequest;
        private Class<VH> viewHolderClass;
        private RecyclerView.Adapter userAdapter;
        private int webItemWidth = 0;
        private int webItemHeight = 0;
        private boolean isRepeatableSet = false;
        private int startPosition = 1;
        private int frequency = 5;

        public CampaignsMixRecyclerAdapter adapt() {
            return new CampaignsMixRecyclerAdapter(this);
        }

        public Builder(RecyclerView recycler, WarplyInboxRequest campaignsRequest, RecyclerView.Adapter userAdapter) {
            this(recycler, campaignsRequest, CampaignItemWebHolder.class, userAdapter);
        }

        public Builder(RecyclerView recycler, WarplyInboxRequest campaignsRequest, RecyclerView.Adapter userAdapter, int webItemWidth, int webItemHeight) {
            this(recycler, campaignsRequest, userAdapter);
            this.webItemWidth = webItemWidth;
            this.webItemHeight = webItemHeight;
        }

        public Builder(RecyclerView recycler, WarplyInboxRequest campaignsRequest, Class<VH> viewHolderClass, RecyclerView.Adapter userAdapter) {
            this.recycler = recycler;
            this.campaignsRequest = campaignsRequest;
            this.viewHolderClass = viewHolderClass;
            this.userAdapter = userAdapter;
        }

        public Builder setMixBounds(int startPosition, int frequency) {
            this.startPosition = startPosition;
            this.frequency = frequency;
            return this;
        }

        public Builder setRepeatableSet(boolean isRepeatable) {
            this.isRepeatableSet = isRepeatable;
            return this;
        }
    }
}

