/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.adapters.mix;

import android.os.AsyncTask;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.views.adapters.mix.CampaignsMixController;

public class CampaignsMixTracker {
    private CampaignsMixController mMixController;
    private int mOldFirstVisibleItem = -1;
    private HashSet<Integer> mVisibleCampaignIndexes;
    private Set<Integer> mNewCampaignIndexes;
    private Set<Integer> mUpdatedCampaignIndexes;

    public CampaignsMixTracker(@NonNull CampaignsMixController mixController) {
        this.mMixController = mixController;
        this.mVisibleCampaignIndexes = new HashSet();
        this.mNewCampaignIndexes = new HashSet<Integer>();
        this.mUpdatedCampaignIndexes = new HashSet<Integer>();
    }

    public void trackCampaignsView(int firstVisiblePosition, int lastVisibleItemPosition) {
        if (lastVisibleItemPosition >= firstVisiblePosition && this.mOldFirstVisibleItem != firstVisiblePosition) {
            this.mOldFirstVisibleItem = firstVisiblePosition;
            this.mNewCampaignIndexes.clear();
            this.mUpdatedCampaignIndexes.clear();
            for (int i = firstVisiblePosition; i < lastVisibleItemPosition + 1; ++i) {
                if (this.mMixController.getItemViewType(i) != this.mMixController.getCampaignItemViewType()) continue;
                if (this.mVisibleCampaignIndexes.add(i)) {
                    this.mNewCampaignIndexes.add(i);
                    continue;
                }
                this.mUpdatedCampaignIndexes.add(i);
            }
            this.mVisibleCampaignIndexes.clear();
            this.mVisibleCampaignIndexes.addAll(this.mUpdatedCampaignIndexes);
            this.mVisibleCampaignIndexes.addAll(this.mNewCampaignIndexes);
            if (this.mNewCampaignIndexes.size() > 0) {
                new TrackCampaignsTask(this.mNewCampaignIndexes, TrackEvent.CAMPAIGN_VIEW).execute(new Void[0]);
            }
        }
    }

    public void trackCampaignClick(Campaign campaign) {
        if (campaign != null) {
            new TrackCampaignsTask(campaign, TrackEvent.CAMPAIGN_CLICK).execute(new Void[0]);
        }
    }

    private class TrackCampaignsTask
    extends AsyncTask<Void, Void, Void> {
        private List<Campaign> mmTrackCampaigns;
        private TrackEvent mmTrackEvent;

        private TrackCampaignsTask(Set<Integer> indexes, TrackEvent event) {
            this.mmTrackEvent = event;
            if (indexes != null && indexes.size() > 0) {
                this.mmTrackCampaigns = new ArrayList<Campaign>(indexes.size());
                for (int index : indexes) {
                    Campaign camp = CampaignsMixTracker.this.mMixController.getCampaignItem(index);
                    if (camp == null) continue;
                    this.mmTrackCampaigns.add(camp);
                }
            }
        }

        private TrackCampaignsTask(Campaign campaign, TrackEvent event) {
            this.mmTrackEvent = event;
            if (campaign != null) {
                this.mmTrackCampaigns = new ArrayList<Campaign>(1);
                this.mmTrackCampaigns.add(campaign);
            }
        }

        protected Void doInBackground(Void ... params) {
            if (this.mmTrackCampaigns != null) {
                for (Campaign campaign : this.mmTrackCampaigns) {
                    WarplyAnalyticsManager.logEvent(null, this.mmTrackEvent.getTrackMessage(campaign), null);
                    WarpUtils.log("track_campaigns - " + this.mmTrackEvent.getTrackMessage(campaign) + " - " + campaign.getTitle());
                }
            }
            return null;
        }
    }

    private static enum TrackEvent {
        CAMPAIGN_VIEW("native_campaign_view"),
        CAMPAIGN_CLICK("native_campaign_click");

        private String type;

        private TrackEvent(String type) {
            this.type = type;
        }

        public String getTrackMessage(@NonNull Campaign campaign) {
            return this.type + ":" + campaign.getSessionUUID();
        }
    }
}

