/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.dialogs;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.Campaign;

public class InAppDialog {
    private static Context mContext;
    private static AlertDialog mInAppDialog;

    public static void showDefaultInAppDialog(Context context, Campaign campaignToShow, boolean showViewBtn, int v) {
        mContext = context;
        InAppDialog.showDefaultInAppDialog(context, campaignToShow, showViewBtn);
    }

    private static void showDefaultInAppDialog(final Context context, final Campaign campaignToShow, boolean showViewBtn) {
        if (mInAppDialog != null && mInAppDialog.isShowing()) {
            mInAppDialog.dismiss();
        }
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View customView = inflater.inflate(R.layout.layout_inapp_alert_dialog_default, null);
        LinearLayout customButtonsView = (LinearLayout)customView.findViewById(R.id.ll_custom_buttons_view);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 0x800005;
        ImageView campaignImage = (ImageView)customView.findViewById(R.id.iv_inapp_image);
        TextView campaignTitle = (TextView)customView.findViewById(R.id.tv_inapp_title);
        TextView campaignSubtitle = (TextView)customView.findViewById(R.id.tv_inapp_subtitle);
        ((RequestBuilder)Glide.with((Context)context).load(campaignToShow.getLogoUrl()).placeholder(R.drawable.ic_default_campaign)).into(campaignImage);
        campaignTitle.setText((CharSequence)campaignToShow.getTitle());
        campaignSubtitle.setText((CharSequence)campaignToShow.getSubtitle());
        if (showViewBtn) {
            String[] items = new String[]{"View", "Close"};
            TextView viewBtn = new TextView(context);
            viewBtn.setId(0);
            viewBtn.setTag((Object)items[0]);
            viewBtn.setText((CharSequence)items[0]);
            viewBtn.setTextAppearance(context, R.style.InAppButtonsStyle);
            viewBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    context.startActivity(WarpViewActivity.createIntentFromSessionUUID(mContext, campaignToShow.getSessionUUID()));
                    mInAppDialog.dismiss();
                }
            });
            customButtonsView.addView((View)viewBtn, (ViewGroup.LayoutParams)params);
            mInAppDialog = new AlertDialog.Builder(context).setView(customView).create();
            mInAppDialog.show();
        }
    }
}

