/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.dialogs;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import java.util.Date;
import ly.warp.sdk.views.dialogs.OnClickButtonListener;
import ly.warp.sdk.views.dialogs.RateDialogManager;
import ly.warp.sdk.views.dialogs.RateDialogOptions;
import ly.warp.sdk.views.dialogs.RatePreferenceHelper;

public class RateDialog {
    private static RateDialog singleton;
    private Context context;
    private final RateDialogOptions options = new RateDialogOptions();
    private int installDate = -1;
    private int launchTimes = -1;
    private int remindInterval = 1;
    private int eventsTimes = -1;
    private boolean isDebug = false;

    public RateDialog(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RateDialog with(Context context) {
        if (singleton != null) return singleton;
        Class<RateDialog> clazz = RateDialog.class;
        synchronized (RateDialog.class) {
            if (singleton != null) return singleton;
            singleton = new RateDialog(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public void launch() {
        if (RatePreferenceHelper.isFirstLaunch(this.context)) {
            RatePreferenceHelper.setInstallDate(this.context);
        }
        RatePreferenceHelper.setLaunchTimes(this.context, RatePreferenceHelper.getLaunchTimes(this.context) + 1);
    }

    public static boolean showRateDialogIfMeetsConditions(Activity activity) {
        boolean isMeetsConditions;
        boolean bl = isMeetsConditions = RateDialog.singleton.isDebug || singleton.shouldShowRateDialog();
        if (isMeetsConditions) {
            singleton.showRateDialog(activity);
        }
        return isMeetsConditions;
    }

    public static boolean passSignificantEventAndConditions(Activity activity) {
        return RateDialog.passSignificantEvent(activity, singleton.shouldShowRateDialog());
    }

    private static boolean passSignificantEvent(Activity activity, boolean shouldShow) {
        boolean isMeetsConditions;
        int eventTimes = RatePreferenceHelper.getEventTimes((Context)activity);
        RatePreferenceHelper.setEventTimes((Context)activity, ++eventTimes);
        boolean bl = isMeetsConditions = RateDialog.singleton.isDebug || singleton.isOverEventTimes() && shouldShow;
        if (isMeetsConditions) {
            singleton.showRateDialog(activity);
        }
        return isMeetsConditions;
    }

    public RateDialog clearPreferenceSettings() {
        RatePreferenceHelper.setAgreeShowDialog(this.context, true);
        RatePreferenceHelper.clearSharedPreferences(this.context);
        return this;
    }

    private static boolean isOverDate(long targetDate, int threshold) {
        return new Date().getTime() - targetDate >= (long)(threshold * 24 * 60 * 60 * 1000);
    }

    public boolean shouldShowRateDialog() {
        return RatePreferenceHelper.getIsAgreeShowDialog(this.context) && this.isOverLaunchTimes() && this.isOverInstallDate() && this.isOverIntervalDate();
    }

    public boolean isOverInstallDate() {
        if (this.installDate == -1) {
            return true;
        }
        return RateDialog.isOverDate(RatePreferenceHelper.getInstallDate(this.context), this.installDate);
    }

    public boolean isOverIntervalDate() {
        return RateDialog.isOverDate(RatePreferenceHelper.getRemindIntervalDate(this.context), this.remindInterval);
    }

    public boolean isOverLaunchTimes() {
        if (this.launchTimes == -1) {
            return true;
        }
        return RatePreferenceHelper.getLaunchTimes(this.context) >= this.launchTimes;
    }

    public boolean isOverEventTimes() {
        if (this.eventsTimes == -1) {
            return true;
        }
        return RatePreferenceHelper.getEventTimes(this.context) >= this.launchTimes;
    }

    public RateDialog setInstallDate(int installDate) {
        this.installDate = installDate;
        return this;
    }

    public RateDialog setLaunchTimes(int launchTimes) {
        this.launchTimes = launchTimes;
        return this;
    }

    public RateDialog setRemindInterval(int remindInterval) {
        this.remindInterval = remindInterval;
        return this;
    }

    public RateDialog setEventsTimes(int eventsTimes) {
        this.eventsTimes = eventsTimes;
        return this;
    }

    public RateDialog setShowNeutralButton(boolean isShowNeutralButton) {
        this.options.setShowNeutralButton(isShowNeutralButton);
        return this;
    }

    public RateDialog setShowTitle(boolean isShowTitle) {
        this.options.setShowTitle(isShowTitle);
        return this;
    }

    public RateDialog setView(View view) {
        this.options.setView(view);
        return this;
    }

    public RateDialog setOnClickButtonListener(OnClickButtonListener listener) {
        this.options.setListener(listener);
        return this;
    }

    public RateDialog setTitle(int resourceId) {
        this.options.setTitleResId(resourceId);
        return this;
    }

    public RateDialog setTitle(String title) {
        this.options.setTitleText(title);
        return this;
    }

    public RateDialog setMessage(int resourceId) {
        this.options.setMessageResId(resourceId);
        return this;
    }

    public RateDialog setMessage(String message) {
        this.options.setMessageText(message);
        return this;
    }

    public RateDialog setTextPositive(int resourceId) {
        this.options.setTextPositiveResId(resourceId);
        return this;
    }

    public RateDialog setTextPositive(String positiveText) {
        this.options.setPositiveText(positiveText);
        return this;
    }

    public RateDialog setTextNeutral(int resourceId) {
        this.options.setTextNeutralResId(resourceId);
        return this;
    }

    public RateDialog setTextNeutral(String neutralText) {
        this.options.setNeutralText(neutralText);
        return this;
    }

    public RateDialog setTextNegative(int resourceId) {
        this.options.setTextNegativeResId(resourceId);
        return this;
    }

    public RateDialog setTextNegative(String negativeText) {
        this.options.setNegativeText(negativeText);
        return this;
    }

    public RateDialog setCancelable(boolean cancelable) {
        this.options.setCancelable(cancelable);
        return this;
    }

    public RateDialog setPackageType(String packageType) {
        this.options.setPackageType(packageType);
        return this;
    }

    public RateDialog setPackageId(String packageId) {
        this.options.setPackageId(packageId);
        return this;
    }

    public RateDialog setDialogStyle(int style2) {
        this.options.setDialogStyleResId(style2);
        return this;
    }

    public RateDialog setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
        return this;
    }

    public void showRateDialog(Activity activity) {
        if (!activity.isFinishing()) {
            RateDialogManager.with((Context)activity).create(this.options).show();
        }
    }
}

