/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.dialogs;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import androidx.appcompat.app.AlertDialog;
import ly.warp.sdk.views.dialogs.IntentHelper;
import ly.warp.sdk.views.dialogs.OnClickButtonListener;
import ly.warp.sdk.views.dialogs.RateDialogOptions;
import ly.warp.sdk.views.dialogs.RatePreferenceHelper;

final class RateDialogManager {
    private static RateDialogManager singleton;
    private static Context context;
    static Dialog dialog;

    private RateDialogManager() {
    }

    private RateDialogManager(Context context) {
        RateDialogManager.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RateDialogManager with(Context context) {
        if (singleton != null) return singleton;
        Class<RateDialogManager> clazz = RateDialogManager.class;
        synchronized (RateDialogManager.class) {
            if (singleton != null) return singleton;
            singleton = new RateDialogManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public RateDialogManager create(RateDialogOptions options) {
        if (dialog != null) {
            return this;
        }
        dialog = Build.VERSION.SDK_INT < 11 ? RateDialogManager.createDialog(context, options) : RateDialogManager.createMaterialDialog(context, options);
        return this;
    }

    public void show() {
        if (Build.VERSION.SDK_INT < 11) {
            RateDialogManager.showDialog();
        } else {
            RateDialogManager.showMaterialDialog();
        }
    }

    private static void showDialog() {
        android.app.AlertDialog alertDialog = (android.app.AlertDialog)dialog;
        alertDialog.show();
        try {
            Button button = alertDialog.getButton(-1);
            LinearLayout linearLayout = (LinearLayout)button.getParent();
            linearLayout.setOrientation(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void showMaterialDialog() {
        AlertDialog alertDialog = (AlertDialog)dialog;
        alertDialog.show();
        try {
            Button button = alertDialog.getButton(-1);
            LinearLayout linearLayout = (LinearLayout)button.getParent();
            linearLayout.setOrientation(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static AlertDialog.Builder getDialogBuilder(Context context) {
        return new AlertDialog.Builder(context);
    }

    private static AlertDialog.Builder getMaterialDialogBuilder(Context context, RateDialogOptions options) {
        return new AlertDialog.Builder(context, options.getDialogStyleResId());
    }

    private static Dialog createDialog(final Context context, final RateDialogOptions options) {
        AlertDialog.Builder builder = RateDialogManager.getDialogBuilder(context);
        builder.setMessage((CharSequence)options.getMessageText(context));
        if (options.shouldShowTitle()) {
            builder.setTitle((CharSequence)options.getTitleText(context));
        }
        builder.setCancelable(options.getCancelable());
        View view = options.getView();
        if (view != null) {
            builder.setView(view);
        }
        final OnClickButtonListener listener = options.getListener();
        builder.setPositiveButton((CharSequence)options.getPositiveText(context), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intentToAppstore = null;
                if (options.getPackageType() == "Google") {
                    intentToAppstore = IntentHelper.createIntentForGooglePlay(context);
                }
                context.startActivity(intentToAppstore);
                RatePreferenceHelper.setAgreeShowDialog(context, false);
                if (listener != null) {
                    listener.onClickButton(which);
                }
            }
        });
        if (options.shouldShowNeutralButton()) {
            builder.setNeutralButton((CharSequence)options.getNeutralText(context), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    RatePreferenceHelper.setRemindIntervalDate(context);
                    if (listener != null) {
                        listener.onClickButton(which);
                    }
                }
            });
        }
        builder.setNegativeButton((CharSequence)options.getNegativeText(context), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RatePreferenceHelper.setAgreeShowDialog(context, false);
                if (listener != null) {
                    listener.onClickButton(which);
                }
            }
        });
        return builder.create();
    }

    private static Dialog createMaterialDialog(final Context context, final RateDialogOptions options) {
        AlertDialog.Builder builder = RateDialogManager.getMaterialDialogBuilder(context, options);
        builder.setMessage((CharSequence)options.getMessageText(context));
        if (options.shouldShowTitle()) {
            builder.setTitle((CharSequence)options.getTitleText(context));
        }
        builder.setCancelable(options.getCancelable());
        View view = options.getView();
        if (view != null) {
            builder.setView(view);
        }
        final OnClickButtonListener listener = options.getListener();
        builder.setPositiveButton((CharSequence)options.getPositiveText(context), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intentToAppstore = null;
                if (options.getPackageType() == "Google") {
                    intentToAppstore = IntentHelper.createIntentForGooglePlay(context);
                }
                context.startActivity(intentToAppstore);
                RatePreferenceHelper.setAgreeShowDialog(context, false);
                if (listener != null) {
                    listener.onClickButton(which);
                }
            }
        });
        if (options.shouldShowNeutralButton()) {
            builder.setNeutralButton((CharSequence)options.getNeutralText(context), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    RatePreferenceHelper.setRemindIntervalDate(context);
                    if (listener != null) {
                        listener.onClickButton(which);
                    }
                }
            });
        }
        builder.setNegativeButton((CharSequence)options.getNegativeText(context), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RatePreferenceHelper.setAgreeShowDialog(context, false);
                if (listener != null) {
                    listener.onClickButton(which);
                }
            }
        });
        return builder.create();
    }

    static {
        dialog = null;
    }
}

