/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.views.dialogs;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.Date;

final class RatePreferenceHelper {
    private static final String PREF_FILE_NAME = "ratedialog_rate_pref_file";
    private static final String PREF_KEY_INSTALL_DATE = "ratedialog_rate_install_date";
    private static final String PREF_KEY_LAUNCH_TIMES = "ratedialog_rate_launch_times";
    private static final String PREF_KEY_IS_AGREE_SHOW_DIALOG = "ratedialog_rate_is_agree_show_dialog";
    private static final String PREF_KEY_REMIND_INTERVAL = "ratedialog_rate_remind_interval";
    private static final String PREF_KEY_EVENT_TIMES = "ratedialog_rate_event_times";

    private RatePreferenceHelper() {
    }

    static SharedPreferences getPreferences(Context context) {
        return context.getSharedPreferences(PREF_FILE_NAME, 0);
    }

    static SharedPreferences.Editor getPreferencesEditor(Context context) {
        return RatePreferenceHelper.getPreferences(context).edit();
    }

    static void clearSharedPreferences(Context context) {
        SharedPreferences.Editor editor = RatePreferenceHelper.getPreferencesEditor(context);
        editor.remove(PREF_KEY_INSTALL_DATE);
        editor.remove(PREF_KEY_LAUNCH_TIMES);
        editor.remove(PREF_KEY_REMIND_INTERVAL);
        editor.remove(PREF_KEY_EVENT_TIMES);
        editor.apply();
    }

    static void setAgreeShowDialog(Context context, boolean isAgree) {
        SharedPreferences.Editor editor = RatePreferenceHelper.getPreferencesEditor(context);
        editor.putBoolean(PREF_KEY_IS_AGREE_SHOW_DIALOG, isAgree);
        editor.apply();
    }

    static boolean getIsAgreeShowDialog(Context context) {
        return RatePreferenceHelper.getPreferences(context).getBoolean(PREF_KEY_IS_AGREE_SHOW_DIALOG, true);
    }

    static void setRemindIntervalDate(Context context) {
        SharedPreferences.Editor editor = RatePreferenceHelper.getPreferencesEditor(context);
        editor.remove(PREF_KEY_REMIND_INTERVAL);
        editor.putLong(PREF_KEY_REMIND_INTERVAL, new Date().getTime());
        editor.apply();
    }

    static long getRemindIntervalDate(Context context) {
        return RatePreferenceHelper.getPreferences(context).getLong(PREF_KEY_REMIND_INTERVAL, 0L);
    }

    static void setInstallDate(Context context) {
        SharedPreferences.Editor editor = RatePreferenceHelper.getPreferencesEditor(context);
        editor.putLong(PREF_KEY_INSTALL_DATE, new Date().getTime());
        editor.apply();
    }

    static long getInstallDate(Context context) {
        return RatePreferenceHelper.getPreferences(context).getLong(PREF_KEY_INSTALL_DATE, 0L);
    }

    static void setLaunchTimes(Context context, int launchTimes) {
        SharedPreferences.Editor editor = RatePreferenceHelper.getPreferencesEditor(context);
        editor.putInt(PREF_KEY_LAUNCH_TIMES, launchTimes);
        editor.apply();
    }

    static int getLaunchTimes(Context context) {
        return RatePreferenceHelper.getPreferences(context).getInt(PREF_KEY_LAUNCH_TIMES, 0);
    }

    static boolean isFirstLaunch(Context context) {
        return RatePreferenceHelper.getPreferences(context).getLong(PREF_KEY_INSTALL_DATE, 0L) == 0L;
    }

    static int getEventTimes(Context context) {
        return RatePreferenceHelper.getPreferences(context).getInt(PREF_KEY_EVENT_TIMES, 0);
    }

    static void setEventTimes(Context context, int eventTimes) {
        SharedPreferences.Editor editor = RatePreferenceHelper.getPreferencesEditor(context);
        editor.putInt(PREF_KEY_EVENT_TIMES, eventTimes);
        editor.apply();
    }
}

