/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.bean.operation;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.mc4j.ems.connection.EmsInvocationException;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.mc4j.ems.connection.bean.parameter.EmsParameter;
import org.mc4j.ems.impl.jmx.connection.bean.DMBean;
import org.mc4j.ems.impl.jmx.connection.bean.parameter.DParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOperation
implements EmsOperation {
    protected MBeanOperationInfo info;
    protected DMBean bean;
    public static final int MAX_EXECUTION_TIME = 10000;
    protected List<EmsParameter> parameters = new ArrayList<EmsParameter>();
    protected EmsOperation.Impact impact;

    public DOperation(MBeanOperationInfo info, DMBean bean) {
        MBeanParameterInfo[] params;
        this.info = info;
        this.bean = bean;
        for (MBeanParameterInfo param : params = info.getSignature()) {
            this.parameters.add(new DParameter(param));
        }
        switch (info.getImpact()) {
            case 1: {
                this.impact = EmsOperation.Impact.ACTION;
                break;
            }
            case 0: {
                this.impact = EmsOperation.Impact.INFO;
                break;
            }
            case 2: {
                this.impact = EmsOperation.Impact.ACTION_INFO;
                break;
            }
            default: {
                this.impact = EmsOperation.Impact.UNKNOWN;
            }
        }
    }

    public String getName() {
        return this.info.getName();
    }

    public String getDescription() {
        return this.info.getDescription();
    }

    public List<EmsParameter> getParameters() {
        return this.parameters;
    }

    public EmsOperation.Impact getImpact() {
        return this.impact;
    }

    public String getReturnType() {
        return this.info.getReturnType();
    }

    public Object invoke(Object ... parameters) throws EmsInvocationException {
        MBeanParameterInfo[] parameterInfos = this.info.getSignature();
        Object[] parameterValues = new Object[parameterInfos.length];
        String[] parameterTypes = new String[parameterInfos.length];
        int i = 0;
        for (Object param : parameters) {
            String name = parameterInfos[i].getName();
            parameterValues[i] = param;
            parameterTypes[i] = parameterInfos[i].getType();
            ++i;
        }
        try {
            Object results = this.bean.getConnectionProvider().getMBeanServer().invoke(this.bean.getObjectName(), this.getName(), parameterValues, parameterTypes);
            return results;
        }
        catch (ReflectionException re) {
            Exception cause = re.getTargetException();
            if (cause != null) {
                throw new EmsInvocationException("Exception on invocation of [" + this.getName() + "]" + cause.toString(), (Throwable)cause);
            }
            throw new EmsInvocationException("Exception on invocation of [" + this.getName() + "]" + re.toString(), (Throwable)re);
        }
        catch (Exception e) {
            throw new EmsInvocationException("Exception on invocation of [" + this.getName() + "]" + e.toString(), (Throwable)e);
        }
    }

    public int compareTo(Object o) {
        DOperation otherOperation = (DOperation)o;
        int i = this.getName().compareTo(otherOperation.getName());
        if (i == 0 && (i = Integer.valueOf(this.parameters.size()).compareTo(otherOperation.getParameters().size())) == 0) {
            for (int j = 0; j < this.parameters.size() && (i = this.parameters.get(j).compareTo((Object)otherOperation.getParameters().get(j))) == 0; ++j) {
            }
        }
        return i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DOperation)) {
            return false;
        }
        DOperation that = (DOperation)o;
        if (this.info != null ? !this.info.getName().equals(that.info.getName()) : that.info.getName() != null) {
            return false;
        }
        return !(this.parameters != null ? !((Object)this.parameters).equals(that.parameters) : that.parameters != null);
    }

    public int hashCode() {
        int result = this.info != null ? this.info.hashCode() : 0;
        result = 31 * result + (this.parameters != null ? ((Object)this.parameters).hashCode() : 0);
        return result;
    }
}

