/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.support.providers.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import org.mc4j.ems.impl.jmx.connection.support.providers.proxy.StatsProxy;

public class JMXRemotingMBeanServerProxy
implements InvocationHandler,
StatsProxy {
    private MBeanServerConnection remoteServer;
    private long roundTrips;
    private long failures;
    private static final Class[] INTERFACES = new Class[]{MBeanServer.class};

    public JMXRemotingMBeanServerProxy(MBeanServerConnection remoteServer) {
        this.remoteServer = remoteServer;
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Class<MBeanServerConnection> serverClass = MBeanServerConnection.class;
        Method method = serverClass.getMethod(m.getName(), m.getParameterTypes());
        try {
            ++this.roundTrips;
            return method.invoke((Object)this.remoteServer, args);
        }
        catch (InvocationTargetException ite) {
            ++this.failures;
            Throwable t = ite.getTargetException();
            if (t != null) {
                throw t;
            }
            throw ite;
        }
    }

    public MBeanServer buildServerProxy() {
        Object proxy = Proxy.newProxyInstance(JMXRemotingMBeanServerProxy.class.getClassLoader(), INTERFACES, (InvocationHandler)this);
        return (MBeanServer)proxy;
    }

    public long getRoundTrips() {
        return this.roundTrips;
    }

    public long getFailures() {
        return this.failures;
    }
}

