/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.support.providers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionException;
import org.mc4j.ems.impl.jmx.connection.support.providers.AbstractConnectionProvider;
import org.mc4j.ems.impl.jmx.connection.support.providers.proxy.GenericMBeanServerProxy;

public class JBossConnectionProvider
extends AbstractConnectionProvider {
    private MBeanServer mbeanServer;
    private GenericMBeanServerProxy proxy;
    private static final String MEJB_JNDI = "ejb/mgmt/MEJB";
    private static Log log = LogFactory.getLog((Class)JBossConnectionProvider.class);
    public static final String JNDI_LOGIN_CONTEXT_FACTORY_CLASS = "org.jboss.security.jndi.JndiLoginInitialContextFactory";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$security$Principal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnect() throws Exception {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            System.setProperty("jmx.serial.form", "1.1");
            ClassLoader childLoader = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(childLoader);
            InitialContext context = this.getInitialContext();
            Object rmiAdaptor = context.lookup(this.connectionSettings.getJndiName());
            if (this.proxy != null) {
                this.proxy.setRemoteServer(rmiAdaptor);
            } else {
                this.proxy = new GenericMBeanServerProxy(rmiAdaptor);
                this.proxy.setProvider(this);
                this.setStatsProxy(this.proxy);
                this.mbeanServer = this.proxy.buildServerProxy();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    private InitialContext getInitialContext() throws NamingException {
        Properties props = this.connectionSettings.getAdvancedProperties();
        if (this.connectionSettings.getPrincipal() != null && this.connectionSettings.getPrincipal().length() != 0) {
            try {
                Class.forName(JNDI_LOGIN_CONTEXT_FACTORY_CLASS);
                log.debug((Object)"Utilizing JNDI Login Context Factory for secured access [org.jboss.security.jndi.JndiLoginInitialContextFactory]");
                props.put("java.naming.factory.initial", JNDI_LOGIN_CONTEXT_FACTORY_CLASS);
                props.put("java.naming.security.principal", this.connectionSettings.getPrincipal());
                props.put("java.naming.security.credentials", this.connectionSettings.getCredentials());
            }
            catch (ClassNotFoundException e) {
                log.debug((Object)"JNDI Login Context Factory not available, directly utilizing SecurityAssociation");
                try {
                    props.put("java.naming.factory.initial", this.connectionSettings.getInitialContextName());
                    this.resetPrincipalInfo();
                }
                catch (ClassNotFoundException e1) {
                    throw new ConnectionException("Secured connection not available with this version of JBoss " + e1.toString(), (Throwable)e1);
                }
                catch (Exception e1) {
                    throw new ConnectionException("Unable to make secured connection to JBoss due to missing or unexpected security classes", (Throwable)e1);
                }
            }
        } else {
            props.put("java.naming.factory.initial", this.connectionSettings.getInitialContextName());
        }
        props.put("java.naming.provider.url", this.connectionSettings.getServerUrl());
        try {
            InitialContext context = new InitialContext(props);
            return context;
        }
        catch (NoInitialContextException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw new ConnectionException("Necessary classes not found for remote connection, check installation path configuration.", e.getCause());
            }
            throw e;
        }
    }

    public void doDisconnect() {
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public void resetPrincipalInfo() throws Exception {
        Class<?> simplePrincipalClass = Class.forName("org.jboss.security.SimplePrincipal");
        Principal principal = (Principal)simplePrincipalClass.getConstructor(String.class).newInstance(this.getConnectionSettings().getPrincipal());
        SetPrincipalInfoAction.setPrincipalInfo(principal, this.getConnectionSettings().getCredentials());
    }

    private static class SetPrincipalInfoAction
    implements PrivilegedAction {
        Principal principal;
        Object credential;

        public SetPrincipalInfoAction(Principal principal, Object credential) {
            this.principal = principal;
            this.credential = credential;
        }

        public Object run() {
            try {
                Class<?> saClass = Class.forName("org.jboss.security.SecurityAssociation");
                Method setCredentialMethod = saClass.getMethod("setCredential", class$java$lang$Object == null ? (class$java$lang$Object = JBossConnectionProvider.class$("java.lang.Object")) : class$java$lang$Object);
                setCredentialMethod.invoke(null, this.credential);
                this.credential = null;
                Method setPrincipleMethod = saClass.getMethod("setPrincipal", class$java$security$Principal == null ? (class$java$security$Principal = JBossConnectionProvider.class$("java.security.Principal")) : class$java$security$Principal);
                setPrincipleMethod.invoke(null, this.principal);
                this.principal = null;
                return null;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }

        static void setPrincipalInfo(Principal principal, Object credential) {
            SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential);
            AccessController.doPrivileged(action);
        }
    }
}

