/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.core.autoconfigure;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import java.io.File;
import me.snowdrop.boot.narayana.core.properties.NarayanaProperties;
import me.snowdrop.boot.narayana.core.properties.NarayanaPropertiesInitializer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.autoconfigure.transaction.jta.JtaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.StringUtils;

public abstract class AbstractNarayanaConfiguration {
    private final JtaProperties jtaProperties;
    private final TransactionManagerCustomizers transactionManagerCustomizers;

    public AbstractNarayanaConfiguration(JtaProperties jtaProperties, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        this.jtaProperties = jtaProperties;
        this.transactionManagerCustomizers = (TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public NarayanaPropertiesInitializer narayanaPropertiesInitializer(NarayanaProperties properties) {
        if (StringUtils.isEmpty((Object)properties.getLogDir())) {
            properties.setLogDir(this.getLogDir().getAbsolutePath());
        }
        if (this.jtaProperties.getTransactionManagerId() != null) {
            properties.setTransactionManagerId(this.jtaProperties.getTransactionManagerId());
        }
        return new NarayanaPropertiesInitializer(properties);
    }

    @Bean
    @DependsOn(value={"narayanaPropertiesInitializer"})
    @ConditionalOnMissingBean
    public javax.transaction.UserTransaction narayanaUserTransaction() {
        return UserTransaction.userTransaction();
    }

    @Bean
    @DependsOn(value={"narayanaPropertiesInitializer"})
    @ConditionalOnMissingBean
    public javax.transaction.TransactionManager narayanaTransactionManager() {
        return TransactionManager.transactionManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public JtaTransactionManager transactionManager(javax.transaction.UserTransaction userTransaction, javax.transaction.TransactionManager transactionManager) {
        JtaTransactionManager jtaTransactionManager = new JtaTransactionManager(userTransaction, transactionManager);
        if (this.transactionManagerCustomizers != null) {
            this.transactionManagerCustomizers.customize((PlatformTransactionManager)jtaTransactionManager);
        }
        return jtaTransactionManager;
    }

    @Bean(destroyMethod="stop")
    @DependsOn(value={"narayanaPropertiesInitializer"})
    @ConditionalOnMissingBean
    public RecoveryManagerService recoveryManagerService() {
        RecoveryManager.delayRecoveryManagerThread();
        RecoveryManagerService recoveryManagerService = new RecoveryManagerService();
        recoveryManagerService.create();
        recoveryManagerService.start();
        return recoveryManagerService;
    }

    @Bean
    @DependsOn(value={"recoveryManagerService"})
    @ConditionalOnMissingBean
    public XARecoveryModule xaRecoveryModule() {
        return XARecoveryModule.getRegisteredXARecoveryModule();
    }

    protected abstract File getLogDir();
}

