/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.core.jdbc;

import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import me.snowdrop.boot.narayana.core.jdbc.DataSourceXAResourceRecoveryHelper;
import me.snowdrop.boot.narayana.core.jdbc.NarayanaDataSource;
import me.snowdrop.boot.narayana.core.properties.NarayanaProperties;

public class NarayanaXADataSourceWrapper {
    private final NarayanaProperties properties;
    private final XARecoveryModule xaRecoveryModule;

    public NarayanaXADataSourceWrapper(NarayanaProperties properties, XARecoveryModule xaRecoveryModule) {
        this.properties = properties;
        this.xaRecoveryModule = xaRecoveryModule;
    }

    public DataSource wrapDataSource(XADataSource dataSource) {
        XAResourceRecoveryHelper recoveryHelper = this.getRecoveryHelper(dataSource);
        this.xaRecoveryModule.addXAResourceRecoveryHelper(recoveryHelper);
        return new NarayanaDataSource(dataSource);
    }

    private XAResourceRecoveryHelper getRecoveryHelper(XADataSource dataSource) {
        if (this.properties.getRecoveryDbUser() == null && this.properties.getRecoveryDbPass() == null) {
            return new DataSourceXAResourceRecoveryHelper(dataSource);
        }
        return new DataSourceXAResourceRecoveryHelper(dataSource, this.properties.getRecoveryDbUser(), this.properties.getRecoveryDbPass());
    }
}

