/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.openshift.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.snowdrop.boot.narayana.openshift.recovery.PodStatus;
import me.snowdrop.boot.narayana.openshift.recovery.PodStatusManager;
import me.snowdrop.boot.narayana.openshift.recovery.ServiceShutdownController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarayanaRecoveryTerminationController {
    private static final Logger LOG = LoggerFactory.getLogger(NarayanaRecoveryTerminationController.class);
    private PodStatusManager podStatusManager;
    private List<ServiceShutdownController> shutdownHooks;

    public NarayanaRecoveryTerminationController(PodStatusManager podStatusManager, List<ServiceShutdownController> shutdownControllers) {
        this.podStatusManager = Objects.requireNonNull(podStatusManager, "podStatusManager cannot be null");
        this.shutdownHooks = Objects.requireNonNull(shutdownControllers, "shutdownControllers cannot be null");
    }

    public void start() {
        LOG.info("Narayana recovery termination controller started");
        this.podStatusManager.setStatus(PodStatus.RUNNING);
    }

    public void stop() {
        try {
            this.waitForShutdownControllersToStop();
            LOG.info("Performing transaction recovery scan...");
            RecoveryManager.manager().scan();
            LOG.info("Performing second run of transaction recovery scan...");
            RecoveryManager.manager().scan();
            List<Uid> pendingUids = this.getPendingUids();
            if (pendingUids.isEmpty()) {
                LOG.info("There are no pending transactions left");
                this.podStatusManager.setStatus(PodStatus.STOPPED);
            } else {
                LOG.warn("There are pending transactions: {}", pendingUids);
                this.podStatusManager.setStatus(PodStatus.PENDING);
            }
        }
        catch (Exception ex) {
            LOG.error("Error while cleaning transaction subsystem", (Throwable)ex);
        }
    }

    private void waitForShutdownControllersToStop() throws InterruptedException {
        for (ServiceShutdownController hook : this.shutdownHooks) {
            hook.stop();
        }
        LOG.info("All service shutdown hooks stopped");
    }

    private List<Uid> getPendingUids() throws Exception {
        InputObjectState types = new InputObjectState();
        StoreManager.getRecoveryStore().allTypes(types);
        ArrayList<Uid> allUIDs = new ArrayList<Uid>();
        String typeName = types.unpackString();
        while (typeName != null && typeName.compareTo("") != 0) {
            List<Uid> uids = this.getPendingUids(typeName);
            if (uids.isEmpty()) {
                LOG.debug("Found {} UIDs for action type {}", (Object)0, (Object)typeName);
            } else {
                LOG.warn("Found {} UIDs for action type {}", (Object)uids.size(), (Object)typeName);
            }
            allUIDs.addAll(uids);
            typeName = types.unpackString();
        }
        return allUIDs;
    }

    private List<Uid> getPendingUids(String type) throws Exception {
        ArrayList<Uid> uidList = new ArrayList<Uid>();
        InputObjectState uids = new InputObjectState();
        if (!StoreManager.getRecoveryStore().allObjUids(type, uids)) {
            throw new RuntimeException("Cannot obtain pending Uids");
        }
        if (uids.notempty()) {
            Uid u;
            do {
                u = UidHelper.unpackFrom((InputBuffer)uids);
                if (!Uid.nullUid().notEquals(u)) continue;
                uidList.add(u);
            } while (Uid.nullUid().notEquals(u));
        }
        return uidList;
    }
}

