/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring;

import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ConfigurationException;
import org.mule.config.i18n.Message;
import org.mule.extras.spring.config.ReaderInputStream;
import org.mule.impl.container.AbstractContainerContext;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.RecoverableException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.util.ClassHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class SpringContainerContext
extends AbstractContainerContext
implements BeanFactoryAware {
    public static final String SPRING_DOCTYPE_REF = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE beans PUBLIC \"-//SPRING//DTD BEAN//EN\" \"http://www.springframework.org/dtd/spring-beans.dtd\">\n";
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$extras$spring$SpringContainerContext == null ? (class$org$mule$extras$spring$SpringContainerContext = SpringContainerContext.class$("org.mule.extras.spring.SpringContainerContext")) : class$org$mule$extras$spring$SpringContainerContext));
    protected BeanFactory beanFactory;
    protected BeanFactory externalBeanFactory;
    protected String configFile;
    static /* synthetic */ Class class$org$mule$extras$spring$SpringContainerContext;

    public SpringContainerContext() {
        super("spring");
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setExternalBeanFactory(BeanFactory factory) {
        this.externalBeanFactory = factory;
    }

    public BeanFactory getBeanFactory() {
        if (this.externalBeanFactory != null) {
            return this.externalBeanFactory;
        }
        return this.beanFactory;
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        if (this.getBeanFactory() == null) {
            throw new IllegalStateException("Spring Application context has not been set");
        }
        if (key == null) {
            throw new ObjectNotFoundException("Component not found for null key");
        }
        if (key instanceof Class) {
            throw new ObjectNotFoundException("The container is unable to build single instance of " + ((Class)key).getName() + " number of instances found was: 0");
        }
        try {
            return this.getBeanFactory().getBean(key.toString());
        }
        catch (BeansException e) {
            throw new ObjectNotFoundException("Component not found for key: " + key.toString(), (Throwable)e);
        }
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) throws ConfigurationException {
        this.configFile = configFile;
    }

    public void configure(Reader configuration) throws ContainerException {
        XmlBeanFactory bf = new XmlBeanFactory((Resource)new InputStreamResource((InputStream)new ReaderInputStream(configuration)));
        this.setExternalBeanFactory((BeanFactory)bf);
    }

    protected String getDefaultDocType() {
        return "beans PUBLIC \"-//SPRING//DTD BEAN//EN\" \"http://www.springframework.org/dtd/spring-beans.dtd\"";
    }

    public void initialise() throws InitialisationException, RecoverableException {
        if (this.configFile == null) {
            return;
        }
        try {
            if (ClassHelper.getResource((String)this.configFile, ((Object)((Object)this)).getClass()) == null) {
                logger.warn((Object)("Spring config resource: " + this.configFile + " not found on class path, attempting to load it from local file"));
                this.setExternalBeanFactory((BeanFactory)new FileSystemXmlApplicationContext(this.configFile));
            } else {
                logger.info((Object)("Loading Spring config from classpath, resource is: " + this.configFile));
                this.setExternalBeanFactory((BeanFactory)new ClassPathXmlApplicationContext(this.configFile));
            }
        }
        catch (BeansException e) {
            throw new InitialisationException((Throwable)new ConfigurationException(new Message(58, (Object)("Application Context: " + this.configFile)), (Throwable)e), (Object)this);
        }
    }

    public void dispose() {
        if (this.externalBeanFactory instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.externalBeanFactory).close();
        }
        super.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

