/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;

public class JdbcConnector
extends AbstractServiceEnabledConnector {
    private long pollingFrequency = 0L;
    private DataSource dataSource;
    private String dataSourceJndiName;
    private Context jndiContext;
    private String jndiInitialFactory;
    private String jndiProviderUrl;
    private Map providerProperties;
    private Map queries;

    public String getProtocol() {
        return "jdbc";
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        Object[] params = this.getReadAndAckStatements(endpoint.getEndpointURI(), endpoint);
        return this.getServiceDescriptor().createMessageReceiver((UMOConnector)this, component, endpoint, params);
    }

    protected void initJndiContext() throws NamingException {
        if (this.jndiContext == null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.jndiInitialFactory != null) {
                props.put("java.naming.factory.initial", this.jndiInitialFactory);
            }
            if (this.jndiProviderUrl != null) {
                props.put("java.naming.provider.url", this.jndiProviderUrl);
            }
            if (this.providerProperties != null) {
                props.putAll(this.providerProperties);
            }
            this.jndiContext = new InitialContext(props);
        }
    }

    protected void createDataSource() throws InitialisationException, NamingException {
        Object temp = this.jndiContext.lookup(this.dataSourceJndiName);
        if (!(temp instanceof DataSource)) {
            throw new InitialisationException(new Message(121, (Object)this.dataSourceJndiName), (Object)this);
        }
        this.dataSource = (DataSource)temp;
    }

    public void doInitialise() throws InitialisationException {
        super.doInitialise();
        try {
            if (this.dataSource == null) {
                this.initJndiContext();
                this.createDataSource();
            }
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(65, (Object)"Jdbc Connector"), (Throwable)e, (Object)this);
        }
    }

    public String[] getReadAndAckStatements(UMOEndpointURI endpointUri, UMOEndpoint endpoint) {
        String readStmt = null;
        String str = endpointUri.getParams().getProperty("sql");
        readStmt = str != null ? str : endpointUri.getAddress();
        String ackStmt = null;
        str = endpointUri.getParams().getProperty("ack");
        if (str != null) {
            ackStmt = str;
            if ((str = this.getQuery(endpoint, ackStmt)) != null) {
                ackStmt = str;
            }
        } else {
            ackStmt = readStmt + ".ack";
            str = this.getQuery(endpoint, ackStmt);
            ackStmt = str != null ? str : null;
        }
        if ((str = this.getQuery(endpoint, readStmt)) != null) {
            readStmt = str;
        }
        if (readStmt == null) {
            throw new IllegalArgumentException("Read statement should not be null");
        }
        if (!"select".equalsIgnoreCase(readStmt.substring(0, 6))) {
            throw new IllegalArgumentException("Read statement should be a select sql statement");
        }
        if (!(ackStmt == null || "insert".equalsIgnoreCase(ackStmt.substring(0, 6)) || "update".equalsIgnoreCase(ackStmt.substring(0, 6)) || "delete".equalsIgnoreCase(ackStmt.substring(0, 6)))) {
            throw new IllegalArgumentException("Ack statement should be an insert / update / delete sql statement");
        }
        return new String[]{readStmt, ackStmt};
    }

    public String getQuery(UMOEndpoint endpoint, String stmt) {
        Object queries;
        Object query = null;
        if (endpoint != null && endpoint.getProperties() != null && (queries = endpoint.getProperties().get("queries")) instanceof Map) {
            query = ((Map)queries).get(stmt);
        }
        if (query == null && this.queries != null) {
            query = this.queries.get(stmt);
        }
        return query == null ? null : query.toString();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    public Map getQueries() {
        return this.queries;
    }

    public void setQueries(Map queries) {
        this.queries = queries;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public Context getJndiContext() {
        return this.jndiContext;
    }

    public void setJndiContext(Context jndiContext) {
        this.jndiContext = jndiContext;
    }

    public String getJndiInitialFactory() {
        return this.jndiInitialFactory;
    }

    public void setJndiInitialFactory(String jndiInitialFactory) {
        this.jndiInitialFactory = jndiInitialFactory;
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
    }

    public Map getProviderProperties() {
        return this.providerProperties;
    }

    public void setProviderProperties(Map providerProperties) {
        this.providerProperties = providerProperties;
    }

    public Object getSessionFactory(UMOEndpoint endpoint) throws Exception {
        return this.dataSource;
    }

    public Connection getConnection() throws Exception {
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)this.dataSource)) {
            this.logger.debug((Object)"Retrieving connection from current transaction");
            return (Connection)tx.getResource((Object)this.dataSource);
        }
        this.logger.debug((Object)"Retrieving new connection from data source");
        Connection con = this.dataSource.getConnection();
        if (tx != null) {
            this.logger.debug((Object)"Binding connection to current transaction");
            try {
                tx.bindResource((Object)this.dataSource, (Object)con);
            }
            catch (TransactionException e) {
                throw new RuntimeException("Could not bind connection to current transaction", e);
            }
        }
        return con;
    }
}

