/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.jdbc.JdbcConnector;
import org.mule.providers.jdbc.JdbcUtils;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.ConnectorException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class JdbcMessageDispatcher
extends AbstractMessageDispatcher {
    private JdbcConnector connector;

    public JdbcMessageDispatcher(JdbcConnector connector) {
        super((AbstractConnector)connector);
        this.connector = connector;
    }

    public void doDispose() {
    }

    public void doDispatch(UMOEvent event) throws Exception {
        UMOEndpointURI endpointURI;
        String writeStmt;
        UMOEndpoint endpoint;
        String str;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Dispatch event: " + event));
        }
        if ((str = this.connector.getQuery(endpoint = event.getEndpoint(), writeStmt = (endpointURI = endpoint.getEndpointURI()).getAddress())) != null) {
            writeStmt = str;
        }
        if (writeStmt == null) {
            throw new IllegalArgumentException("Write statement should not be null");
        }
        if (!("insert".equalsIgnoreCase(writeStmt.substring(0, 6)) || "update".equalsIgnoreCase(writeStmt.substring(0, 6)) || "delete".equalsIgnoreCase(writeStmt.substring(0, 6)))) {
            throw new IllegalArgumentException("Write statement should be an insert / update / delete sql statement");
        }
        ArrayList paramNames = new ArrayList();
        writeStmt = JdbcUtils.parseStatement(writeStmt, paramNames);
        Object[] paramValues = JdbcUtils.getParams(endpointURI, paramNames, event.getTransformedMessage());
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        Connection con = null;
        try {
            con = this.connector.getConnection();
            int nbRows = new QueryRunner().update(con, writeStmt, paramValues);
            if (nbRows != 1) {
                this.logger.warn((Object)("Row count for write should be 1 and not " + nbRows));
            }
            if (tx == null) {
                JdbcUtils.commitAndClose(con);
            }
            this.logger.debug((Object)"Event dispatched succesfuly");
        }
        catch (Exception e) {
            this.logger.debug((Object)("Error dispatching event: " + e.getMessage()), (Throwable)e);
            if (tx == null) {
                JdbcUtils.rollbackAndClose(con);
            }
            throw e;
        }
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Trying to receive a message with a timeout of " + timeout));
        }
        String[] stmts = this.connector.getReadAndAckStatements(endpointUri, null);
        String readStmt = stmts[0];
        String ackStmt = stmts[1];
        ArrayList readParams = new ArrayList();
        ArrayList ackParams = new ArrayList();
        readStmt = JdbcUtils.parseStatement(readStmt, readParams);
        ackStmt = JdbcUtils.parseStatement(ackStmt, ackParams);
        Connection con = null;
        long t0 = System.currentTimeMillis();
        try {
            int nbRows;
            Object result;
            block9: {
                con = this.connector.getConnection();
                if (timeout < 0L) {
                    timeout = Long.MAX_VALUE;
                }
                result = null;
                while (true) {
                    if ((result = new QueryRunner().query(con, readStmt, JdbcUtils.getParams(endpointUri, readParams, null), (ResultSetHandler)new MapHandler())) != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Received: " + result));
                        }
                        break block9;
                    }
                    long sleep = Math.min(this.connector.getPollingFrequency(), timeout - (System.currentTimeMillis() - t0));
                    if (sleep <= 0L) break;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("No results, sleeping for " + sleep));
                    }
                    Thread.sleep(sleep);
                }
                this.logger.debug((Object)"Timeout");
                return null;
            }
            if (result != null && ackStmt != null && (nbRows = new QueryRunner().update(con, ackStmt, JdbcUtils.getParams(endpointUri, ackParams, result))) != 1) {
                this.logger.warn((Object)("Row count for ack should be 1 and not " + nbRows));
            }
            UMOMessageAdapter msgAdapter = this.connector.getMessageAdapter(result);
            MuleMessage message = new MuleMessage((Object)msgAdapter);
            JdbcUtils.commitAndClose(con);
            return message;
        }
        catch (Exception e) {
            JdbcUtils.rollbackAndClose(con);
            throw e;
        }
    }

    public Object getDelegateSession() throws UMOException {
        try {
            return this.connector.getConnection();
        }
        catch (Exception e) {
            throw new ConnectorException(new Message(65, (Object)"Jdbc Connection"), (UMOConnector)this.connector, (Throwable)e);
        }
    }
}

