/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.mule.impl.MuleMessage;
import org.mule.providers.ConnectException;
import org.mule.providers.TransactedPollingMessageReceiver;
import org.mule.providers.jdbc.JdbcConnector;
import org.mule.providers.jdbc.JdbcUtils;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class JdbcMessageReceiver
extends TransactedPollingMessageReceiver {
    private JdbcConnector connector;
    private String readStmt;
    private String ackStmt;
    private List readParams;
    private List ackParams;

    public JdbcMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, String readStmt, String ackStmt) throws InitialisationException {
        super(connector, component, endpoint, new Long(((JdbcConnector)connector).getPollingFrequency()));
        this.receiveMessagesInTransaction = false;
        this.connector = (JdbcConnector)connector;
        this.readParams = new ArrayList();
        this.readStmt = JdbcUtils.parseStatement(readStmt, this.readParams);
        this.ackParams = new ArrayList();
        this.ackStmt = JdbcUtils.parseStatement(ackStmt, this.ackParams);
    }

    public void doConnect() throws Exception {
        Connection con = null;
        try {
            con = this.connector.getConnection();
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Object)this);
        }
        finally {
            JdbcUtils.close(con);
        }
    }

    public void doDisconnect() throws ConnectException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(Object message) throws Exception {
        Connection con = null;
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            Object[] ackParams;
            int nbRows;
            con = this.connector.getConnection();
            if (this.ackStmt != null && (nbRows = new QueryRunner().update(con, this.ackStmt, ackParams = JdbcUtils.getParams(this.getEndpointURI(), this.ackParams, message))) != 1) {
                this.logger.warn((Object)("Row count for ack should be 1 and not " + nbRows));
            }
            UMOMessageAdapter msgAdapter = this.connector.getMessageAdapter(message);
            MuleMessage umoMessage = new MuleMessage((Object)msgAdapter);
            this.routeMessage((UMOMessage)umoMessage, tx, tx != null || this.endpoint.isSynchronous());
        }
        finally {
            if (tx == null) {
                JdbcUtils.close(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessages() throws Exception {
        List list;
        Connection con = null;
        try {
            try {
                con = this.connector.getConnection();
            }
            catch (SQLException e) {
                throw new ConnectException((Throwable)e, (Object)this);
            }
            Object[] readParams = JdbcUtils.getParams(this.getEndpointURI(), this.readParams, null);
            Object results = new QueryRunner().query(con, this.readStmt, readParams, (ResultSetHandler)new MapListHandler());
            list = (List)results;
        }
        catch (Throwable throwable) {
            JdbcUtils.close(con);
            throw throwable;
        }
        JdbcUtils.close(con);
        return list;
    }
}

