/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.mule.umo.endpoint.UMOEndpointURI;

public abstract class JdbcUtils {
    public static void close(Connection con) throws SQLException {
        if (con != null) {
            con.close();
        }
    }

    public static void commitAndClose(Connection con) throws SQLException {
        if (con != null) {
            if (!con.getAutoCommit()) {
                con.commit();
            }
            con.close();
        }
    }

    public static void rollbackAndClose(Connection con) throws SQLException {
        if (con != null) {
            if (!con.getAutoCommit()) {
                con.rollback();
            }
            con.close();
        }
    }

    public static String parseStatement(String stmt, List params) {
        if (stmt == null) {
            return stmt;
        }
        Pattern p = Pattern.compile("\\$\\{[^\\}]*\\}");
        Matcher m = p.matcher(stmt);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String key = m.group();
            m.appendReplacement(sb, "?");
            params.add(key);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static Object[] getParams(UMOEndpointURI uri, List paramNames, Object root) throws Exception {
        Object[] params = new Object[paramNames.size()];
        for (int i = 0; i < paramNames.size(); ++i) {
            Node node;
            String param = (String)paramNames.get(i);
            String name = param.substring(2, param.length() - 1);
            Object value = null;
            if ("NOW".equalsIgnoreCase(name)) {
                value = new Timestamp(Calendar.getInstance().getTimeInMillis());
            } else if (root instanceof org.w3c.dom.Document) {
                org.w3c.dom.Document x3cDoc = (org.w3c.dom.Document)root;
                Document dom4jDoc = new DOMReader().read(x3cDoc);
                try {
                    Node node2 = dom4jDoc.selectSingleNode(name);
                    if (node2 != null) {
                        value = node2.getText();
                    }
                }
                catch (Exception ignored) {
                    value = null;
                }
            } else if (root instanceof Document) {
                Document dom4jDoc = (Document)root;
                try {
                    node = dom4jDoc.selectSingleNode(name);
                    if (node != null) {
                        value = node.getText();
                    }
                }
                catch (Exception ignored) {
                    value = null;
                }
            } else if (root instanceof Node) {
                Node dom4jNode = (Node)root;
                try {
                    node = dom4jNode.selectSingleNode(name);
                    if (node != null) {
                        value = node.getText();
                    }
                }
                catch (Exception ignored) {
                    value = null;
                }
            } else {
                try {
                    value = BeanUtils.getProperty((Object)root, (String)name);
                }
                catch (Exception ignored) {
                    value = null;
                }
            }
            if (value == null) {
                value = uri.getParams().getProperty(name);
            }
            if (name.equals("payload")) {
                value = root;
            }
            if (value == null) {
                throw new IllegalArgumentException("Can not retrieve argument " + name);
            }
            params[i] = value;
        }
        return params;
    }
}

