/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface SetIf {
    public String value();

    public SetIfCondition condition() default SetIfCondition.matches;

    public static final class ConditionChecker {
        private ConditionChecker() {
        }

        public static boolean satisfyCondition(SetIf annotation, String attributeName) {
            switch (annotation.condition()) {
                case startsWith: {
                    return attributeName.startsWith(annotation.value());
                }
                case contains: {
                    return attributeName.contains(annotation.value());
                }
                case matches: {
                    return attributeName.matches(annotation.value());
                }
            }
            throw new AssertionError((Object)("Unsupported setif conndition " + (Object)((Object)annotation.condition())));
        }
    }

    public static enum SetIfCondition {
        startsWith,
        contains,
        matches;

    }
}

