/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.mbean;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.configureme.ConfigurationManager;
import org.configureme.Environment;
import org.configureme.mbean.ConfigInfoMBean;
import org.configureme.repository.Artefact;
import org.configureme.repository.ConfigurationRepository;
import org.configureme.repository.Value;
import org.configureme.sources.ConfigurationSourceKey;
import org.configureme.sources.ConfigurationSourceRegistry;

public class ConfigInfo
implements ConfigInfoMBean {
    private String configName;

    public ConfigInfo(String configName) {
        this.configName = configName;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String showContent() {
        return ConfigurationSourceRegistry.INSTANCE.readConfigurationSource(ConfigurationSourceKey.jsonFile(this.getConfigName()));
    }

    @Override
    public Map<String, Object> getAttributes() {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        Environment defaultEnvironment = ConfigurationManager.INSTANCE.getDefaultEnvironment();
        Artefact artefact = ConfigurationRepository.INSTANCE.getArtefact(this.configName);
        if (artefact == null) {
            return attributeMap;
        }
        Iterator<String> i$ = artefact.getAttributeNames().iterator();
        while (i$.hasNext()) {
            String attrName;
            Value attrValue = artefact.getAttribute(attrName = i$.next()).getValue(defaultEnvironment);
            attributeMap.put(attrName, attrValue == null ? "" : attrValue.getRaw());
        }
        return attributeMap;
    }
}

