/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.parser.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.anotheria.util.StringUtils;
import org.apache.log4j.Logger;
import org.configureme.Environment;
import org.configureme.environments.DynamicEnvironment;
import org.configureme.parser.ArrayParsedAttribute;
import org.configureme.parser.CompositeParsedAttribute;
import org.configureme.parser.ConfigurationParser;
import org.configureme.parser.ConfigurationParserException;
import org.configureme.parser.IncludeParsedAttribute;
import org.configureme.parser.ParsedAttribute;
import org.configureme.parser.ParsedConfiguration;
import org.configureme.parser.PlainParsedAttribute;
import org.configureme.sources.ConfigurationSourceKey;
import org.configureme.sources.ConfigurationSourceRegistry;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonParser
implements ConfigurationParser {
    private static final String COMPOSITE_ATTR_PREFIX = "@";
    private static final String INCLUDE_ATTR_PREFIX = "$<";
    private static Map<String, Set<String>> includes = new HashMap<String, Set<String>>();
    private static final Logger log = Logger.getLogger(JsonParser.class);

    @Override
    public ParsedConfiguration parseConfiguration(String name, String content) throws ConfigurationParserException {
        content = StringUtils.removeCComments((String)content);
        content = StringUtils.removeCPPComments((String)content);
        Set<String> include = includes.get(name);
        if (include == null) {
            include = new HashSet<String>();
        }
        include.clear();
        include.add(name);
        content = this.includeExternalFiles(content, include);
        List tags = StringUtils.extractTags((String)content, (char)'$', (char)'}');
        for (String tag : tags) {
            if (tag.charAt(1) != '{') continue;
            try {
                String propertyName = tag.substring(2, tag.length() - 1);
                String propertyValue = System.getProperty(propertyName);
                if (propertyValue == null) continue;
                content = StringUtils.replaceOnce((String)content, (String)tag, (String)propertyValue);
            }
            catch (Exception e) {
                log.warn((Object)("parseConfiguration: tag=" + tag + " can't be parsed"), (Throwable)e);
            }
        }
        try {
            JSONObject j = new JSONObject(content);
            ParsedConfiguration pa = new ParsedConfiguration(name);
            DynamicEnvironment env = new DynamicEnvironment();
            String[] names = JSONObject.getNames((JSONObject)j);
            if (names != null) {
                for (String key : names) {
                    List<ParsedAttribute<?>> attList = JsonParser.parse(key, j.get(key), env);
                    for (ParsedAttribute<?> att : attList) {
                        pa.addAttribute(att);
                    }
                }
            }
            include.remove(name);
            pa.setExternalConfigurations(include);
            includes.put(name, include);
            return pa;
        }
        catch (JSONException e) {
            throw new ConfigurationParserException("JSON Error", e);
        }
    }

    private String includeExternalFiles(String content, Collection<String> configurationNames) throws ConfigurationParserException {
        List includes = StringUtils.extractTags((String)content, (char)'$', (char)'>');
        for (String include : includes) {
            if (include.charAt(1) != '<' || include.charAt(include.length() - 1) != '>') continue;
            String includeName = include.substring(2, include.length() - 1);
            if (configurationNames.contains(includeName)) {
                throw new ConfigurationParserException("Circle detected: configuration=" + includeName + " was already included");
            }
            if (include.contains(".")) continue;
            try {
                configurationNames.add(includeName);
                String includedContent = this.includeExternalFiles(this.readIncludedContent(includeName), configurationNames);
                content = StringUtils.replaceOnce((String)content, (String)include, (String)includedContent);
            }
            catch (Exception e) {
                log.warn((Object)("includeExternalFiles: include=" + include + " can't be parsed"), (Throwable)e);
            }
        }
        return content;
    }

    private String readIncludedContent(String includeName) {
        ConfigurationSourceKey configurationSourceKey = new ConfigurationSourceKey(ConfigurationSourceKey.Type.FILE, ConfigurationSourceKey.Format.JSON, includeName);
        String result = ConfigurationSourceRegistry.INSTANCE.readConfigurationSource(configurationSourceKey);
        result = StringUtils.strip((String)result, (int)1, (int)1);
        return result;
    }

    private static List<? extends ParsedAttribute<?>> parse(String key, Object value, DynamicEnvironment environment) throws JSONException {
        if (value instanceof JSONObject && key.startsWith(COMPOSITE_ATTR_PREFIX)) {
            return Arrays.asList(JsonParser.parseComposite(key, (JSONObject)value, environment));
        }
        if (value instanceof JSONArray && key.startsWith(COMPOSITE_ATTR_PREFIX)) {
            return Arrays.asList(JsonParser.parseArray(key, (JSONArray)value, environment));
        }
        if (value instanceof String && ((String)value).startsWith(INCLUDE_ATTR_PREFIX)) {
            return Arrays.asList(JsonParser.parseInclude(key, (String)value, environment));
        }
        if (value instanceof JSONObject) {
            return JsonParser.parseObject(key, (JSONObject)value, environment);
        }
        if (value instanceof JSONArray) {
            return Arrays.asList(JsonParser.parseArray(key, (JSONArray)value, environment));
        }
        return Arrays.asList(new PlainParsedAttribute(key, (Environment)environment.clone(), JSONObject.NULL.equals(value) ? null : value.toString()));
    }

    private static IncludeParsedAttribute parseInclude(String key, String value, DynamicEnvironment environment) throws JSONException {
        return new IncludeParsedAttribute(key, (Environment)environment.clone(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ParsedAttribute<?>> parseObject(String key, JSONObject value, DynamicEnvironment environment) throws JSONException {
        ArrayList parsed = new ArrayList();
        environment.extendThis(key);
        try {
            String[] names = JSONObject.getNames((JSONObject)value);
            if (names != null) {
                for (String subKey : names) {
                    parsed.addAll(JsonParser.parse(subKey, value.get(subKey), environment));
                }
            }
        }
        finally {
            environment.reduceThis();
        }
        return parsed;
    }

    private static CompositeParsedAttribute parseComposite(String key, JSONObject value, DynamicEnvironment environment) throws JSONException {
        String[] names = JSONObject.getNames((JSONObject)value);
        if (names == null) {
            return new CompositeParsedAttribute(JsonParser.stripKey(key), (Environment)environment.clone(), Collections.emptyList());
        }
        ArrayList leafAttr = new ArrayList();
        for (String subKey : names) {
            leafAttr.addAll(JsonParser.parse(subKey, value.get(subKey), environment));
        }
        return new CompositeParsedAttribute(JsonParser.stripKey(key), (Environment)environment.clone(), leafAttr);
    }

    private static ArrayParsedAttribute parseArray(String key, JSONArray value, DynamicEnvironment environment) throws JSONException {
        ArrayList parsed = new ArrayList(value.length());
        for (int index = 0; index < value.length(); ++index) {
            parsed.addAll(JsonParser.parse(key, value.get(index), environment));
        }
        return new ArrayParsedAttribute(JsonParser.stripKey(key), (Environment)environment.clone(), parsed);
    }

    private static String stripKey(String key) {
        return key.startsWith(COMPOSITE_ATTR_PREFIX) ? key.substring(COMPOSITE_ATTR_PREFIX.length()) : key;
    }
}

