/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.repository;

import java.util.HashMap;
import java.util.Map;
import org.configureme.Configuration;
import org.configureme.repository.ConfigurationImpl;
import org.configureme.repository.Value;

public class CompositeValue
implements Value {
    private final ConfigurationImpl config;

    public CompositeValue(String name, Map<String, Value> value) {
        this.config = new ConfigurationImpl(name);
        for (Map.Entry<String, Value> attr : value.entrySet()) {
            this.config.setAttribute(attr.getKey(), attr.getValue());
        }
    }

    public Configuration get() {
        return this.config;
    }

    @Override
    public Object getRaw() {
        HashMap<String, Object> raw = new HashMap<String, Object>(this.config.getEntries().size());
        for (Map.Entry<String, Value> entry : this.config.getEntries()) {
            raw.put(entry.getKey(), entry.getValue().getRaw());
        }
        return raw;
    }

    public String toString() {
        return String.valueOf(this.config);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeValue)) {
            return false;
        }
        CompositeValue other = (CompositeValue)obj;
        return !(this.config == null ? other.config != null : !this.config.equals(other.config));
    }
}

