/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.repository;

import org.configureme.Configuration;
import org.configureme.ConfigurationManager;
import org.configureme.Environment;
import org.configureme.repository.ConfigurationImpl;
import org.configureme.repository.Value;
import org.configureme.sources.ConfigurationSourceKey;

public class IncludeValue
implements Value {
    private Configuration config;
    private final String attributeName;

    public IncludeValue() {
        this.config = new ConfigurationImpl(null);
        this.attributeName = "";
    }

    @Override
    public Object getRaw() {
        return this.config.getAttribute(this.attributeName);
    }

    public ConfigurationSourceKey getConfigName() {
        return new ConfigurationSourceKey(ConfigurationSourceKey.Type.FILE, ConfigurationSourceKey.Format.JSON, this.config.getName());
    }

    public IncludeValue(Environment environment, String configurationName, String attributeName) {
        this.config = ConfigurationManager.INSTANCE.getConfiguration(configurationName, environment);
        this.attributeName = attributeName;
    }

    public String toString() {
        return String.valueOf(this.config);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncludeValue that = (IncludeValue)o;
        if (this.attributeName != null ? !this.attributeName.equals(that.attributeName) : that.attributeName != null) {
            return false;
        }
        return !(this.config != null ? !this.config.equals(that.config) : that.config != null);
    }

    public int hashCode() {
        int result = this.config != null ? this.config.hashCode() : 0;
        result = 31 * result + (this.attributeName != null ? this.attributeName.hashCode() : 0);
        return result;
    }
}

