/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.environments;

import java.util.Locale;
import org.configureme.Environment;
import org.configureme.GlobalEnvironment;

public class LocaleBasedEnvironment
implements Environment {
    private Locale locale;

    public LocaleBasedEnvironment(Locale aLocale) {
        this.locale = new Locale(aLocale.getLanguage().trim(), aLocale.getCountry().trim(), aLocale.getVariant().trim());
    }

    private LocaleBasedEnvironment(Builder builder) {
        this.locale = new Locale(builder.language, builder.country, builder.variant);
    }

    public String toString() {
        return this.locale.toString();
    }

    @Override
    public String expandedStringForm() {
        return this.toString();
    }

    @Override
    public boolean isReduceable() {
        return !LocaleBasedEnvironment.isEmpty(this.locale.getLanguage());
    }

    @Override
    public Environment reduce() {
        if (!LocaleBasedEnvironment.isEmpty(this.locale.getVariant())) {
            return new LocaleBasedEnvironment(new Locale(this.locale.getLanguage(), this.locale.getCountry(), LocaleBasedEnvironment.reduceVariant(this.locale.getVariant())));
        }
        if (!LocaleBasedEnvironment.isEmpty(this.locale.getCountry())) {
            return new LocaleBasedEnvironment(new Locale(this.locale.getLanguage()));
        }
        if (!LocaleBasedEnvironment.isEmpty(this.locale.getLanguage())) {
            return GlobalEnvironment.INSTANCE;
        }
        throw new AssertionError((Object)"Can't happen, have you called isReduceable() previous to reduce()?");
    }

    private static String reduceVariant(String variant) {
        if (LocaleBasedEnvironment.isEmpty(variant)) {
            throw new AssertionError((Object)"Shouldn't happen, can't reduce non existent variant");
        }
        int indexOfUnderscore = variant.lastIndexOf(95);
        if (indexOfUnderscore == -1) {
            return "";
        }
        return variant.substring(0, indexOfUnderscore);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public boolean equals(Object o) {
        return o instanceof LocaleBasedEnvironment && ((LocaleBasedEnvironment)o).locale.equals(this.locale);
    }

    public int hashCode() {
        return this.locale == null ? 42 : this.locale.hashCode();
    }

    public static class Builder {
        private String language;
        private String country;
        private String variant;

        public Builder() {
            this.language = "";
            this.country = "";
            this.variant = "";
        }

        public Builder(Locale aLocale) {
            this.language = aLocale.getLanguage();
            this.country = aLocale.getCountry();
            this.variant = aLocale.getVariant();
        }

        public LocaleBasedEnvironment build() {
            return new LocaleBasedEnvironment(this);
        }

        public Builder country(String value) {
            this.country = value.trim();
            return this;
        }

        public Builder language(String value) {
            this.language = value.trim();
            return this;
        }

        public Builder variant(String value) {
            this.variant = value.trim();
            return this;
        }
    }
}

