/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.mbean.util;

import java.lang.management.ManagementFactory;
import java.security.AccessControlException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.anotheria.util.log.LogMessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MBeanRegisterUtil {
    private static final Logger log = LoggerFactory.getLogger(MBeanRegisterUtil.class);
    private static MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

    public static void regMBean(Object object, String ... parameters) {
        try {
            String name = MBeanRegisterUtil.buildObjectName(object, parameters);
            ObjectName objectName = new ObjectName(name);
            if (mbs.isRegistered(objectName)) {
                return;
            }
            mbs.registerMBean(object, objectName);
        }
        catch (MalformedObjectNameException e) {
            log.error(LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{object}));
        }
        catch (InstanceAlreadyExistsException e) {
            log.error(LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{object, object}));
        }
        catch (MBeanRegistrationException e) {
            log.error(LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{object, object}));
        }
        catch (NotCompliantMBeanException e) {
            log.error(LogMessageUtil.failMsg((Throwable)e, (Object[])new Object[]{object, object}));
        }
        catch (AccessControlException e) {
            log.error("Access denied, can no register mbean add permission javax.management.MBeanTrustPermission \"register\"; to java.policy file", (Throwable)e);
        }
    }

    private static String buildObjectName(Object object, String ... parameters) {
        StringBuilder objectName = new StringBuilder();
        objectName.append(object.getClass().getPackage().getName());
        objectName.append(":type=");
        objectName.append(object.getClass().getName());
        if (parameters.length > 0) {
            objectName.append("(");
            for (String parameter : parameters) {
                objectName.append(parameter).append(",");
            }
            objectName.deleteCharAt(objectName.length() - 1);
            objectName.append(")");
        }
        return objectName.toString();
    }

    private MBeanRegisterUtil() {
        throw new IllegalAccessError("Can't be initialise");
    }
}

