/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.configureme.Environment;
import org.configureme.GlobalEnvironment;
import org.configureme.repository.Attribute;
import org.configureme.repository.IncludeValue;
import org.configureme.repository.Value;
import org.configureme.sources.ConfigurationSourceKey;

public class Artefact {
    private String name;
    private Map<String, Attribute> attributes;
    private Map<Environment, Map<String, Object>> contentMap;
    private List<ConfigurationSourceKey> externalConfigurations;

    Artefact(String aName) {
        this.name = aName;
        this.attributes = new ConcurrentHashMap<String, Attribute>();
        this.externalConfigurations = new ArrayList<ConfigurationSourceKey>();
        this.contentMap = new HashMap<Environment, Map<String, Object>>();
    }

    public List<ConfigurationSourceKey> getExternalConfigurations() {
        return this.externalConfigurations;
    }

    public void addExternalConfigurations(ConfigurationSourceKey configurationSourceKey) {
        if (configurationSourceKey == null) {
            return;
        }
        this.externalConfigurations.add(configurationSourceKey);
    }

    public Attribute getAttribute(String attributeName) {
        Attribute a = this.attributes.get(attributeName);
        if (a == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " doesn't exists");
        }
        return a;
    }

    public void addAttributeValue(String attributeName, Value attributeValue, Environment in) {
        Attribute attr;
        if (in == null) {
            in = GlobalEnvironment.INSTANCE;
        }
        if ((attr = this.attributes.get(attributeName)) == null) {
            attr = new Attribute(attributeName);
            this.attributes.put(attr.getName(), attr);
        }
        attr.addValue(attributeValue, in);
        Map<String, Object> valueMap = this.contentMap.get(in);
        if (valueMap == null) {
            valueMap = new HashMap<String, Object>();
        }
        valueMap.put(attributeName, attributeValue.getRaw());
        this.contentMap.put(in, valueMap);
        if (attributeValue instanceof IncludeValue) {
            this.externalConfigurations.add(((IncludeValue)attributeValue).getConfigName());
        }
    }

    public Map<Environment, Map<String, Object>> getContent() {
        return this.contentMap;
    }

    public String toString() {
        return this.getName() + ": " + this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.attributes.keySet());
        return names;
    }
}

